<?php
declare(strict_types=1);

/**
 * SOL - Sistema de Operaciones Logísticas
 * Vista: views/parametros/grupos/index.php
 * P1: tabla vacía con DataTables + scripts específicos.
 */

// Ir a la raíz del proyecto desde esta vista: views/parametros/grupos/index.php
$BASE = dirname(__DIR__, 3); // grupos -> parametros -> views -> raíz

require_once $BASE . '/app/Support/ViewHelpers.php';
require_once $BASE . '/app/Support/Assets.php';

// -------------------------
// Meta
// -------------------------
sol_section('page_title', 'Grupos');

// -------------------------
// DataTables + script de la página
// -------------------------
sol_dt_assets('/page-scripts/pages/parametros/grupos_scripts.js');

// -------------------------
// Variables para el partial de tabla
// -------------------------
$tableId          = 'gruposTable';
$tableDescription = 'Listado de grupos de productos';

// -------------------------
// Contenido principal
// -------------------------
ob_start();
include project_path('views/layout/_partials/table-def.php');
$content = ob_get_clean();

// -------------------------
// Render del layout
// -------------------------
include project_path('views/layout/layout_app.php');
