<?php
declare(strict_types=1);

/**
 * SOL - Sistema de Operaciones Logísticas
 * Vista: views/parametros/index.php
 * Panel de accesos rápidos para catálogos y maestros del sistema.
 */

$BASE = dirname(__DIR__, 2);

require_once $BASE . '/app/Support/ViewHelpers.php';
require_once $BASE . '/app/Support/Assets.php';

sol_section('page_title', 'Parámetros');
sol_section('breadcrumb', [
    ['label' => 'Inicio', 'url' => '/home'],
    ['label' => 'Parámetros', 'url' => null],
]);

sol_section('page_header', '<div class="d-flex flex-column flex-sm-row align-items-sm-center gap-2">'
    . '<h5 class="m-0">Parámetros del sistema</h5>'
    . '<span class="text-muted">Administra catálogos maestros y configuraciones.</span>'
    . '</div>');

$sections = [
    [
        'title'       => 'Parámetros',
        'subtitle'    => 'Maestros y catálogos del sistema',
        'icon'        => 'bi-gear',
        'accent'      => 'secondary',
        'text_color'  => 'text-white',
        'link_accent' => 'secondary',
        'links'       => [
            ['label' => 'Choferes', 'url' => '/parametros/choferes'],
            ['label' => 'Clases', 'url' => '/parametros/clases'],
            ['label' => 'Clientes', 'url' => '/parametros/clientes'],
            ['label' => 'Destinatarios', 'url' => '/parametros/destinatarios'],
            ['label' => 'Grupos de Productos', 'url' => '/parametros/grupos'],
            ['label' => 'Productos', 'url' => '/parametros/productos'],
            ['label' => 'Móviles', 'url' => '/parametros/moviles'],
            ['label' => 'Transportadoras', 'url' => '/parametros/transportadoras'],
        ],
    ],
];

if (!function_exists('e')) {
    function e(string $value): string
    {
        return htmlspecialchars($value, ENT_QUOTES, 'UTF-8');
    }
}

ob_start();
?>
<div class="row g-3 g-xl-4">
  <?php foreach ($sections as $section):
    $accent     = $section['accent'];
    $textClass  = $section['text_color'];
    $mutedClass = $textClass === 'text-dark' ? 'text-muted' : 'text-light';
    $linkAccent = $section['link_accent'];
  ?>
    <div class="col-12 col-md-6 col-xl-4">
      <div class="card quick-link-card border-0 shadow-sm h-100">
        <div class="card-header border-0 bg-<?= e($accent) ?> <?= e($textClass) ?> py-4">
          <div class="d-flex align-items-start gap-3">
            <span class="d-inline-flex align-items-center justify-content-center rounded-circle border border-light shadow-sm"
              style="width:3rem;height:3rem;background-color:rgba(255,255,255,0.15);">
              <i class="bi <?= e($section['icon']) ?> fs-4 <?= e($textClass) ?>"></i>
            </span>
            <div class="flex-grow-1">
              <h5 class="mb-1 fw-semibold <?= e($textClass) ?>"><?= e($section['title']) ?></h5>
              <small class="<?= e($mutedClass) ?> d-block"><?= e($section['subtitle']) ?></small>
            </div>
          </div>
        </div>
        <div class="card-body p-0">
          <div class="list-group list-group-flush">
            <?php foreach ($section['links'] as $link): ?>
              <a class="list-group-item list-group-item-action py-3 d-flex align-items-center justify-content-between"
                 href="<?= e(url($link['url'])) ?>">
                <span class="d-flex align-items-center gap-2">
                  <i class="bi bi-arrow-right-short fs-4 text-<?= e($linkAccent) ?>"></i>
                  <span class="fw-semibold"><?= e($link['label']) ?></span>
                </span>
                <i class="bi bi-chevron-right text-muted"></i>
              </a>
            <?php endforeach; ?>
          </div>
        </div>
      </div>
    </div>
  <?php endforeach; ?>
</div>
<?php
$content = ob_get_clean();

include project_path('views/layout/layout_app.php');
