<?php
declare(strict_types=1);

// ------------------------------------------------------------
// Helpers mínimos (no pisan si ya existen)
// ------------------------------------------------------------
if (!function_exists('sol_section')) {
  function sol_section(string $name, $value): void {
    $GLOBALS['__sol_sections'][$name] = $value;
  }
}
if (!function_exists('project_path')) {
  function project_path(string $rel): string {
    return rtrim(dirname(__DIR__, 2), DIRECTORY_SEPARATOR) . DIRECTORY_SEPARATOR . ltrim($rel, DIRECTORY_SEPARATOR);
  }
}
if (!function_exists('env')) {
  function env(string $key, $default = null) {
    return $_ENV[$key] ?? getenv($key) ?: $default;
  }
}
if (!function_exists('url')) {
  function url(string $path = '/'): string {
    $base = rtrim((string)env('BASE_URL', ''), '/');
    $path = '/' . ltrim($path, '/');
    return $base . $path;
  }
}

// ------------------------------------------------------------
// DataTables: asegurar función y cargar assets
// ------------------------------------------------------------
if (!function_exists('getDataTablesConfig')) {
  // carga perezosa del config si no está ya disponible
  $cfgFile = project_path('app/config/dataTablesConfig.php');
  if (is_file($cfgFile)) {
    require_once $cfgFile;
  }
}

$dataTablesConfig = function_exists('getDataTablesConfig')
  ? getDataTablesConfig()
  : ['scripts' => [], 'styles' => []];

// normalizador: acepta ['path'=>... ] o strings
$normalize = static function (array $items): array {
  $out = [];
  foreach ($items as $it) {
    if (is_string($it) && $it !== '') {
      $out[] = $it;
    } elseif (is_array($it) && !empty($it['path'])) {
      $out[] = (string)$it['path'];
    }
  }
  return $out;
};

$pageCss = $normalize($dataTablesConfig['styles']  ?? []);
$pageJs  = $normalize($dataTablesConfig['scripts'] ?? []);