<?php
declare(strict_types=1);

/**
 * SOL - Sistema de Operaciones Logísticas
 * Vista: views/parametros/moviles/index.php
 * P1: tabla vacía con DataTables + scripts específicos.
 */

// Raíz del proyecto desde esta vista: views/parametros/moviles/index.php
$BASE = dirname(__DIR__, 3); // moviles -> parametros -> views -> raíz

require_once $BASE . '/app/Support/ViewHelpers.php';
require_once $BASE . '/app/Support/Assets.php';

// -------------------------
// Meta
// -------------------------
sol_section('page_title', 'Móviles');

// -------------------------
// DataTables + script de la página
// -------------------------
sol_dt_assets('/page-scripts/pages/parametros/moviles_scripts.js');

// -------------------------
// Variables para el partial de tabla
// -------------------------
$tableId          = 'movilesTable';
$tableDescription = 'Listado de choferes';

// -------------------------
// Contenido principal
// -------------------------
ob_start();
include project_path('views/layout/_partials/table-def.php');
$content = ob_get_clean();

// -------------------------
// Render del layout
// -------------------------
include project_path('views/layout/layout_app.php');
