<?php
declare(strict_types=1);

/**
 * SOL - Sistema de Operaciones Logísticas
 * Vista: views/reportes/productos_por_vencer/index.php
 * Reporte: Productos por vencer (30/60/90 días)
 *
 * Requiere sesión. Usa layout_app.php y helpers sol_section(), sol_dt_assets()
 */

$BASE = dirname(__DIR__, 3);
require_once $BASE . '/app/Support/ViewHelpers.php';
require_once $BASE . '/app/Support/Assets.php';

sol_section('page_title', 'Reportes · Productos por vencer (30/60/90)');
sol_dt_assets('/page-scripts/pages/reportes/productos_por_vencer.js');

// Tabla
$tableId          = 'vencerTable';
$tableDescription = 'Agrupa por producto/lote con buckets de 0–30, 31–60 y 61–90 días';

ob_start();
?>

<!-- Toolbar -->
<div class="d-flex flex-wrap gap-2 mb-3">
  <a id="btnPdf" class="btn btn-primary btn-sm" target="_blank"
     href="<?= url('/api/reportes/productos_por_vencer_pdf.php') ?>">
    <i class="bi bi-filetype-pdf me-1"></i> Imprimir / Descargar PDF
  </a>
</div>

<!-- Filtros -->
<div class="card mb-3">
  <div class="card-body">
    <form id="frmVencer" class="row g-2">
      <div class="col-12 col-md-3">
        <label class="form-label">Cliente</label>
        <select class="form-select" id="fCliente" name="cliente_id">
          <option value="">(Todos)</option>
        </select>
      </div>
      <div class="col-12 col-md-3">
        <label class="form-label">Operativa</label>
        <select class="form-select" id="fOperativa" name="operativa_id">
          <option value="">(Todas)</option>
        </select>
      </div>
      <div class="col-12 col-md-3">
        <label class="form-label">Producto</label>
        <input type="text" class="form-control" id="fProducto" name="q_producto" placeholder="SKU o denominación…">
      </div>
      <div class="col-12 col-md-3">
        <label class="form-label">Lote</label>
        <input type="text" class="form-control" id="fLote" name="lote" placeholder="Ej: ABC123">
      </div>

      <div class="col-12 col-md-3">
        <label class="form-label">Rango</label>
        <select class="form-select" id="fBucket" name="bucket">
          <option value="-1" selected>Vencidos</option>
          <option value="30" selected>0–30 días</option>
          <option value="60">31–60 días</option>
          <option value="90">61–90 días</option>
          <option value="all">Todos (0–90)</option>
        </select>
      </div>

      <div class="col-12 col-md-3">
        <label class="form-label">Incluir vencidos</label>
        <select class="form-select" id="fVencidos" name="incluir_vencidos">
          <option value="no" selected>No</option>
          <option value="si">Sí (≤0 días)</option>
        </select>
      </div>

      <div class="col-12 col-md-3 d-flex align-items-end">
        <button type="submit" class="btn btn-primary w-100">Aplicar filtros</button>
      </div>
    </form>
  </div>
</div>

<?php
include project_path('views/layout/_partials/table-def.php'); // usa $tableId, $tableDescription
$content = ob_get_clean();

// Render
include project_path('views/layout/layout_app.php');
