<?php
declare(strict_types=1);

/**
 * SOL - Sistema de Operaciones Logísticas
 * Vista: views/recepcion/por_proveedor/index.php
 * Reporte: Productos recibidos por cliente
 */

$BASE = dirname(__DIR__, 3);
require_once $BASE . '/app/Support/ViewHelpers.php';
require_once $BASE . '/app/Support/Assets.php';

sol_section('page_title', 'Recepción · Productos recibidos por cliente');
sol_dt_assets('/page-scripts/pages/recepcion/por_proveedor.js');

$tableId          = 'recProvTable';
$tableDescription = 'Todos los ingresos (RECEPCIONES) agrupados por cliente y producto en el período.';

ob_start();
?>

<!-- Toolbar -->
<div class="d-flex flex-wrap gap-2 mb-3">
  <a id="btnPdfRecProv" class="btn btn-primary btn-sm" target="_blank"
     href="<?= url('/api/recepcion/por_proveedor_pdf.php') ?>">
    <i class="bi bi-filetype-pdf me-1"></i> Imprimir / Descargar PDF
  </a>
</div>

<!-- Filtros -->
<div class="card mb-3">
  <div class="card-body">
    <form id="frmRecProv" class="row g-2">
      <div class="col-12 col-md-3">
        <label class="form-label">Desde</label>
        <input type="date" class="form-control" id="fDesde" name="desde">
      </div>
      <div class="col-12 col-md-3">
        <label class="form-label">Hasta</label>
        <input type="date" class="form-control" id="fHasta" name="hasta">
      </div>
      <div class="col-12 col-md-3">
        <label class="form-label">Cliente</label>
        <select class="form-select" id="fCliente" name="cliente_id">
          <option value="">(Todos)</option>
        </select>
      </div>
      <div class="col-12 col-md-3">
        <label class="form-label">Operativa</label>
        <select class="form-select" id="fOperativa" name="operativa_id">
          <option value="">(Todas)</option>
        </select>
      </div>
      <div class="col-12 col-md-6">
        <label class="form-label">Producto (SKU o denominación)</label>
        <input type="text" class="form-control" id="fQ" name="q" placeholder="Buscar…">
      </div>
      <div class="col-12 col-md-3 d-flex align-items-end gap-2">
        <button type="submit" class="btn btn-primary flex-fill">Aplicar filtros</button>
        <button type="button" id="btnLimpiarFiltros" class="btn btn-warning text-dark">
          <i class="bi bi-x-circle"></i>
        </button>
      </div>
    </form>
  </div>
</div>

<?php
include project_path('views/layout/_partials/table-def.php'); // usa $tableId / $tableDescription
$content = ob_get_clean();
include project_path('views/layout/layout_app.php');
