<?php

declare(strict_types=1);

$BASE = dirname(__DIR__, 3);
require_once $BASE . '/app/Support/ViewHelpers.php';
require_once $BASE . '/app/Support/Assets.php';

sol_section('page_title', 'Reportes · Almacenamiento');
sol_section('breadcrumb', [
    ['label' => 'Inicio', 'url' => '/home'],
    ['label' => 'Reportes', 'url' => '/reportes'],
    ['label' => 'Almacenamiento', 'url' => null],
]);

sol_dt_assets('/page-scripts/pages/reportes/almacenamiento.js');

sol_section('additional_css', <<<'CSS'
<style>
.badge-indicador { border-radius: 999px; padding: .25rem .75rem; font-size: .75rem; }
.card-indicador { border-left: 4px solid transparent; transition: transform .2s ease, box-shadow .2s ease; }
.card-indicador.ok { border-left-color: #198754; }
.card-indicador.alerta { border-left-color: #ffc107; }
.card-indicador.critico { border-left-color: #dc3545; }
.card-indicador.sin-datos { border-left-color: #6c757d; }
.card-indicador:hover { transform: translateY(-2px); box-shadow: 0 4px 12px rgba(0,0,0,0.12); }
.table-semaforo span { display: inline-flex; align-items: center; gap: .35rem; }
.table-semaforo .dot { width: .6rem; height: .6rem; border-radius: 50%; display: inline-block; }
.table-semaforo .ok { background: #198754; }
.table-semaforo .alerta { background: #ffc107; }
.table-semaforo .critico { background: #dc3545; }
.table-semaforo .sin-datos { background: #6c757d; }
</style>
CSS);

ob_start();
?>
<div class="container-fluid py-4">
    <div class="row g-3 mb-3">
        <div class="col-lg-4">
            <div class="card h-100 shadow-sm">
                <div class="card-header">
                    <h5 class="card-title mb-0"><i class="bi bi-sliders me-2"></i>Filtros</h5>
                </div>
                <div class="card-body">
                    <form id="frmAlmacenamiento" class="row g-3">
                        <div class="col-12">
                            <label for="deposito_id" class="form-label">Depósito</label>
                            <select class="form-select" id="deposito_id" name="deposito_id">
                                <option value="">Todos</option>
                            </select>
                        </div>
                        <div class="col-12">
                            <label for="cliente_id" class="form-label">Cliente</label>
                            <select class="form-select" id="cliente_id" name="cliente_id">
                                <option value="">Todos</option>
                            </select>
                        </div>
                        <div class="col-6">
                            <label for="fecha_desde" class="form-label">Conteo desde</label>
                            <input type="date" class="form-control" id="fecha_desde" name="fecha_desde">
                        </div>
                        <div class="col-6">
                            <label for="fecha_hasta" class="form-label">Conteo hasta</label>
                            <input type="date" class="form-control" id="fecha_hasta" name="fecha_hasta">
                        </div>
                        <div class="col-6">
                            <label for="tolerancia_pct" class="form-label">Tolerancia (%)</label>
                            <input type="number" class="form-control" id="tolerancia_pct" name="tolerancia_pct" min="0.1" step="0.1" value="2">
                        </div>
                        <div class="col-6">
                            <label for="rotacion_dias" class="form-label">Ventana rotación (días)</label>
                            <input type="number" class="form-control" id="rotacion_dias" name="rotacion_dias" min="7" step="1" value="30">
                        </div>
                        <div class="col-12 d-flex gap-2">
                            <button type="submit" class="btn btn-primary flex-grow-1"><i class="bi bi-search me-1"></i>Aplicar</button>
                            <button type="button" id="btnLimpiar" class="btn btn-outline-secondary"><i class="bi bi-eraser me-1"></i>Limpiar</button>
                        </div>
                    </form>
                </div>
            </div>
        </div>
        <div class="col-lg-8">
            <div class="card shadow-sm h-100">
                <div class="card-header d-flex justify-content-between align-items-center">
                    <div>
                        <h5 class="card-title mb-0"><i class="bi bi-speedometer2 me-2"></i>Indicadores clave</h5>
                        <small class="text-muted">Comparativo entre inventario físico más reciente y stock registrado</small>
                    </div>
                    <span class="badge bg-secondary" id="badgeSkus">0 SKU</span>
                </div>
                <div class="card-body">
                    <div class="row g-3" id="indicadoresContainer">
                        <div class="col-md-6">
                            <div class="card card-indicador sin-datos h-100">
                                <div class="card-body">
                                    <div class="d-flex justify-content-between align-items-start mb-2">
                                        <h6 class="text-muted mb-0">Indicador</h6>
                                        <span class="badge bg-light text-muted">-</span>
                                    </div>
                                    <h3 class="fw-semibold" data-field="valor">-</h3>
                                    <small class="text-muted" data-field="descripcion">Sin datos disponibles</small>
                                </div>
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="card card-indicador sin-datos h-100">
                                <div class="card-body">
                                    <div class="d-flex justify-content-between align-items-start mb-2">
                                        <h6 class="text-muted mb-0">Indicador</h6>
                                        <span class="badge bg-light text-muted">-</span>
                                    </div>
                                    <h3 class="fw-semibold" data-field="valor">-</h3>
                                    <small class="text-muted" data-field="descripcion">Sin datos disponibles</small>
                                </div>
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="card card-indicador sin-datos h-100">
                                <div class="card-body">
                                    <div class="d-flex justify-content-between align-items-start mb-2">
                                        <h6 class="text-muted mb-0">Indicador</h6>
                                        <span class="badge bg-light text-muted">-</span>
                                    </div>
                                    <h3 class="fw-semibold" data-field="valor">-</h3>
                                    <small class="text-muted" data-field="descripcion">Sin datos disponibles</small>
                                </div>
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="card card-indicador sin-datos h-100">
                                <div class="card-body">
                                    <div class="d-flex justify-content-between align-items-start mb-2">
                                        <h6 class="text-muted mb-0">Indicador</h6>
                                        <span class="badge bg-light text-muted">-</span>
                                    </div>
                                    <h3 class="fw-semibold" data-field="valor">-</h3>
                                    <small class="text-muted" data-field="descripcion">Sin datos disponibles</small>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="card-footer bg-primary text-white">
                    <div class="row text-center">
                        <div class="col-md-3">
                            <div class="text-dark small">Exactitud global</div>
                            <div class="fw-semibold" id="summaryExactitud">-</div>
                        </div>
                        <div class="col-md-3">
                            <div class="text-dark small">SKUs fuera tolerancia</div>
                            <div class="fw-semibold" id="summaryFuera">-</div>
                        </div>
                        <div class="col-md-3">
                            <div class="text-dark small">Delta total (UC)</div>
                            <div class="fw-semibold" id="summaryDelta">-</div>
                        </div>
                        <div class="col-md-3">
                            <div class="text-dark small">Último inventario</div>
                            <div class="fw-semibold" id="summaryUltimo">-</div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <div class="card shadow-sm">
        <div class="card-header d-flex justify-content-between align-items-center">
            <div>
                <h5 class="card-title mb-0"><i class="bi bi-clipboard-data me-2"></i>Diferencias por SKU</h5>
                <small class="text-muted">Inventario físico más reciente vs stock registrado</small>
            </div>
            <div class="d-flex gap-2">
                <button type="button" class="btn btn-light btn-sm" id="btnExportCsv" disabled><i class="bi bi-download me-1"></i>Exportar</button>
            </div>
        </div>
        <div class="card-body">
            <div class="table-responsive">
                <table class="table table-striped table-hover align-middle" id="tblAlmacenamiento" width="100%">
                    <thead class="table-light">
                        <tr>
                            <th>SKU</th>
                            <th>Producto</th>
                            <th>Cliente</th>
                            <th>Depósito</th>
                            <th>Fecha conteo</th>
                            <th class="text-end">Inventario físico (UC)</th>
                            <th class="text-end">Stock actual (UC)</th>
                            <th class="text-end">Diferencia (UC)</th>
                            <th class="text-end">Variación %</th>
                            <th class="text-end">Exactitud %</th>
                            <th class="text-center">Semáforo</th>
                            <th>Observaciones</th>
                        </tr>
                    </thead>
                    <tbody>
                        <tr class="text-muted">
                            <td colspan="12" class="text-center py-4">
                                <div class="spinner-border spinner-border-sm me-2" role="status"></div>
                                Esperando filtros...
                            </td>
                        </tr>
                    </tbody>
                </table>
            </div>
        </div>
        <div class="card-footer bg-light small text-muted" id="summaryNotas">
            <i class="bi bi-info-circle me-1"></i>Configure la tolerancia para ajustar el semáforo de diferencias.
        </div>
    </div>
</div>
<?php
$content = ob_get_clean();
include project_path('views/layout/layout_app.php');
