<?php
declare(strict_types=1);

/**
 * SOL - Sistema de Operaciones Logísticas
 * Vista: Reporte de Capacidades de Bodega
 */

$BASE = dirname(__DIR__, 3); // embarques_tiempos -> reportes -> views -> raíz
require_once $BASE . '/app/Support/ViewHelpers.php';
require_once $BASE . '/app/Support/Assets.php';

sol_section('page_title', 'Reportes · Capacidades de Bodega');

// Cargar Chart.js para gráficos
sol_section('additional_css', '
<style>
.stat-card {
    border-left: 4px solid #0d6efd;
    transition: all 0.3s ease;
}
.stat-card:hover {
    box-shadow: 0 4px 12px rgba(0,0,0,0.15);
    transform: translateY(-2px);
}
.stat-card.success { border-left-color: #198754; }
.stat-card.warning { border-left-color: #ffc107; }
.stat-card.info { border-left-color: #0dcaf0; }
.stat-card.danger { border-left-color: #dc3545; }

.progress-thin {
    height: 8px;
}

.table-capacidades th {
    background-color: #f8f9fa;
    font-weight: 600;
    font-size: 0.875rem;
    text-transform: uppercase;
    color: #495057;
}

.badge-ocupacion {
    padding: 0.35em 0.65em;
    font-size: 0.875rem;
}

.chart-container {
    position: relative;
    height: 300px;
}

@media print {
    .no-print { display: none !important; }
    .stat-card { break-inside: avoid; }
}
</style>
');

// Cargar Google Charts CDN antes del script de la página
sol_assets_push(
    [],
    ['https://www.gstatic.com/charts/loader.js']
);

sol_dt_assets('/page-scripts/pages/reportes/capacidades_bodega.js');

ob_start();
?>

<div class="container-fluid py-3">
    <!-- Header -->
    <div class="d-flex justify-content-between align-items-center mb-4">
        <div>
            <h4 class="mb-1">
                <i class="bi bi-building me-2"></i>
                Capacidades de Bodega
            </h4>
            <p class="text-muted mb-0">Análisis completo de capacidad y ocupación</p>
        </div>
        <div class="d-flex gap-2 no-print">
            <select id="filtroDeposito" class="form-select form-select-sm" style="width: 200px;">
                <option value="">Todos los depósitos</option>
            </select>
            <button id="btnRefrescar" class="btn btn-outline-primary btn-sm">
                <i class="bi bi-arrow-clockwise"></i> Refrescar
            </button>
            <button id="btnExportar" class="btn btn-outline-success btn-sm">
                <i class="bi bi-file-earmark-excel"></i> Exportar
            </button>
            <button onclick="window.print()" class="btn btn-outline-secondary btn-sm">
                <i class="bi bi-printer"></i> Imprimir
            </button>
        </div>
    </div>

    <!-- KPIs Principales -->
    <div class="row g-3 mb-4" id="kpiContainer">
        <div class="col-md-3">
            <div class="card stat-card h-100">
                <div class="card-body">
                    <div class="d-flex justify-content-between align-items-start mb-2">
                        <div>
                            <h6 class="text-muted mb-0">Total Posiciones</h6>
                            <h2 class="mb-0" id="kpiTotalPosiciones">-</h2>
                        </div>
                        <div class="bg-primary bg-opacity-10 p-3 rounded">
                            <i class="bi bi-box-seam fs-4 text-primary"></i>
                        </div>
                    </div>
                    <small class="text-muted">Capacidad instalada</small>
                </div>
            </div>
        </div>
        
        <div class="col-md-3">
            <div class="card stat-card success h-100">
                <div class="card-body">
                    <div class="d-flex justify-content-between align-items-start mb-2">
                        <div>
                            <h6 class="text-muted mb-0">Posiciones Libres</h6>
                            <h2 class="mb-0 text-success" id="kpiPosLibres">-</h2>
                        </div>
                        <div class="bg-success bg-opacity-10 p-3 rounded">
                            <i class="bi bi-check-circle fs-4 text-white"></i>
                        </div>
                    </div>
                    <div class="progress progress-thin">
                        <div id="progressLibres" class="progress-bar bg-success" style="width: 0%"></div>
                    </div>
                </div>
            </div>
        </div>
        
        <div class="col-md-3">
            <div class="card stat-card warning h-100">
                <div class="card-body">
                    <div class="d-flex justify-content-between align-items-start mb-2">
                        <div>
                            <h6 class="text-muted mb-0">Posiciones Ocupadas</h6>
                            <h2 class="mb-0 text-warning" id="kpiPosOcupadas">-</h2>
                        </div>
                        <div class="bg-warning bg-opacity-10 p-3 rounded">
                            <i class="bi bi-exclamation-circle fs-4 text-dark"></i>
                        </div>
                    </div>
                    <div class="progress progress-thin">
                        <div id="progressOcupadas" class="progress-bar bg-warning" style="width: 0%"></div>
                    </div>
                </div>
            </div>
        </div>
        
        <div class="col-md-3">
            <div class="card stat-card info h-100">
                <div class="card-body">
                    <div class="d-flex justify-content-between align-items-start mb-2">
                        <div>
                            <h6 class="text-muted mb-0">Capacidad (Pallets)</h6>
                            <h2 class="mb-0 text-info" id="kpiCapacidadPallets">-</h2>
                        </div>
                        <div class="bg-info bg-opacity-10 p-3 rounded">
                            <i class="bi bi-stack fs-4 text-info"></i>
                        </div>
                    </div>
                    <small class="text-muted">
                        <span id="kpiPalletsActuales">-</span> actuales / 
                        <span id="kpiPalletsDisponibles">-</span> disponibles
                    </small>
                </div>
            </div>
        </div>
    </div>

    <!-- M2 Útiles -->
    <div class="row g-3 mb-4">
        <div class="col-md-12">
            <div class="card">
                <div class="card-body">
                    <div class="row align-items-center">
                        <div class="col-md-8">
                            <h5 class="mb-2">
                                <i class="bi bi-rulers me-2"></i>
                                Superficie Útil
                            </h5>
                            <p class="text-muted mb-0">
                                Excluye áreas de cuarentena y preparación
                            </p>
                        </div>
                        <div class="col-md-4 text-end">
                            <h2 class="mb-0">
                                <span id="kpiM2Utiles">-</span> <small class="text-muted">m²</small>
                            </h2>
                            <small class="text-muted">
                                <span id="kpiPosicionesUtiles">-</span> posiciones útiles
                            </small>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <!-- Gráficos -->
    <div class="row g-3 mb-4">
        <div class="col-md-6">
            <div class="card">
                <div class="card-header">
                    <h6 class="mb-0">Ocupación por Depósito</h6>
                </div>
                <div class="card-body">
                    <div class="chart-container">
                        <div id="chartDepositos" style="width: 100%; height: 400px;"></div>
                    </div>
                </div>
            </div>
        </div>
        
        <div class="col-md-6">
            <div class="card">
                <div class="card-header">
                    <h6 class="mb-0">Distribución por Ambiente</h6>
                </div>
                <div class="card-body">
                    <div class="chart-container">
                        <div id="chartAmbientes" style="width: 100%; height: 400px;"></div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <!-- Tabla: Capacidades por Depósito -->
    <div class="row mb-4">
        <div class="col-12">
            <div class="card">
                <div class="card-header d-flex justify-content-between align-items-center">
                    <h6 class="mb-0">Capacidades por Depósito</h6>
                    <span class="badge bg-secondary" id="badgeTotalDepositos">0</span>
                </div>
                <div class="card-body">
                    <div class="table-responsive">
                        <table class="table table-hover table-capacidades mb-0" id="tableDepositos">
                            <thead>
                                <tr>
                                    <th>Depósito</th>
                                    <th>Código</th>
                                    <th class="text-end">Total Posiciones</th>
                                    <th class="text-end">Ocupadas</th>
                                    <th class="text-end">Libres</th>
                                    <th class="text-end">Capacidad (Pallets)</th>
                                    <th class="text-end">Pallets Actuales</th>
                                    <th class="text-center">% Ocupación</th>
                                </tr>
                            </thead>
                            <tbody>
                                <tr>
                                    <td colspan="8" class="text-center text-muted">
                                        <div class="spinner-border spinner-border-sm me-2" role="status"></div>
                                        Cargando datos...
                                    </td>
                                </tr>
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <!-- Tabla: Capacidades por Ambiente -->
    <div class="row mb-4">
        <div class="col-12">
            <div class="card">
                <div class="card-header d-flex justify-content-between align-items-center">
                    <h6 class="mb-0">Capacidades por Ambiente</h6>
                    <span class="badge bg-secondary" id="badgeTotalAmbientes">0</span>
                </div>
                <div class="card-body">
                    <div class="table-responsive">
                        <table class="table table-hover table-capacidades mb-0" id="tableAmbientes">
                            <thead>
                                <tr>
                                    <th>Ambiente</th>
                                    <th>Código</th>
                                    <th class="text-end">Total Posiciones</th>
                                    <th class="text-end">Ocupadas</th>
                                    <th class="text-end">Libres</th>
                                    <th class="text-end">Capacidad (Pallets)</th>
                                    <th class="text-end">Pallets Actuales</th>
                                    <th class="text-center">% Ocupación</th>
                                </tr>
                            </thead>
                            <tbody>
                                <tr>
                                    <td colspan="8" class="text-center text-muted">
                                        <div class="spinner-border spinner-border-sm me-2" role="status"></div>
                                        Cargando datos...
                                    </td>
                                </tr>
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <!-- Matriz: Depósito x Ambiente -->
    <div class="row">
        <div class="col-12">
            <div class="card">
                <div class="card-header">
                    <h6 class="mb-0">Matriz de Distribución (Depósito × Ambiente)</h6>
                </div>
                <div class="card-body">
                    <div class="table-responsive">
                        <table class="table table-bordered table-sm" id="tableMatriz">
                            <thead>
                                <tr>
                                    <th>Depósito</th>
                                    <!-- Columnas de ambientes se generarán dinámicamente -->
                                </tr>
                            </thead>
                            <tbody>
                                <tr>
                                    <td colspan="100%" class="text-center text-muted">
                                        <div class="spinner-border spinner-border-sm me-2" role="status"></div>
                                        Cargando matriz...
                                    </td>
                                </tr>
                            </tbody>
                        </table>
                    </div>
                    <small class="text-muted d-block mt-2">
                        <i class="bi bi-info-circle me-1"></i>
                        Valores muestran: Ocupadas / Total Posiciones
                    </small>
                </div>
            </div>
        </div>
    </div>

    <!-- Timestamp -->
    <div class="text-center text-muted mt-4 mb-2">
        <small>
            <i class="bi bi-clock me-1"></i>
            Última actualización: <span id="timestamp">-</span>
        </small>
    </div>
</div>

<?php
$content = ob_get_clean();
include project_path('views/layout/layout_app.php');
