<?php

declare(strict_types=1);

/**
 * SOL - Sistema de Operaciones Logísticas
 * Vista: Reporte de Clientes · OTIF
 */

$BASE = dirname(__DIR__, 3);
require_once $BASE . '/app/Support/ViewHelpers.php';
require_once $BASE . '/app/Support/Assets.php';

sol_section('page_title', 'Reportes · Clientes · OTIF');
sol_section('breadcrumb', [
    ['label' => 'Inicio', 'url' => '/home'],
    ['label' => 'Reportes', 'url' => '/reportes'],
    ['label' => 'Clientes · OTIF', 'url' => null],
]);

sol_dt_assets('/page-scripts/pages/reportes/clientes_otif.js');

ob_start();
?>

<div class="container-fluid py-4">

  <div class="card mb-4">
    <div class="card-header">
      <h5 class="card-title mb-0"><i class="bi bi-funnel me-2"></i>Filtros de análisis</h5>
    </div>
    <div class="card-body">
      <form id="frmClientesOtif" autocomplete="off">
        <div class="row g-3">
          <div class="col-sm-6 col-lg-3">
            <label class="form-label" for="fecha_desde">Fecha pedido desde</label>
            <input type="date" class="form-control" id="fecha_desde" name="fecha_desde">
          </div>
          <div class="col-sm-6 col-lg-3">
            <label class="form-label" for="fecha_hasta">Fecha pedido hasta</label>
            <input type="date" class="form-control" id="fecha_hasta" name="fecha_hasta">
          </div>
          <div class="col-sm-6 col-lg-3">
            <label class="form-label" for="cliente_id">Cliente</label>
            <select class="form-select" id="cliente_id" name="cliente_id">
              <option value="">Todos</option>
            </select>
          </div>
          <div class="col-sm-6 col-lg-3">
            <label class="form-label" for="estado_id">Estado de pedido</label>
            <select class="form-select" id="estado_id" name="estado_id">
              <option value="">Todos</option>
            </select>
          </div>
          <div class="col-sm-6 col-lg-3">
            <label class="form-label" for="tolerancia_horas">Tolerancia OTIF (horas)</label>
            <select class="form-select" id="tolerancia_horas" name="tolerancia_horas"></select>
          </div>
          <div class="col-sm-6 col-lg-3 d-flex align-items-end">
            <div class="form-check form-switch">
              <input class="form-check-input" type="checkbox" role="switch" id="solo_entregados" name="solo_entregados" value="1">
              <label class="form-check-label" for="solo_entregados">Sólo pedidos con entrega</label>
            </div>
          </div>
          <div class="col-sm-6 col-lg-3 d-flex align-items-end">
            <div class="form-check form-switch">
              <input class="form-check-input" type="checkbox" role="switch" id="solo_otif" name="solo_otif" value="1">
              <label class="form-check-label" for="solo_otif">Sólo pedidos OTIF</label>
            </div>
          </div>
          <div class="col-12 d-flex flex-wrap gap-2 justify-content-end align-items-end">
            <button type="submit" class="btn btn-primary" id="btnBuscar">
              <i class="bi bi-search me-1"></i>Aplicar filtros
            </button>
            <button type="button" class="btn btn-outline-secondary" id="btnLimpiar">
              <i class="bi bi-arrow-counterclockwise me-1"></i>Limpiar
            </button>
          </div>
        </div>
      </form>
    </div>
  </div>

  <div class="card mb-4" id="summaryCard" style="display:none;">
    <div class="card-header d-flex flex-wrap justify-content-between align-items-center gap-2">
      <h5 class="card-title mb-0"><i class="bi bi-graph-up me-2"></i>Resumen del período</h5>
      <div class="text-end small text-muted">
        <div id="summaryRange"></div>
        <div id="summaryTolerance"></div>
      </div>
    </div>
    <div class="card-body">
      <div class="row g-3 text-center">
        <div class="col-6 col-lg-3">
          <div class="border rounded p-3 h-100">
            <div class="text-muted text-uppercase small">Pedidos evaluados</div>
            <div class="fs-4 fw-semibold" id="sumTotalPedidos">-</div>
            <div class="small text-muted" id="sumPedidosEntrega">-</div>
          </div>
        </div>
        <div class="col-6 col-lg-3">
          <div class="border rounded p-3 h-100">
            <div class="text-muted text-uppercase small">OTIF</div>
            <div class="fs-4 fw-semibold" id="sumOtif">-</div>
            <div class="small text-muted" id="sumOtifPct">-</div>
          </div>
        </div>
        <div class="col-6 col-lg-3">
          <div class="border rounded p-3 h-100">
            <div class="text-muted text-uppercase small">On Time</div>
            <div class="fs-4 fw-semibold" id="sumOnTime">-</div>
            <div class="small text-muted" id="sumOnTimePct">-</div>
          </div>
        </div>
        <div class="col-6 col-lg-3">
          <div class="border rounded p-3 h-100">
            <div class="text-muted text-uppercase small">In Full</div>
            <div class="fs-4 fw-semibold" id="sumInFull">-</div>
            <div class="small text-muted" id="sumInFullPct">-</div>
          </div>
        </div>
      </div>
      <div class="row g-3 text-center mt-1">
        <div class="col-6 col-lg-3">
          <div class="border rounded p-3 h-100">
            <div class="text-muted text-uppercase small">Destinos cumplidos</div>
            <div class="fs-5 fw-semibold" id="sumDestinos">-</div>
            <div class="small text-muted" id="sumDestinosPct">-</div>
          </div>
        </div>
        <div class="col-6 col-lg-3">
          <div class="border rounded p-3 h-100">
            <div class="text-muted text-uppercase small">Retraso promedio</div>
            <div class="fs-5 fw-semibold" id="sumAvgDelta">-</div>
            <div class="small text-muted" id="sumMedianDelta">-</div>
          </div>
        </div>
      </div>
      <div class="mt-3" id="summaryHighlight" style="display:none;">
        <div class="alert alert-light border d-inline-flex align-items-center gap-2 py-2 px-3 mb-0">
          <i class="bi bi-info-circle text-primary"></i>
          <span id="summaryHighlightText"></span>
        </div>
      </div>
    </div>
  </div>

  <div class="row mb-4 g-4">
    <div class="col-12 col-xl-5">
      <div class="card h-100" id="cardClientes" style="display:none;">
        <div class="card-header d-flex justify-content-between align-items-center">
          <h5 class="card-title mb-0"><i class="bi bi-people me-2"></i>Clientes con mayor impacto</h5>
          <small class="text-muted" id="clientesSummary"></small>
        </div>
        <div class="card-body p-0">
          <div class="table-responsive">
            <table class="table table-sm table-hover mb-0" id="tablaClientes">
              <thead class="table-light">
                <tr>
                  <th>Cliente</th>
                  <th class="text-end">Pedidos</th>
                  <th class="text-end">OTIF %</th>
                  <th class="text-end">On Time %</th>
                  <th class="text-end">In Full %</th>
                </tr>
              </thead>
              <tbody>
                <tr class="text-muted"><td colspan="5" class="text-center py-4">Sin datos disponibles</td></tr>
              </tbody>
            </table>
          </div>
        </div>
      </div>
    </div>
    <div class="col-12 col-xl-4">
      <div class="card h-100" id="cardClasificaciones" style="display:none;">
        <div class="card-header d-flex justify-content-between align-items-center">
          <h5 class="card-title mb-0"><i class="bi bi-segmented-nav me-2"></i>Clasificación OTIF</h5>
          <small class="text-muted" id="clasificacionesSummary"></small>
        </div>
        <div class="card-body p-0">
          <div class="table-responsive">
            <table class="table table-sm table-hover mb-0" id="tablaClasificaciones">
              <thead class="table-light">
                <tr>
                  <th>Clasificación</th>
                  <th class="text-end">Pedidos</th>
                  <th class="text-end">Participación</th>
                </tr>
              </thead>
              <tbody>
                <tr class="text-muted"><td colspan="3" class="text-center py-4">Sin datos disponibles</td></tr>
              </tbody>
            </table>
          </div>
        </div>
      </div>
    </div>
    <div class="col-12 col-xl-3">
      <div class="card h-100" id="cardEstados" style="display:none;">
        <div class="card-header d-flex justify-content-between align-items-center">
          <h5 class="card-title mb-0"><i class="bi bi-clipboard-check me-2"></i>Estados de pedido</h5>
          <small class="text-muted" id="estadosSummary"></small>
        </div>
        <div class="card-body p-0">
          <div class="table-responsive">
            <table class="table table-sm table-hover mb-0" id="tablaEstados">
              <thead class="table-light">
                <tr>
                  <th>Estado</th>
                  <th class="text-end">Pedidos</th>
                  <th class="text-end">OTIF %</th>
                </tr>
              </thead>
              <tbody>
                <tr class="text-muted"><td colspan="3" class="text-center py-4">Sin datos disponibles</td></tr>
              </tbody>
            </table>
          </div>
        </div>
      </div>
    </div>
  </div>

  <div class="card">
    <div class="card-header d-flex justify-content-between align-items-center">
      <h5 class="card-title mb-0"><i class="bi bi-table me-2"></i>Detalle de pedidos</h5>
      <span class="badge bg-primary" id="badgeTotalPedidos">0</span>
    </div>
    <div class="card-body">
      <div class="table-responsive">
        <table id="tblClientesOtif" class="table table-striped table-hover align-middle" style="width:100%">
          <thead>
            <tr>
              <th>Fecha pedido</th>
              <th>Pedido</th>
              <th>Cliente</th>
              <th>Estado</th>
              <th>Destinos</th>
              <th>Unidades</th>
              <th>Entrega</th>
              <th>Delta (h)</th>
              <th>Métricas</th>
              <th>Clasificación</th>
            </tr>
          </thead>
          <tbody></tbody>
        </table>
      </div>
      <p class="small text-muted mt-2" id="limitNotice" style="display:none;">
        Se muestra un máximo de <span id="limitValue">0</span> pedidos. Ajuste los filtros para profundizar.
      </p>
    </div>
  </div>

</div>

<?php
$content = ob_get_clean();
include project_path('views/layout/layout_app.php');
