<?php

declare(strict_types=1);

$BASE = dirname(__DIR__, 3);
require_once $BASE . '/app/Support/ViewHelpers.php';
require_once $BASE . '/app/Support/Assets.php';

sol_section('page_title', 'Reportes · Cobertura por SKU');
sol_section('breadcrumb', [
    ['label' => 'Inicio', 'url' => '/home'],
    ['label' => 'Reportes', 'url' => '/reportes'],
    ['label' => 'Cobertura por SKU', 'url' => null],
]);

sol_dt_assets('/page-scripts/pages/reportes/cobertura_sku.js');

sol_section('additional_css', "<style>
.metric-card {
  border-left: 4px solid #0d6efd;
  border-radius: 0.5rem;
  transition: box-shadow 0.2s ease-in-out;
}
.metric-card.info { border-left-color: #20c997; }
.metric-card.warning { border-left-color: #ffc107; }
.metric-card.danger { border-left-color: #dc3545; }
.metric-card:hover {
  box-shadow: 0 0.75rem 1.5rem rgba(13,110,253,0.08);
}
.badge-dot {
  background-color: transparent !important;
  padding: 0;
}
.badge-dot::before {
  content: '';
  display: inline-block;
  width: 0.65rem;
  height: 0.65rem;
  border-radius: 50%;
  margin-right: 0.35rem;
  background-color: currentColor;
}
</style>");

ob_start();
?>
<div class="container-fluid py-4">

  <div class="card mb-4">
    <div class="card-header d-flex justify-content-between align-items-center flex-wrap gap-2">
      <h5 class="card-title mb-0"><i class="bi bi-box-seam me-2"></i>Cobertura por SKU</h5>
      <small class="text-muted">Calcule cobertura basada en consumo histórico y stock disponible</small>
    </div>
    <div class="card-body">
      <form id="frmCoberturaSku" class="row g-3" autocomplete="off">
        <div class="col-sm-6 col-lg-4">
          <label for="sku" class="form-label">SKU / Producto</label>
          <input type="text" class="form-control" id="sku" name="sku" placeholder="Ej: SKU1234" list="skuSuggestions" required>
          <div class="form-text">Escriba al menos 3 caracteres para sugerencias. Enter para seleccionar.</div>
          <input type="hidden" id="producto_id" name="producto_id" value="">
          <datalist id="skuSuggestions"></datalist>
        </div>
        <div class="col-sm-6 col-lg-3">
          <label for="fecha_desde" class="form-label">Consumo desde</label>
          <input type="date" class="form-control" id="fecha_desde" name="fecha_desde">
        </div>
        <div class="col-sm-6 col-lg-3">
          <label for="fecha_hasta" class="form-label">Consumo hasta</label>
          <input type="date" class="form-control" id="fecha_hasta" name="fecha_hasta">
        </div>
        <div class="col-sm-6 col-lg-2 d-flex align-items-end justify-content-end gap-2">
          <button type="submit" class="btn btn-primary" id="btnCalcular">
            <i class="bi bi-graph-up-arrow me-1"></i>Calcular
          </button>
          <button type="button" class="btn btn-outline-secondary" id="btnLimpiar">
            <i class="bi bi-arrow-counterclockwise me-1"></i>Limpiar
          </button>
        </div>
      </form>
    </div>
  </div>

  <div class="alert alert-info d-flex align-items-baseline gap-2" id="alertIndicaciones">
    <i class="bi bi-info-circle"></i>
    <div>
      Ingrese un SKU y rango de fechas para estimar el promedio de consumo diario, la cobertura actual y las proyecciones a 30/60/90/120 días.
    </div>
  </div>

  <div class="alert alert-warning d-flex align-items-baseline gap-2" id="alertSinConsumo" style="display:none;">
    <i class="bi bi-exclamation-triangle"></i>
    <div>
      No se registraron salidas en el período analizado. Ajuste el rango de fechas o verifique el producto.
    </div>
  </div>

  <div class="card mb-4" id="cardResultado" style="display:none;">
    <div class="card-header d-flex flex-wrap justify-content-between align-items-center gap-2">
      <div>
        <h5 class="card-title mb-0" id="productoTitulo">Producto seleccionado</h5>
        <div class="small text-muted" id="productoSubtitulo">&nbsp;</div>
      </div>
      <div class="text-end small text-muted">
        <div id="lblRangoAnalizado">Período: -</div>
        <div id="lblUltimoMovimiento">Última salida registrada: -</div>
      </div>
    </div>
    <div class="card-body">
      <div class="row g-3 mb-3">
        <div class="col-lg-3 col-sm-6">
          <div class="metric-card p-3 h-100">
            <div class="text-muted text-uppercase small">Stock disponible (UC)</div>
            <div class="fs-3 fw-semibold" data-field="stock_disponible">-</div>
            <div class="small text-muted">Reservado: <span data-field="stock_reservado">-</span> · Total: <span data-field="stock_total">-</span></div>
          </div>
        </div>
        <div class="col-lg-3 col-sm-6">
          <div class="metric-card info p-3 h-100">
            <div class="text-muted text-uppercase small">Consumo diario promedio</div>
            <div class="fs-3 fw-semibold" data-field="consumo_promedio">-</div>
            <div class="small text-muted">Salidas analizadas: <span data-field="consumo_total">-</span></div>
            <div class="small text-muted">Pedidos/embarques: <span data-field="documentos_total">-</span></div>
            <div class="small text-muted">Promedio pedidos/día: <span data-field="documentos_promedio">-</span></div>
          </div>
        </div>
        <div class="col-lg-3 col-sm-6">
          <div class="metric-card warning p-3 h-100">
            <div class="text-muted text-uppercase small">Cobertura estimada</div>
            <div class="fs-3 fw-semibold" data-field="dias_cobertura">-</div>
            <div class="small text-muted">Días sin consumo: <span data-field="dias_sin_consumo">-</span></div>
          </div>
        </div>
        <div class="col-lg-3 col-sm-6">
          <div class="metric-card danger p-3 h-100">
            <div class="text-muted text-uppercase small">Stock mínimo configurado</div>
            <div class="fs-3 fw-semibold" data-field="stock_minimo">-</div>
            <div class="small text-muted">Máximo sugerido: <span data-field="stock_maximo">-</span></div>
          </div>
        </div>
      </div>

      <div class="table-responsive mb-4">
        <table class="table table-hover align-middle" id="tablaHorizontes">
          <thead class="table-light">
            <tr>
              <th>Horizonte (días)</th>
              <th class="text-end">Consumo estimado (UC)</th>
              <th class="text-end">Stock actual (UC)</th>
              <th class="text-end">Días cubiertos</th>
              <th class="text-end">Faltante / Sobrante (UC)</th>
              <th class="text-center">Resultado</th>
            </tr>
          </thead>
          <tbody>
            <tr class="text-muted">
              <td colspan="6" class="text-center py-4">Sin datos. Calcule el reporte para ver detalles.</td>
            </tr>
          </tbody>
        </table>
      </div>

      <div class="row g-3" id="bloqueSerie" style="display:none;">
        <div class="col-12 col-lg-6">
          <div class="border rounded p-3 h-100">
            <h6 class="mb-3">Consumo diario registrado</h6>
            <p class="small text-muted mb-2">Últimos días con salidas en el período analizado.</p>
            <div id="listaConsumo" class="vstack gap-2"></div>
          </div>
        </div>
        <div class="col-12 col-lg-6">
          <div class="border rounded p-3 h-100">
            <h6 class="mb-3">Notas de cobertura</h6>
            <ul class="list-unstyled mb-0" id="listaNotas">
              <li class="text-muted">Los cálculos consideran unidades consumidor final (UC).</li>
              <li class="text-muted">Se utilizan los pedidos y embarques despachados (so_pedido_dest_item / so_ship_link).</li>
              <li class="text-muted">El horizonte calcula consumo promedio proyectado para 30/60/90/120 días.</li>
            </ul>
          </div>
        </div>
      </div>
    </div>
  </div>

</div>
<?php
$content = ob_get_clean();
include project_path('views/layout/layout_app.php');
