<?php

declare(strict_types=1);

/**
 * SOL - Sistema de Operaciones Logísticas
 * Vista placeholder: Reporte de Costo por entregas (en desarrollo)
 */

$BASE = dirname(__DIR__, 3);
require_once $BASE . '/app/Support/ViewHelpers.php';

sol_section('page_title', 'Reportes · Costo por entregas');
sol_section('breadcrumb', [
    ['label' => 'Inicio', 'url' => '/home'],
    ['label' => 'Reportes', 'url' => '/reportes'],
    ['label' => 'Costo por entregas', 'url' => null],
]);

ob_start();
?>
<div class="container py-5">
  <div class="row justify-content-center">
    <div class="col-lg-7">
      <div class="card shadow-sm border-warning-subtle">
        <div class="card-header bg-warning text-dark">
          <h5 class="mb-0"><i class="bi bi-currency-dollar me-2"></i>En desarrollo</h5>
        </div>
        <div class="card-body">
          <p class="lead mb-3">Estamos preparando el reporte de costo por entregas.</p>
          <p class="mb-3">Nuestro objetivo es combinar costos logísticos con la trazabilidad de entregas para analizar la rentabilidad de cada ruta y cliente.</p>
          <ul class="mb-3">
            <li>KPIs comparativos por cliente, zona y medio de transporte.</li>
            <li>Integración con costos operativos y financieros.</li>
            <li>Exportaciones a PDF y Excel con el detalle de cada entrega.</li>
          </ul>
          <p class="mb-0">Si necesitás priorizar indicadores o formatos, envianos tus requerimientos para incorporarlos en la primera versión.</p>
        </div>
      </div>
    </div>
  </div>
</div>
<?php
$content = ob_get_clean();
include project_path('views/layout/layout_app.php');
