<?php

declare(strict_types=1);

/**
 * SOL - Sistema de Operaciones Logísticas
 * Vista placeholder: Reporte de Costo por unidad transportada (en desarrollo)
 */

$BASE = dirname(__DIR__, 3);
require_once $BASE . '/app/Support/ViewHelpers.php';

sol_section('page_title', 'Reportes · Costo por unidad transportada');
sol_section('breadcrumb', [
    ['label' => 'Inicio', 'url' => '/home'],
    ['label' => 'Reportes', 'url' => '/reportes'],
    ['label' => 'Costo por unidad transportada', 'url' => null],
]);

ob_start();
?>
<div class="container py-5">
  <div class="row justify-content-center">
    <div class="col-lg-7">
      <div class="card shadow-sm border-info-subtle">
        <div class="card-header bg-info text-dark">
          <h5 class="mb-0"><i class="bi bi-graph-up-arrow me-2"></i>En desarrollo</h5>
        </div>
        <div class="card-body">
          <p class="lead mb-3">Estamos diseñando el reporte de costo por unidad transportada.</p>
          <p class="mb-3">El objetivo es consolidar los costos operativos y compararlos contra la cantidad de unidades entregadas en cada periodo.</p>
          <ul class="mb-3">
            <li>KPIs por cliente, ruta y tipo de vehículo.</li>
            <li>Comparativa histórica por semana y mes.</li>
            <li>Exportaciones a PDF y Excel con el detalle de costos.</li>
          </ul>
          <p class="mb-0">Compartinos tus requerimientos específicos para priorizar este desarrollo.</p>
        </div>
      </div>
    </div>
  </div>
</div>
<?php
$content = ob_get_clean();
include project_path('views/layout/layout_app.php');
