<?php
declare(strict_types=1);

$BASE = dirname(__DIR__, 3);
require_once $BASE . '/app/Support/ViewHelpers.php';
require_once $BASE . '/app/Support/Assets.php';

sol_section('page_title', 'Reportes · Distribución');
sol_section('breadcrumb', [
    ['label' => 'Inicio', 'url' => '/home'],
    ['label' => 'Reportes', 'url' => '/reportes'],
    ['label' => 'Distribución', 'url' => null],
]);

sol_assets_push([], [url('/page-scripts/pages/reportes/distribucion.js')]);

sol_section('additional_css', <<<'CSS'
<style>
.card-indicador { border-left: 4px solid transparent; transition: transform .2s ease, box-shadow .2s ease; }
.card-indicador.ok { border-left-color: #198754; }
.card-indicador.alerta { border-left-color: #ffc107; }
.card-indicador.critico { border-left-color: #dc3545; }
.card-indicador.sin-datos { border-left-color: #6c757d; }
.card-indicador:hover { transform: translateY(-2px); box-shadow: 0 4px 12px rgba(0,0,0,.12); }
.badge-indicador { border-radius: 999px; padding: .125rem .5rem; font-size: .75rem; }
.summary-grid { display: grid; grid-template-columns: repeat(auto-fit, minmax(160px, 1fr)); gap: .75rem; }
.summary-tile { border: 1px solid rgba(0,0,0,.08); border-radius: .75rem; padding: .75rem; background: #f8f9fa; }
.summary-tile h6 { font-size: .75rem; text-transform: uppercase; letter-spacing: .05em; color: #6c757d; margin-bottom: .25rem; }
.summary-tile span { font-size: 1.1rem; font-weight: 600; }
</style>
CSS);

ob_start();
?>
<div class="container-fluid py-4">
    <div class="row g-3 mb-3">
        <div class="col-lg-4">
            <div class="card h-100 shadow-sm">
                <div class="card-header">
                    <h5 class="card-title mb-0"><i class="bi bi-sliders me-2"></i>Filtros</h5>
                </div>
                <div class="card-body">
                    <form id="frmDistribucion" class="row g-3">
                        <div class="col-12">
                            <label for="deposito_id" class="form-label">Depósito</label>
                            <select class="form-select" id="deposito_id" name="deposito_id">
                                <option value="">Todos</option>
                            </select>
                        </div>
                        <div class="col-12">
                            <label for="cliente_id" class="form-label">Cliente</label>
                            <select class="form-select" id="cliente_id" name="cliente_id">
                                <option value="">Todos</option>
                            </select>
                        </div>
                        <div class="col-12">
                            <label for="movil_id" class="form-label">Móvil</label>
                            <select class="form-select" id="movil_id" name="movil_id">
                                <option value="">Todos</option>
                            </select>
                        </div>
                        <div class="col-6">
                            <label for="fecha_desde" class="form-label">Fecha desde</label>
                            <input type="date" class="form-control" id="fecha_desde" name="fecha_desde">
                        </div>
                        <div class="col-6">
                            <label for="fecha_hasta" class="form-label">Fecha hasta</label>
                            <input type="date" class="form-control" id="fecha_hasta" name="fecha_hasta">
                        </div>
                        <div class="col-6">
                            <label for="tolerancia_min" class="form-label">Tolerancia puntualidad (min)</label>
                            <input type="number" class="form-control" id="tolerancia_min" name="tolerancia_min" min="5" step="5" value="60">
                        </div>
                        <div class="col-6">
                            <label for="combustible_meta" class="form-label">Meta combustible (L)</label>
                            <input type="number" class="form-control" id="combustible_meta" name="combustible_meta" min="0" step="1" placeholder="Opcional">
                        </div>
                        <div class="col-12 d-flex gap-2">
                            <button type="submit" class="btn btn-primary flex-grow-1"><i class="bi bi-search me-1"></i>Aplicar</button>
                            <button type="button" id="btnLimpiar" class="btn btn-outline-secondary"><i class="bi bi-eraser me-1"></i>Limpiar</button>
                        </div>
                    </form>
                </div>
            </div>
        </div>
        <div class="col-lg-8">
            <div class="card shadow-sm h-100">
                <div class="card-header d-flex justify-content-between align-items-center">
                    <div>
                        <h5 class="card-title mb-0"><i class="bi bi-speedometer2 me-2"></i>Indicadores clave</h5>
                        <small class="text-muted" id="periodoLabel">Seleccione filtros para ver resultados</small>
                    </div>
                    <span class="badge bg-secondary" id="badgeEntregas">0 entregas</span>
                </div>
                <div class="card-body">
                    <div class="row g-3" id="indicadoresContainer">
                        <?php
                        $indicadores = [
                            ['clave' => 'entregas_tiempo', 'titulo' => 'Entregas a tiempo', 'unidad' => '%'],
                            ['clave' => 'costo_logistico', 'titulo' => 'Costo logístico sobre ventas', 'unidad' => '%'],
                            ['clave' => 'km_entrega', 'titulo' => 'Kilómetros por entrega', 'unidad' => 'km'],
                            ['clave' => 'combustible', 'titulo' => 'Consumo de combustible', 'unidad' => 'L'],
                            ['clave' => 'devoluciones', 'titulo' => 'Devoluciones', 'unidad' => '%'],
                        ];
                        foreach ($indicadores as $ind):
                        ?>
                        <div class="col-md-6 col-xl-4" data-indicador="<?= htmlspecialchars($ind['clave'], ENT_QUOTES) ?>">
                            <div class="card card-indicador sin-datos h-100">
                                <div class="card-body">
                                    <div class="d-flex justify-content-between align-items-start mb-2">
                                        <h6 class="text-muted mb-0" data-field="titulo"><?= htmlspecialchars($ind['titulo'], ENT_QUOTES) ?></h6>
                                        <span class="badge badge-indicador bg-light text-muted" data-field="meta">Meta: -</span>
                                    </div>
                                    <h3 class="fw-semibold" data-field="valor">-</h3>
                                    <small class="text-muted" data-field="observacion">Sin datos disponibles</small>
                                </div>
                            </div>
                        </div>
                        <?php endforeach; ?>
                    </div>
                </div>
                <div class="card-footer bg-primary">
                    <div class="summary-grid" id="resumenDistribucion">
                        <div class="summary-tile">
                            <h6>Entregas</h6>
                            <span id="resEntregaTotal">-</span>
                        </div>
                        <div class="summary-tile">
                            <h6>En plazo</h6>
                            <span id="resEntregaPlazo">-</span>
                        </div>
                        <div class="summary-tile">
                            <h6>Retrasos</h6>
                            <span id="resEntregaRetraso">-</span>
                        </div>
                        <div class="summary-tile">
                            <h6>Kilómetros totales</h6>
                            <span id="resKmTotales">-</span>
                        </div>
                        <div class="summary-tile">
                            <h6>Combustible</h6>
                            <span id="resCombustible">-</span>
                        </div>
                        <div class="summary-tile">
                            <h6>Devoluciones</h6>
                            <span id="resDevoluciones">-</span>
                        </div>
                        <div class="summary-tile">
                            <h6>Costo logístico</h6>
                            <span id="resCostos">-</span>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <div class="alert alert-info d-flex align-items-start" role="alert">
        <i class="bi bi-info-circle me-2 fs-4"></i>
        <div>
            Los colores del semáforo responden al criterio de metas: verde si se alcanza, amarillo si cae dentro del 40% de la meta y rojo cuando baja de ese umbral (o lo supera, en indicadores donde menor es mejor).
        </div>
    </div>
</div>
<?php
$content = ob_get_clean();
include project_path('views/layout/layout_app.php');
