<?php

declare(strict_types=1);

/**
 * SOL - Sistema de Operaciones Logísticas
 * Vista: views/reportes/embarques_cumplimiento/index.php
 * Reporte: Cumplimiento de Entregas
 */

$BASE = dirname(__DIR__, 3); // embarques_cumplimiento -> reportes -> views -> raíz

require_once $BASE . '/app/Support/ViewHelpers.php';
require_once $BASE . '/app/Support/Assets.php';

sol_section('page_title', 'Cumplimiento de entregas');
sol_section('breadcrumb', [
    ['label' => 'Inicio', 'url' => '/home'],
    ['label' => 'Reportes', 'url' => '/reportes'],
    ['label' => 'Cumplimiento de entregas', 'url' => null],
]);


// Assets específicos para esta página
sol_dt_assets('/page-scripts/pages/reportes/embarques_cumplimiento.js');

// -------------------------
// Contenido de la página
// -------------------------
ob_start();
?>

<div class="container-fluid py-4">

    <div class="row mb-4">
        <div class="col-6">
            <!-- Filters -->
            <div class="card mb-4">
                <div class="card-header">
                    <h5 class="card-title mb-0">
                        <i class="bi bi-funnel me-2"></i>Filtros de Búsqueda
                    </h5>
                </div>
                <div class="card-body">
                    <form id="frmFiltros">
                        <div class="row g-3">
                            <!-- Date Range -->
                            <div class="col-md-3">
                                <label for="fecha_desde" class="form-label">Fecha Desde</label>
                                <input type="date" class="form-control" id="fecha_desde" name="fecha_desde">
                            </div>
                            <div class="col-md-3">
                                <label for="fecha_hasta" class="form-label">Fecha Hasta</label>
                                <input type="date" class="form-control" id="fecha_hasta" name="fecha_hasta">
                            </div>

                            <!-- Cliente and Destinatario -->
                            <div class="col-md-3">
                                <label for="cliente_id" class="form-label">Cliente</label>
                                <select class="form-select" id="cliente_id" name="cliente_id">
                                    <option value="">Todos los clientes</option>
                                </select>
                            </div>
                            <div class="col-md-3">
                                <label for="destinatario_id" class="form-label">Destinatario</label>
                                <select class="form-select" id="destinatario_id" name="destinatario_id">
                                    <option value="">Todos los destinatarios</option>
                                </select>
                            </div>

                            <!-- Status and Mobile -->
                            <div class="col-md-3">
                                <label for="estado" class="form-label">Estado</label>
                                <select class="form-select" id="estado" name="estado">
                                    <option value="">Todos los estados</option>
                                </select>
                            </div>
                            <div class="col-md-3">
                                <label for="movil_id" class="form-label">Móvil</label>
                                <select class="form-select" id="movil_id" name="movil_id">
                                    <option value="">Todos los móviles</option>
                                </select>
                            </div>

                            <!-- Action Buttons -->
                            <div class="col-md-12">
                                <label class="form-label">&nbsp;</label>
                                <div class="d-flex gap-2">
                                    <button type="submit" class="btn btn-primary">
                                        <i class="bi bi-search me-1"></i>Buscar
                                    </button>
                                    <button type="button" class="btn btn-secondary" id="btnLimpiar">
                                        <i class="bi bi-arrow-clockwise me-1"></i>Limpiar
                                    </button>
                                    <button type="button" class="btn btn-success" id="btnExportPDF" disabled>
                                        <i class="bi bi-file-pdf me-1"></i>Exportar PDF
                                    </button>
                                    <button type="button" class="btn btn-info" id="btnExportCSV" disabled>
                                        <i class="bi bi-file-excel me-1"></i>Exportar CSV
                                    </button>
                                </div>
                            </div>
                        </div>
                    </form>
                </div>
            </div>
        </div>
        <div class="col-6">
            <!-- indicadores -->
            <div class="card mb-4">
                <div class="card-header d-flex justify-content-between align-items-center">
                    <h5 class="card-title mb-0"><i class="bi bi-clipboard-data me-2"></i>Indicadores clave</h5>
                    <small class="text-muted">Metas vs resultados del periodo seleccionado</small>
                </div>
                <div class="card-body p-0">
                    <div class="table-responsive">
                        <table class="table table-sm table-striped table-hover mb-0 align-middle">
                            <thead class="table-light">
                                <tr>
                                    <th>Indicador</th>
                                    <th class="text-end">Meta</th>
                                    <th class="text-end">Resultados</th>
                                    <th class="text-end">Variaci&oacute;n</th>
                                    <th>Observaciones</th>
                                </tr>
                            </thead>
                            <tbody>
                                <tr>
                                    <td>Entregas a tiempo</td>
                                    <td class="text-end">98%</td>
                                    <td class="text-end">91%</td>
                                    <td class="text-end text-danger">-7%</td>
                                    <td>Retrasos por congestion en ruta<br>Ademas demoras en puntos de entrega anterior
                                    </td>
                                </tr>
                                <tr>
                                    <td>Rotacion de inventarios</td>
                                    <td class="text-end">8<br><small class="text-muted">8 veces/a&ntilde;o</small></td>
                                    <td class="text-end">6,5</td>
                                    <td class="text-end text-danger">-1,5</td>
                                    <td>Exceso de inventario en productos<br>Estacionales</td>
                                </tr>
                                <tr>
                                    <td>Costo log&iacute;stico sobre ventas</td>
                                    <td class="text-end">8,0%</td>
                                    <td class="text-end">7,5%</td>
                                    <td class="text-end text-success">0,5%</td>
                                    <td>Mejora por optimizaci&oacute;n de rutas</td>
                                </tr>
                                <tr>
                                    <td>Exactitud de picking</td>
                                    <td class="text-end">99%</td>
                                    <td class="text-end">98,70%</td>
                                    <td class="text-end text-danger">-0,3%</td>
                                    <td>Error humano, se planifica capacitaci&oacute;n</td>
                                </tr>
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
        </div>
    </div>


    <!-- Summary Metrics -->
    <div class="row mb-4" id="summarySection">
        <div class="col-12">
            <div class="card">
                <div class="card-header">
                    <h5 class="card-title mb-0">
                        <i class="bi bi-bar-chart me-2"></i>Métricas de Cumplimiento
                    </h5>
                </div>
                <div class="card-body">
                    <div class="row">
                        <div class="col-5">
                            <div class="row">
                                <!-- Fulfillment Rates -->
                                <div class="col-md-6">
                                    <div class="border rounded p-3 text-center">
                                        <h6 class="text-primary">Exactitud de picking</h6>
                                        <h3 class="mb-1" id="exactitudPicking">-</h3>
                                        <small class="text-muted" id="exactitudPickingDesc">-</small>
                                    </div>
                                </div>
                                <div class="col-md-6">
                                    <div class="border rounded p-3 text-center">
                                        <h6 class="text-primary">Costo logístico sobre ventas</h6>
                                        <h3 class="mb-1" id="costoLogistico">-</h3>
                                        <small class="text-muted" id="costoLogisticoDesc">-</small>
                                    </div>
                                </div>
                                <div class="col-md-6">
                                    <div class="border rounded p-3 text-center">
                                        <h6 class="text-primary">Rotacion de inventarios</h6>
                                        <h3 class="mb-1" id="rotacionInventarios">-</h3>
                                        <small class="text-muted" id="rotacionInventariosDesc">-</small>
                                    </div>
                                </div>
                                <div class="col-md-6">
                                    <div class="border rounded p-3 text-center">
                                        <h6 class="text-primary">Entregas a tiempo</h6>
                                        <h3 class="mb-1" id="tiempoEntrega">-</h3>
                                        <small class="text-muted" id="tiempoEntregaDesc">-</small>
                                    </div>
                                </div>
                                <div class="col-md-6">
                                    <div class="border rounded p-3 text-center">
                                        <h6 class="text-primary">Rate de Cumplimiento</h6>
                                        <h3 class="mb-1" id="rateCumplimiento">-</h3>
                                        <small class="text-muted" id="rateCumplimientoDesc">-</small>
                                    </div>
                                </div>
                                <div class="col-md-6">
                                    <div class="border rounded p-3 text-center">
                                        <h6 class="text-warning">Entregas Parciales</h6>
                                        <h3 class="mb-1" id="rateEntregaParcial">-</h3>
                                        <small class="text-muted" id="rateEntregaParcialDesc">-</small>
                                    </div>
                                </div>
                                <div class="col-md-6">
                                    <div class="border rounded p-3 text-center">
                                        <h6 class="text-info">Rate de Despacho</h6>
                                        <h3 class="mb-1" id="rateDespacho">-</h3>
                                        <small class="text-muted" id="rateDespachoDesc">-</small>
                                    </div>
                                </div>
                                <div class="col-md-6">
                                    <div class="border rounded p-3 text-center">
                                        <h6 class="text-secondary">Puntualidad</h6>
                                        <h3 class="mb-1" id="ratePuntualidad">-</h3>
                                        <small class="text-muted" id="ratePuntualidadDesc">-</small>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="col-lg-7">
                            <div class="card h-100" id="periodRatesCard" style="display: none;">
                                <div class="card-header d-flex justify-content-between align-items-center">
                                    <h5 class="card-title mb-0">
                                        <i class="bi bi-calendar-week me-2"></i>Rates por Período
                                    </h5>
                                    <small class="text-muted" id="periodRatesSummary">&nbsp;</small>
                                </div>
                                <div class="card-body p-0">
                                    <div class="table-responsive">
                                        <table class="table table-sm table-hover mb-0" id="tablaPeriodos">
                                            <thead class="table-light">
                                                <tr>
                                                    <th>Fecha</th>
                                                    <th class="text-end">Embarques</th>
                                                    <th class="text-end">Pedidos</th>
                                                    <th class="text-end">Rate Desp.</th>
                                                    <th class="text-end">Rate Entrega</th>
                                                </tr>
                                            </thead>
                                            <tbody>
                                                <tr class="text-muted">
                                                    <td colspan="5" class="text-center py-4">Sin datos disponibles</td>
                                                </tr>
                                            </tbody>
                                        </table>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>



    <div class="row mb-4">
        <div class="col-lg-12 mb-4 mb-lg-0">
            <div class="card h-100" id="destinatariosCard" style="display: none;">
                <div class="card-header d-flex justify-content-between align-items-center">
                    <h5 class="card-title mb-0">
                        <i class="bi bi-people me-2"></i>Métricas por Destinatario
                    </h5>
                    <small class="text-muted" id="destinatariosCardSummary">&nbsp;</small>
                </div>
                <div class="card-body p-0">
                    <div class="table-responsive">
                        <table class="table table-sm table-hover mb-0" id="tablaDestinatarios">
                            <thead class="table-light">
                                <tr>
                                    <th>Destinatario</th>
                                    <th>Cliente</th>
                                    <th class="text-end">Visitas</th>
                                    <th class="text-end">Completas</th>
                                    <th class="text-end">Parciales</th>
                                    <th class="text-end">Pendientes</th>
                                    <th class="text-end">Rate</th>
                                </tr>
                            </thead>
                            <tbody>
                                <tr class="text-muted">
                                    <td colspan="7" class="text-center py-4">Sin datos disponibles</td>
                                </tr>
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
        </div>

    </div>

    <!-- Results Table -->
    <div class="card">
        <div class="card-header">
            <h5 class="card-title mb-0">
                <i class="bi bi-table me-2"></i>Detalle de Embarques
            </h5>
        </div>
        <div class="card-body">
            <div class="table-responsive">
                <table id="tblCumplimiento" class="table table-striped table-hover" style="width:100%">
                    <thead>
                        <tr>
                            <th>Código</th>
                            <th>Fecha</th>
                            <th>Estado</th>
                            <th>Móvil</th>
                            <th>Destinos</th>
                            <th>Pedidos Esp.</th>
                            <th>Pedidos Desp.</th>
                            <th>Destinos Entr.</th>
                            <th>Items UV</th>
                            <th>Items UC</th>
                            <th>Rate Cumpl.</th>
                            <th>Delay (días)</th>
                            <th>Status</th>
                        </tr>
                    </thead>
                    <tbody>
                        <!-- Data loaded via DataTables Ajax -->
                    </tbody>
                </table>
            </div>
        </div>
    </div>
</div>

<?php

$content = ob_get_clean();

// -------------------------
// Render del layout
// -------------------------
include project_path('views/layout/layout_app.php');