<?php

declare(strict_types=1);

/**
 * SOL - Sistema de Operaciones Logísticas
 * Vista: views/reportes/embarques_devoluciones/index.php
 * Reporte: Devoluciones y Retornos
 */

$BASE = dirname(__DIR__, 3);

require_once $BASE . '/app/Support/ViewHelpers.php';
require_once $BASE . '/app/Support/Assets.php';

sol_section('page_title', 'Reportes · Devoluciones y Retornos');
sol_section('breadcrumb', [
  ['label' => 'Inicio', 'url' => '/home'],
  ['label' => 'Reportes', 'url' => '/reportes'],
  ['label' => 'Devoluciones y retornos', 'url' => null],
]);

sol_dt_assets('/page-scripts/pages/reportes/embarques_devoluciones.js');

ob_start();
?>

<div class="container-fluid py-4">

  <!-- Filtros -->
  <div class="card mb-4">
    <div class="card-header">
      <h5 class="card-title mb-0">
        <i class="bi bi-funnel me-2"></i>Filtros de búsqueda
      </h5>
    </div>
    <div class="card-body">
      <form id="frmDevoluciones" autocomplete="off">
        <div class="row g-3">
          <div class="col-sm-6 col-lg-3">
            <label for="fecha_desde" class="form-label">Fecha desde</label>
            <input type="date" class="form-control" id="fecha_desde" name="fecha_desde">
          </div>
          <div class="col-sm-6 col-lg-3">
            <label for="fecha_hasta" class="form-label">Fecha hasta</label>
            <input type="date" class="form-control" id="fecha_hasta" name="fecha_hasta">
          </div>
          <div class="col-sm-6 col-lg-3">
            <label for="deposito_id" class="form-label">Depósito</label>
            <select class="form-select" id="deposito_id" name="deposito_id">
              <option value="">Todos</option>
            </select>
          </div>
          <div class="col-sm-6 col-lg-3">
            <label for="motivo_id" class="form-label">Motivo</label>
            <select class="form-select" id="motivo_id" name="motivo_id">
              <option value="">Todos</option>
            </select>
          </div>
          <div class="col-sm-6 col-lg-3">
            <label for="cliente_id" class="form-label">Cliente</label>
            <select class="form-select" id="cliente_id" name="cliente_id">
              <option value="">Todos</option>
            </select>
          </div>
          <div class="col-sm-6 col-lg-3">
            <label for="destinatario_id" class="form-label">Destinatario</label>
            <select class="form-select" id="destinatario_id" name="destinatario_id">
              <option value="">Todos</option>
            </select>
          </div>
          <div class="col-sm-6 col-lg-3">
            <label for="sku" class="form-label">SKU</label>
            <input type="text" class="form-control" id="sku" name="sku" placeholder="Ej. PROD-001">
          </div>
          <div class="col-sm-6 col-lg-3">
            <label for="producto_text" class="form-label">Producto</label>
            <input type="text" class="form-control" id="producto_text" name="producto_text"
              placeholder="Nombre contiene...">
          </div>
          <div class="col-sm-6 col-lg-3">
            <label for="embarque_codigo" class="form-label">Código de embarque</label>
            <input type="text" class="form-control" id="embarque_codigo" name="embarque_codigo"
              placeholder="Ej. EMB-1234">
          </div>
          <div class="col-sm-6 col-lg-3">
            <label for="movil_id" class="form-label">Movil</label>
            <select class="form-select" id="movil_id" name="movil_id">
              <option value="">Todos</option>
            </select>
          </div>
          <div class="col-sm-6 col-lg-3 d-flex align-items-end">
            <div class="form-check">
              <input class="form-check-input" type="checkbox" value="1" id="solo_uc" name="solo_uc">
              <label class="form-check-label" for="solo_uc">Solo con unidades sueltas</label>
            </div>
          </div>
          <div class="col-12">
            <label class="form-label d-block">&nbsp;</label>
            <div class="d-flex flex-wrap gap-2">
              <button type="submit" class="btn btn-primary" id="btnBuscar">
                <i class="bi bi-search me-1"></i>Buscar
              </button>
              <button type="button" class="btn btn-secondary" id="btnLimpiar">
                <i class="bi bi-arrow-clockwise me-1"></i>Limpiar
              </button>
              <button type="button" class="btn btn-success" id="btnExportCSV" disabled>
                <i class="bi bi-filetype-csv me-1"></i>Exportar CSV
              </button>
            </div>
          </div>
        </div>
      </form>
    </div>
  </div>

  <!-- Resumen -->
  <div class="card mb-4" id="summaryCard" style="display:none;">
    <div class="card-header d-flex justify-content-between align-items-center">
      <h5 class="card-title mb-0">
        <i class="bi bi-graph-up me-2"></i>Resumen del período
      </h5>
      <small class="text-muted" id="summaryRange"></small>
    </div>
    <div class="card-body">
      <div class="row g-3 text-center" id="summaryMetrics">
        <div class="col-6 col-md-3">
          <div class="border rounded p-3 h-100">
            <div class="text-muted text-uppercase small">Registros</div>
            <div class="fs-4 fw-semibold" id="sumRegistros">-</div>
            <div class="small text-muted" id="sumEmbarques">-</div>
          </div>
        </div>
        <div class="col-6 col-md-3">
          <div class="border rounded p-3 h-100">
            <div class="text-muted text-uppercase small">Unidades UV</div>
            <div class="fs-4 fw-semibold" id="sumUV">-</div>
            <div class="small text-muted text-muted" id="sumUVDesc">-</div>
          </div>
        </div>
        <div class="col-6 col-md-3">
          <div class="border rounded p-3 h-100">
            <div class="text-muted text-uppercase small">Unidades sueltas</div>
            <div class="fs-4 fw-semibold" id="sumUC">-</div>
            <div class="small text-muted" id="sumUCDesc">-</div>
          </div>
        </div>
        <div class="col-6 col-md-3">
          <div class="border rounded p-3 h-100">
            <div class="text-muted text-uppercase small">Pallets</div>
            <div class="fs-4 fw-semibold" id="sumPallets">-</div>
            <div class="small text-muted" id="sumDestinatarios">-</div>
          </div>
        </div>
      </div>
    </div>
  </div>

  <!-- Agregados -->
  <div class="row mb-4">

    <div class="col-12 col-xl-8">
      <div class="row g-4">
        <div class="col-12 col-lg-5 col-xl-4">
          <div class="card h-100" id="cardDestinatariosTotales" style="display:none;">
            <div class="card-header">
              <h5 class="card-title mb-0">
                <i class="bi bi-cash-coin me-2"></i>Totales destinatarios
              </h5>
            </div>
            <div class="card-body">
              <div class="d-flex flex-column gap-2">
                <div class="d-flex justify-content-between align-items-center">
                  <span class="text-muted text-uppercase small">Registros</span>
                  <span class="fw-semibold" id="destTotalRows">-</span>
                </div>
                <div class="d-flex justify-content-between align-items-center">
                  <span class="text-muted text-uppercase small">UV</span>
                  <span class="fw-semibold" id="destTotalUv">-</span>
                </div>
                <div class="d-flex justify-content-between align-items-center">
                  <span class="text-muted text-uppercase small">Unidades</span>
                  <span class="fw-semibold" id="destTotalUc">-</span>
                </div>
                <div class="d-flex justify-content-between align-items-center">
                  <span class="text-muted text-uppercase small">Costo (Gs)</span>
                  <span class="fw-semibold" id="destTotalCost">-</span>
                </div>
              </div>
            </div>
          </div>
        </div>
        <div class="col-12 col-lg-7 col-xl-8">
          <div class="card h-100" id="cardDestinatarios" style="display:none;">
            <div class="card-header d-flex justify-content-between align-items-center">
              <h5 class="card-title mb-0">
                <i class="bi bi-people me-2"></i>Top destinatarios
              </h5>
              <small class="text-muted" id="destinatariosSummary"></small>
            </div>
            <div class="card-body p-0">
              <div class="table-responsive">
                <table class="table table-sm table-hover mb-0" id="tablaDestinatarios">
                  <thead class="table-light">
                    <tr>
                      <th>Destinatario</th>
                      <th>Cliente</th>
                      <th class="text-end">Registros</th>
                      <th class="text-end">UV</th>
                      <th class="text-end">Unidades</th>
                      <th class="text-end">Costo (Gs)</th>
                    </tr>
                  </thead>
                  <tbody>
                    <tr class="text-muted">
                      <td colspan="6" class="text-center py-4">Sin datos disponibles</td>
                    </tr>
                  </tbody>
                </table>
              </div>
            </div>
          </div>
        </div>
        <div class="col-12 col-xl-4 mb-4 mb-xl-0">
          <div class="card h-100" id="cardMotivos" style="display:none;">
            <div class="card-header d-flex justify-content-between align-items-center">
              <h5 class="card-title mb-0">
                <i class="bi bi-tags me-2"></i>Top motivos
              </h5>
              <small class="text-muted" id="motivosSummary"></small>
            </div>
            <div class="card-body p-0">
              <div class="table-responsive">
                <table class="table table-sm table-hover mb-0" id="tablaMotivos">
                  <thead class="table-light">
                    <tr>
                      <th>Motivo</th>
                      <th class="text-end">Registros</th>
                      <th class="text-end">UV</th>
                      <th class="text-end">Unidades</th>
                    </tr>
                  </thead>
                  <tbody>
                    <tr class="text-muted">
                      <td colspan="4" class="text-center py-4">Sin datos disponibles</td>
                    </tr>
                  </tbody>
                </table>
              </div>
            </div>
          </div>
        </div>
      </div>
    </div>
  </div>

  <div class="row mb-4">
    <div class="col-12">
      <div class="card h-100" id="cardProductos" style="display:none;">
        <div class="card-header d-flex justify-content-between align-items-center">
          <h5 class="card-title mb-0">
            <i class="bi bi-box-seam me-2"></i>Top productos
          </h5>
          <small class="text-muted" id="productosSummary"></small>
        </div>
        <div class="card-body p-0">
          <div class="table-responsive">
            <table class="table table-sm table-hover mb-0" id="tablaProductos">
              <thead class="table-light">
                <tr>
                  <th>Producto</th>
                  <th class="text-end">Registros</th>
                  <th class="text-end">UV</th>
                  <th class="text-end">Unidades</th>
                </tr>
              </thead>
              <tbody>
                <tr class="text-muted">
                  <td colspan="4" class="text-center py-4">Sin datos disponibles</td>
                </tr>
              </tbody>
            </table>
          </div>
        </div>
      </div>
    </div>
  </div>

  <!-- Tabla principal -->
  <div class="card">
    <div class="card-header">
      <h5 class="card-title mb-0">
        <i class="bi bi-table me-2"></i>Detalle de devoluciones
      </h5>
    </div>
    <div class="card-body">
      <div class="table-responsive">
        <table id="tblDevoluciones" class="table table-striped table-hover w-100">
          <thead>
            <tr>
              <th>Retorno</th>
              <th>Embarque</th>
              <th>Depósito</th>
              <th>Cliente</th>
              <th>Destinatario</th>
              <th>Motivo</th>
              <th>Producto</th>
              <th class="text-end">Pallets</th>
              <th class="text-end">UV</th>
              <th class="text-end">Unidades</th>
              <th>Documento</th>
              <th>Lote</th>
              <th>Responsable</th>
              <th>Observaciones</th>
            </tr>
          </thead>
          <tbody>
            <!-- Datos via DataTables -->
          </tbody>
        </table>
      </div>
    </div>
  </div>

</div>

<?php

$content = ob_get_clean();

include project_path('views/layout/layout_app.php');