<?php
// views/reportes/embarques_monitoreo.php
$title = 'Monitoreo de Embarques';
require_once __DIR__ . '/../layout/header.php';
?>

<div class="container-fluid py-4">
  <div class="row">
    <div class="col-12">
      <div class="card">
        <div class="card-header d-flex justify-content-between align-items-center">
          <h5 class="card-title mb-0">
            <i class="bi bi-truck me-2"></i>
            Reporte de Monitoreo de Embarques
          </h5>
          <div class="d-flex gap-2">
            <button type="button" class="btn btn-outline-success btn-sm" id="btnExportExcel">
              <i class="bi bi-file-earmark-excel me-1"></i>
              Excel
            </button>
            <button type="button" class="btn btn-outline-danger btn-sm" id="btnExportPDF">
              <i class="bi bi-file-earmark-pdf me-1"></i>
              PDF
            </button>
            <button type="button" class="btn btn-primary btn-sm" id="btnActualizar">
              <i class="bi bi-arrow-clockwise me-1"></i>
              Actualizar
            </button>
          </div>
        </div>
        
        <div class="card-body">
          <!-- Filtros -->
          <div class="row mb-4">
            <div class="col-md-3">
              <label class="form-label">Fecha Desde</label>
              <input type="date" class="form-control" id="filtroFechaDesde">
            </div>
            <div class="col-md-3">
              <label class="form-label">Fecha Hasta</label>
              <input type="date" class="form-control" id="filtroFechaHasta">
            </div>
            <div class="col-md-2">
              <label class="form-label">Estado</label>
              <select class="form-select" id="filtroEstado">
                <option value="">Todos</option>
              </select>
            </div>
            <div class="col-md-2">
              <label class="form-label">Móvil</label>
              <select class="form-select" id="filtroMovil">
                <option value="">Todos</option>
              </select>
            </div>
            <div class="col-md-2">
              <label class="form-label">Chofer</label>
              <select class="form-select" id="filtroChofer">
                <option value="">Todos</option>
              </select>
            </div>
          </div>
          
          <!-- Summary Cards -->
          <div class="row mb-4" id="summaryCards">
            <div class="col-md-2">
              <div class="card bg-primary text-white">
                <div class="card-body text-center">
                  <h5 class="card-title" id="totalEmbarques">0</h5>
                  <p class="card-text small">Total Embarques</p>
                </div>
              </div>
            </div>
            <div class="col-md-2">
              <div class="card bg-info text-white">
                <div class="card-body text-center">
                  <h5 class="card-title" id="totalDestinos">0</h5>
                  <p class="card-text small">Total Destinos</p>
                </div>
              </div>
            </div>
            <div class="col-md-2">
              <div class="card bg-warning text-white">
                <div class="card-body text-center">
                  <h5 class="card-title" id="promedioEspera">-</h5>
                  <p class="card-text small">Promedio Espera (min)</p>
                </div>
              </div>
            </div>
            <div class="col-md-2">
              <div class="card bg-success text-white">
                <div class="card-body text-center">
                  <h5 class="card-title" id="promedioCarga">-</h5>
                  <p class="card-text small">Promedio Carga (min)</p>
                </div>
              </div>
            </div>
            <div class="col-md-2">
              <div class="card bg-secondary text-white">
                <div class="card-body text-center">
                  <h5 class="card-title" id="promedioPlanta">-</h5>
                  <p class="card-text small">Promedio Planta (min)</p>
                </div>
              </div>
            </div>
            <div class="col-md-2">
              <div class="card bg-dark text-white">
                <div class="card-body text-center">
                  <h5 class="card-title" id="estadoMasFrecuente">-</h5>
                  <p class="card-text small">Estado + Frecuente</p>
                </div>
              </div>
            </div>
          </div>
          
          <!-- Estados Distribution -->
          <div class="row mb-4">
            <div class="col-12">
              <h6>Distribución por Estado</h6>
              <div class="row" id="estadosDistribution">
                <!-- Estados cards will be populated by JS -->
              </div>
            </div>
          </div>
          
          <!-- DataTable -->
          <div class="table-responsive">
            <table id="tblEmbarques" class="table table-striped table-bordered" style="width:100%">
              <thead>
                <tr>
                  <th>Código</th>
                  <th>Fecha</th>
                  <th>Estado</th>
                  <th>Depósito</th>
                  <th>Móvil</th>
                  <th>Chofer</th>
                  <th>Destinos</th>
                  <th>PREs</th>
                  <th>Llegada</th>
                  <th>Inicio Carga</th>
                  <th>Fin Carga</th>
                  <th>Salida</th>
                  <th>Espera (min)</th>
                  <th>Carga (min)</th>
                  <th>Total Planta (min)</th>
                  <th>Ayudantes</th>
                  <th>Temp °C</th>
                  <th>Observación</th>
                </tr>
              </thead>
              <tbody>
                <!-- Data populated by DataTables -->
              </tbody>
            </table>
          </div>
        </div>
      </div>
    </div>
  </div>
</div>

<!-- Loading indicator -->
<div id="loadingIndicator" class="position-fixed top-50 start-50 translate-middle" style="z-index: 9999; display: none;">
  <div class="spinner-border text-primary" role="status">
    <span class="visually-hidden">Cargando...</span>
  </div>
</div>

<?php require_once __DIR__ . '/../layout/footer.php'; ?>

<!-- Include the report-specific JavaScript -->
<script src="<?= $BASE_URL ?>/public/page-scripts/pages/reportes/embarques_monitoreo.js"></script>