<?php
// views/reportes/embarques_tiempos.php
$title = 'Análisis de Tiempos de Embarques';
require_once __DIR__ . '/../layout/header.php';
?>

<div class="container-fluid py-4">
  <div class="row">
    <div class="col-12">
      <div class="card">
        <div class="card-header d-flex justify-content-between align-items-center">
          <h5 class="card-title mb-0">
            <i class="bi bi-clock me-2"></i>
            Reporte de Análisis de Tiempos de Embarques
          </h5>
          <div class="d-flex gap-2">
            <button type="button" class="btn btn-outline-success btn-sm" id="btnExportExcel">
              <i class="bi bi-file-earmark-excel me-1"></i>
              Excel
            </button>
            <button type="button" class="btn btn-outline-danger btn-sm" id="btnExportPDF">
              <i class="bi bi-file-earmark-pdf me-1"></i>
              PDF
            </button>
            <button type="button" class="btn btn-primary btn-sm" id="btnActualizar">
              <i class="bi bi-arrow-clockwise me-1"></i>
              Actualizar
            </button>
          </div>
        </div>
        
        <div class="card-body">
          <!-- Filtros -->
          <div class="row mb-4">
            <div class="col-md-3">
              <label class="form-label">Fecha Desde</label>
              <input type="date" class="form-control" id="filtroFechaDesde">
            </div>
            <div class="col-md-3">
              <label class="form-label">Fecha Hasta</label>
              <input type="date" class="form-control" id="filtroFechaHasta">
            </div>
            <div class="col-md-2">
              <label class="form-label">Estado</label>
              <select class="form-select" id="filtroEstado">
                <option value="">Todos</option>
              </select>
            </div>
            <div class="col-md-2">
              <label class="form-label">Móvil</label>
              <select class="form-select" id="filtroMovil">
                <option value="">Todos</option>
              </select>
            </div>
            <div class="col-md-2">
              <label class="form-label">Depósito</label>
              <select class="form-select" id="filtroDeposito">
                <option value="">Todos</option>
              </select>
            </div>
          </div>
          
          <!-- Summary Statistics -->
          <div class="row mb-4">
            <div class="col-12">
              <h6>Estadísticas de Tiempos</h6>
            </div>
          </div>
          <div class="row mb-4" id="summaryCards">
            <div class="col-md-3">
              <div class="card bg-warning text-dark">
                <div class="card-body text-center">
                  <h6 class="card-title mb-1">Tiempo de Espera</h6>
                  <div class="row text-center">
                    <div class="col-4">
                      <small>Prom</small>
                      <div id="esperaPromedio">-</div>
                    </div>
                    <div class="col-4">
                      <small>Min</small>
                      <div id="esperaMinimo">-</div>
                    </div>
                    <div class="col-4">
                      <small>Max</small>
                      <div id="esperaMaximo">-</div>
                    </div>
                  </div>
                </div>
              </div>
            </div>
            <div class="col-md-3">
              <div class="card bg-success text-white">
                <div class="card-body text-center">
                  <h6 class="card-title mb-1">Tiempo de Carga</h6>
                  <div class="row text-center">
                    <div class="col-4">
                      <small>Prom</small>
                      <div id="cargaPromedio">-</div>
                    </div>
                    <div class="col-4">
                      <small>Min</small>
                      <div id="cargaMinimo">-</div>
                    </div>
                    <div class="col-4">
                      <small>Max</small>
                      <div id="cargaMaximo">-</div>
                    </div>
                  </div>
                </div>
              </div>
            </div>
            <div class="col-md-3">
              <div class="card bg-info text-white">
                <div class="card-body text-center">
                  <h6 class="card-title mb-1">Total en Planta</h6>
                  <div class="row text-center">
                    <div class="col-4">
                      <small>Prom</small>
                      <div id="plantaPromedio">-</div>
                    </div>
                    <div class="col-4">
                      <small>Min</small>
                      <div id="plantaMinimo">-</div>
                    </div>
                    <div class="col-4">
                      <small>Max</small>
                      <div id="plantaMaximo">-</div>
                    </div>
                  </div>
                </div>
              </div>
            </div>
            <div class="col-md-3">
              <div class="card bg-primary text-white">
                <div class="card-body text-center">
                  <h6 class="card-title mb-1">Tiempo de Ruta</h6>
                  <div class="row text-center">
                    <div class="col-4">
                      <small>Prom</small>
                      <div id="rutaPromedio">-</div>
                    </div>
                    <div class="col-4">
                      <small>Min</small>
                      <div id="rutaMinimo">-</div>
                    </div>
                    <div class="col-4">
                      <small>Max</small>
                      <div id="rutaMaximo">-</div>
                    </div>
                  </div>
                </div>
              </div>
            </div>
          </div>
          
          <!-- Additional Metrics -->
          <div class="row mb-4">
            <div class="col-md-4">
              <div class="card bg-secondary text-white">
                <div class="card-body text-center">
                  <h6 class="card-title mb-1">Eficiencia</h6>
                  <div class="row text-center">
                    <div class="col-6">
                      <small>Total</small>
                      <div id="totalEmbarques">0</div>
                    </div>
                    <div class="col-6">
                      <small>Con tiempos</small>
                      <div id="embarquesConTiempos">0</div>
                    </div>
                  </div>
                </div>
              </div>
            </div>
            <div class="col-md-4">
              <div class="card bg-dark text-white">
                <div class="card-body text-center">
                  <h6 class="card-title mb-1">Carga por Destino</h6>
                  <div class="row text-center">
                    <div class="col-4">
                      <small>Prom</small>
                      <div id="eficienciaPromedio">-</div>
                    </div>
                    <div class="col-4">
                      <small>Min</small>
                      <div id="eficienciaMinimo">-</div>
                    </div>
                    <div class="col-4">
                      <small>Max</small>
                      <div id="eficienciaMaximo">-</div>
                    </div>
                  </div>
                </div>
              </div>
            </div>
          </div>
          
          <!-- Analysis Tabs -->
          <div class="row mb-4">
            <div class="col-12">
              <ul class="nav nav-tabs" id="analysisTabs" role="tablist">
                <li class="nav-item" role="presentation">
                  <button class="nav-link active" id="detalle-tab" data-bs-toggle="tab" data-bs-target="#detalle" type="button" role="tab">
                    Detalle de Embarques
                  </button>
                </li>
                <li class="nav-item" role="presentation">
                  <button class="nav-link" id="moviles-tab" data-bs-toggle="tab" data-bs-target="#moviles" type="button" role="tab">
                    Análisis por Móvil
                  </button>
                </li>
                <li class="nav-item" role="presentation">
                  <button class="nav-link" id="depositos-tab" data-bs-toggle="tab" data-bs-target="#depositos" type="button" role="tab">
                    Análisis por Depósito
                  </button>
                </li>
                <li class="nav-item" role="presentation">
                  <button class="nav-link" id="ayudantes-tab" data-bs-toggle="tab" data-bs-target="#ayudantes" type="button" role="tab">
                    Distribución Ayudantes
                  </button>
                </li>
              </ul>
              <div class="tab-content" id="analysisTabContent">
                <div class="tab-pane fade show active" id="detalle" role="tabpanel">
                  <div class="table-responsive mt-3">
                    <table id="tblEmbarques" class="table table-striped table-bordered" style="width:100%">
                      <thead>
                        <tr>
                          <th>Código</th>
                          <th>Fecha</th>
                          <th>Estado</th>
                          <th>Móvil</th>
                          <th>Depósito</th>
                          <th>Destinos</th>
                          <th>Ayudantes</th>
                          <th>Llegada</th>
                          <th>Inicio Carga</th>
                          <th>Fin Carga</th>
                          <th>Salida</th>
                          <th>T. Espera</th>
                          <th>T. Carga</th>
                          <th>T. Planta</th>
                          <th>T. Ruta</th>
                          <th>Efic./Dest</th>
                        </tr>
                      </thead>
                      <tbody>
                        <!-- Data populated by DataTables -->
                      </tbody>
                    </table>
                  </div>
                </div>
                <div class="tab-pane fade" id="moviles" role="tabpanel">
                  <div class="table-responsive mt-3">
                    <table id="tblMoviles" class="table table-striped table-bordered">
                      <thead>
                        <tr>
                          <th>Móvil</th>
                          <th>Total Embarques</th>
                          <th>Promedio Carga (min)</th>
                          <th>Promedio Planta (min)</th>
                        </tr>
                      </thead>
                      <tbody>
                        <!-- Data populated by JS -->
                      </tbody>
                    </table>
                  </div>
                </div>
                <div class="tab-pane fade" id="depositos" role="tabpanel">
                  <div class="table-responsive mt-3">
                    <table id="tblDepositos" class="table table-striped table-bordered">
                      <thead>
                        <tr>
                          <th>Depósito</th>
                          <th>Total Embarques</th>
                          <th>Promedio Espera (min)</th>
                          <th>Promedio Carga (min)</th>
                        </tr>
                      </thead>
                      <tbody>
                        <!-- Data populated by JS -->
                      </tbody>
                    </table>
                  </div>
                </div>
                <div class="tab-pane fade" id="ayudantes" role="tabpanel">
                  <div class="table-responsive mt-3">
                    <table id="tblAyudantes" class="table table-striped table-bordered">
                      <thead>
                        <tr>
                          <th>Cantidad Ayudantes</th>
                          <th>Número de Embarques</th>
                          <th>Porcentaje</th>
                        </tr>
                      </thead>
                      <tbody>
                        <!-- Data populated by JS -->
                      </tbody>
                    </table>
                  </div>
                </div>
              </div>
            </div>
          </div>
        </div>
      </div>
    </div>
  </div>
</div>

<!-- Loading indicator -->
<div id="loadingIndicator" class="position-fixed top-50 start-50 translate-middle" style="z-index: 9999; display: none;">
  <div class="spinner-border text-primary" role="status">
    <span class="visually-hidden">Cargando...</span>
  </div>
</div>

<?php require_once __DIR__ . '/../layout/footer.php'; ?>

<!-- Include the report-specific JavaScript -->
<script src="<?= $BASE_URL ?>/public/page-scripts/pages/reportes/embarques_tiempos.js"></script>