<?php

declare(strict_types=1);

/**
 * SOL - Sistema de Operaciones Logísticas
 * Vista: views/reportes/embarques_tiempos/index.php
 * Reporte: Análisis de Tiempos de Embarques
 */

$BASE = dirname(__DIR__, 3); // embarques_tiempos -> reportes -> views -> raíz

require_once $BASE . '/app/Support/ViewHelpers.php';
require_once $BASE . '/app/Support/Assets.php';

// -------------------------
// Meta
// -------------------------
sol_section('page_title', 'Reportes · Análisis de Tiempos de Embarques');

// -------------------------
// DataTables + script de la página
// -------------------------
sol_dt_assets('/page-scripts/pages/reportes/embarques_tiempos.js');

// -------------------------
// Contenido de la página
// -------------------------
ob_start();
?>

<div class="container-fluid py-4">
  <div class="row">
    <div class="col-12">
      <div class="card">
        <div class="card-header d-flex justify-content-between align-items-center">
          <h5 class="card-title mb-0">
            <i class="bi bi-clock me-2"></i>
            Análisis de Tiempos de Embarques
          </h5>
          <div class="d-flex gap-2">
            <button type="button" class="btn btn-outline-success btn-sm" id="btnExportExcel">
              <i class="bi bi-file-earmark-excel me-1"></i>
              Excel
            </button>
            <button type="button" class="btn btn-outline-danger btn-sm" id="btnExportPDF">
              <i class="bi bi-file-earmark-pdf me-1"></i>
              PDF
            </button>
            <button type="button" class="btn btn-primary btn-sm" id="btnActualizar">
              <i class="bi bi-arrow-clockwise me-1"></i>
              Actualizar
            </button>
          </div>
        </div>
        
        <div class="card-body">
          <!-- Filtros -->
          <div class="row mb-4">
            <div class="col-md-3">
              <label class="form-label">Fecha Desde</label>
              <input type="date" class="form-control" id="filtroFechaDesde">
            </div>
            <div class="col-md-3">
              <label class="form-label">Fecha Hasta</label>
              <input type="date" class="form-control" id="filtroFechaHasta">
            </div>
            <div class="col-md-2">
              <label class="form-label">Estado</label>
              <select class="form-select" id="filtroEstado">
                <option value="">Todos</option>
              </select>
            </div>
            <div class="col-md-2">
              <label class="form-label">Móvil</label>
              <select class="form-select" id="filtroMovil">
                <option value="">Todos</option>
              </select>
            </div>
            <div class="col-md-2">
              <label class="form-label">Depósito</label>
              <select class="form-select" id="filtroDeposito">
                <option value="">Todos</option>
              </select>
            </div>
          </div>
          
          <!-- Estadísticas de Tiempos -->
          <div class="row mb-4">
            <div class="col-12">
              <h6 class="mb-3">Estadísticas de Tiempos</h6>
            </div>
            
            <!-- Tiempo de Espera -->
            <div class="col-md-4 mb-3">
              <div class="card bg-warning text-dark">
                <div class="card-header">
                  <h6 class="card-title mb-0">Tiempo de Espera</h6>
                </div>
                <div class="card-body">
                  <div class="row text-center">
                    <div class="col-4">
                      <div class="fw-bold" id="esperaPromedio">-</div>
                      <small>Promedio</small>
                    </div>
                    <div class="col-4">
                      <div class="fw-bold" id="esperaMinimo">-</div>
                      <small>Mínimo</small>
                    </div>
                    <div class="col-4">
                      <div class="fw-bold" id="esperaMaximo">-</div>
                      <small>Máximo</small>
                    </div>
                  </div>
                </div>
              </div>
            </div>
            
            <!-- Tiempo de Carga -->
            <div class="col-md-4 mb-3">
              <div class="card bg-primary text-white">
                <div class="card-header">
                  <h6 class="card-title mb-0">Tiempo de Carga</h6>
                </div>
                <div class="card-body">
                  <div class="row text-center">
                    <div class="col-4">
                      <div class="fw-bold" id="cargaPromedio">-</div>
                      <small>Promedio</small>
                    </div>
                    <div class="col-4">
                      <div class="fw-bold" id="cargaMinimo">-</div>
                      <small>Mínimo</small>
                    </div>
                    <div class="col-4">
                      <div class="fw-bold" id="cargaMaximo">-</div>
                      <small>Máximo</small>
                    </div>
                  </div>
                </div>
              </div>
            </div>
            
            <!-- Tiempo Total en Planta -->
            <div class="col-md-4 mb-3">
              <div class="card bg-info text-white">
                <div class="card-header">
                  <h6 class="card-title mb-0">Total en Planta</h6>
                </div>
                <div class="card-body">
                  <div class="row text-center">
                    <div class="col-4">
                      <div class="fw-bold" id="plantaPromedio">-</div>
                      <small>Promedio</small>
                    </div>
                    <div class="col-4">
                      <div class="fw-bold" id="plantaMinimo">-</div>
                      <small>Mínimo</small>
                    </div>
                    <div class="col-4">
                      <div class="fw-bold" id="plantaMaximo">-</div>
                      <small>Máximo</small>
                    </div>
                  </div>
                </div>
              </div>
            </div>
          </div>

          <!-- Tiempo de Ruta y Métricas Adicionales -->
          <div class="row mb-4">
            <div class="col-md-3">
              <div class="card bg-success text-white">
                <div class="card-body text-center">
                  <div class="row">
                    <div class="col-12">
                      <div class="fw-bold" id="rutaPromedio">-</div>
                      <small>Tiempo Ruta Promedio</small>
                    </div>
                  </div>
                </div>
              </div>
            </div>
            <div class="col-md-3">
              <div class="card bg-secondary text-white">
                <div class="card-body text-center">
                  <div class="fw-bold" id="totalEmbarques">0</div>
                  <small>Total Embarques</small>
                </div>
              </div>
            </div>
            <div class="col-md-3">
              <div class="card bg-dark text-white">
                <div class="card-body text-center">
                  <div class="fw-bold" id="embarquesConTiempos">0</div>
                  <small>Con Datos de Tiempo</small>
                </div>
              </div>
            </div>
            <div class="col-md-3">
              <div class="card bg-danger text-white">
                <div class="card-body text-center">
                  <div class="fw-bold" id="eficienciaPromedio">-</div>
                  <small>Eficiencia Carga (min/dest)</small>
                </div>
              </div>
            </div>
          </div>

          <!-- Análisis por Móvil y Depósito -->
          <div class="row mb-4">
            <div class="col-md-6">
              <h6>Análisis por Móvil</h6>
              <div class="table-responsive">
                <table class="table table-sm table-striped" id="tblMoviles">
                  <thead>
                    <tr>
                      <th>Móvil</th>
                      <th class="text-end">Embarques</th>
                      <th class="text-end">Prom. Carga (min)</th>
                      <th class="text-end">Prom. Planta (min)</th>
                    </tr>
                  </thead>
                  <tbody>
                    <!-- Populated by JS -->
                  </tbody>
                </table>
              </div>
            </div>
            <div class="col-md-6">
              <h6>Análisis por Depósito</h6>
              <div class="table-responsive">
                <table class="table table-sm table-striped" id="tblDepositos">
                  <thead>
                    <tr>
                      <th>Depósito</th>
                      <th class="text-end">Embarques</th>
                      <th class="text-end">Prom. Espera (min)</th>
                      <th class="text-end">Prom. Carga (min)</th>
                    </tr>
                  </thead>
                  <tbody>
                    <!-- Populated by JS -->
                  </tbody>
                </table>
              </div>
            </div>
          </div>

          <!-- Distribución de Ayudantes -->
          <div class="row mb-4">
            <div class="col-md-6">
              <h6>Distribución de Ayudantes</h6>
              <div class="table-responsive">
                <table class="table table-sm table-striped" id="tblAyudantes">
                  <thead>
                    <tr>
                      <th class="text-center">Cantidad</th>
                      <th class="text-end">Embarques</th>
                      <th class="text-end">Porcentaje</th>
                    </tr>
                  </thead>
                  <tbody>
                    <!-- Populated by JS -->
                  </tbody>
                </table>
              </div>
            </div>
          </div>
          
          <!-- DataTable Principal -->
          <div class="table-responsive">
            <table id="tblEmbarques" class="table table-striped table-bordered" style="width:100%">
              <thead>
                <tr>
                  <th>Código</th>
                  <th>Fecha</th>
                  <th>Estado</th>
                  <th>Móvil</th>
                  <th>Depósito</th>
                  <th>Destinos</th>
                  <th>Ayudantes</th>
                  <th>Llegada</th>
                  <th>Inicio Carga</th>
                  <th>Fin Carga</th>
                  <th>Salida</th>
                  <th>T. Espera</th>
                  <th>T. Carga</th>
                  <th>T. Planta</th>
                  <th>T. Ruta</th>
                  <th>Eficiencia</th>
                </tr>
              </thead>
              <tbody>
                <!-- Data populated by DataTables -->
              </tbody>
            </table>
          </div>
        </div>
      </div>
    </div>
  </div>
</div>

<!-- Loading indicator -->
<div id="loadingIndicator" class="position-fixed top-50 start-50 translate-middle" style="z-index: 9999; display: none;">
  <div class="spinner-border text-primary" role="status">
    <span class="visually-hidden">Cargando...</span>
  </div>
</div>

</div>

<?php

$content = ob_get_clean();

// -------------------------
// Render del layout
// -------------------------
include project_path('views/layout/layout_app.php');