<?php

declare(strict_types=1);

/**
 * SOL - Sistema de Operaciones Logísticas
 * Vista: Reporte de Errores de Picking
 */

$BASE = dirname(__DIR__, 3);
require_once $BASE . '/app/Support/ViewHelpers.php';
require_once $BASE . '/app/Support/Assets.php';

sol_section('page_title', 'Reportes · Errores de picking');
sol_section('breadcrumb', [
    ['label' => 'Inicio', 'url' => '/home'],
    ['label' => 'Reportes', 'url' => '/reportes'],
    ['label' => 'Errores de picking', 'url' => null],
]);

sol_dt_assets('/page-scripts/pages/reportes/errores_picking.js');

ob_start();
?>

<div class="container-fluid py-4">

  <div class="card mb-4">
    <div class="card-header">
      <h5 class="card-title mb-0"><i class="bi bi-funnel me-2"></i>Filtros de búsqueda</h5>
    </div>
    <div class="card-body">
      <form id="frmErroresPicking" autocomplete="off">
        <div class="row g-3">
          <div class="col-sm-6 col-lg-3">
            <label class="form-label" for="fecha_desde">Fecha desde</label>
            <input type="date" class="form-control" id="fecha_desde" name="fecha_desde">
          </div>
          <div class="col-sm-6 col-lg-3">
            <label class="form-label" for="fecha_hasta">Fecha hasta</label>
            <input type="date" class="form-control" id="fecha_hasta" name="fecha_hasta">
          </div>
          <div class="col-sm-6 col-lg-3">
            <label class="form-label" for="motivo_id">Motivo</label>
            <select class="form-select" id="motivo_id" name="motivo_id">
              <option value="">Todos</option>
            </select>
          </div>
          <div class="col-sm-6 col-lg-3">
            <label class="form-label" for="cliente_id">Cliente</label>
            <select class="form-select" id="cliente_id" name="cliente_id">
              <option value="">Todos</option>
            </select>
          </div>
          <div class="col-sm-6 col-lg-3">
            <label class="form-label" for="responsable">Responsable</label>
            <input type="text" class="form-control" id="responsable" name="responsable" placeholder="Nombre, usuario o turno">
          </div>
          <div class="col-sm-6 col-lg-3">
            <label class="form-label" for="codigo">Código de pedido</label>
            <input type="text" class="form-control" id="codigo" name="codigo" placeholder="Ej. PED-2025-015">
          </div>
          <div class="col-12 d-flex flex-wrap gap-2 justify-content-end align-items-end">
            <button type="submit" class="btn btn-primary" id="btnBuscar">
              <i class="bi bi-search me-1"></i>Buscar
            </button>
            <button type="button" class="btn btn-outline-secondary" id="btnLimpiar">
              <i class="bi bi-arrow-counterclockwise me-1"></i>Limpiar
            </button>
          </div>
        </div>
      </form>
    </div>
  </div>

  <div class="card mb-4" id="summaryCard" style="display:none;">
    <div class="card-header d-flex justify-content-between align-items-center">
      <h5 class="card-title mb-0"><i class="bi bi-graph-up me-2"></i>Resumen del período</h5>
      <div class="text-end">
        <small class="text-muted d-block" id="summaryRange"></small>
        <small class="text-muted d-block" id="summaryMotivo" style="display:none;"></small>
      </div>
    </div>
    <div class="card-body">
      <div class="row g-3 text-center">
        <div class="col-6 col-lg-3">
          <div class="border rounded p-3 h-100">
            <div class="text-muted text-uppercase small">Errores</div>
            <div class="fs-4 fw-semibold" id="sumErrores">-</div>
            <div class="small text-muted" id="sumErroresSub">-</div>
          </div>
        </div>
        <div class="col-6 col-lg-3">
          <div class="border rounded p-3 h-100">
            <div class="text-muted text-uppercase small">Pedidos afectados</div>
            <div class="fs-4 fw-semibold" id="sumPedidos">-</div>
            <div class="small text-muted" id="sumPedidosSub">-</div>
          </div>
        </div>
        <div class="col-6 col-lg-3">
          <div class="border rounded p-3 h-100">
            <div class="text-muted text-uppercase small">Responsables</div>
            <div class="fs-4 fw-semibold" id="sumResponsables">-</div>
            <div class="small text-muted" id="sumResponsablesSub">-</div>
          </div>
        </div>
        <div class="col-6 col-lg-3">
          <div class="border rounded p-3 h-100">
            <div class="text-muted text-uppercase small">Clientes</div>
            <div class="fs-4 fw-semibold" id="sumClientes">-</div>
            <div class="small text-muted" id="sumClientesSub">-</div>
          </div>
        </div>
      </div>
      <div class="mt-3" id="summaryHighlight" style="display:none;">
        <div class="alert alert-light border d-inline-flex align-items-center gap-2 py-2 px-3 mb-0">
          <i class="bi bi-exclamation-triangle text-warning"></i>
          <span id="summaryHighlightText"></span>
        </div>
      </div>
    </div>
  </div>

  <div class="row mb-4 g-4">
    <div class="col-12 col-xl-4">
      <div class="card h-100" id="cardMotivos" style="display:none;">
        <div class="card-header d-flex justify-content-between align-items-center">
          <h5 class="card-title mb-0"><i class="bi bi-clipboard-data me-2"></i>Motivos más frecuentes</h5>
          <small class="text-muted" id="motivosSummary"></small>
        </div>
        <div class="card-body p-0">
          <div class="table-responsive">
            <table class="table table-sm table-hover mb-0" id="tablaMotivos">
              <thead class="table-light">
                <tr>
                  <th>Motivo</th>
                  <th class="text-end">Errores</th>
                  <th class="text-end">Pedidos</th>
                  <th class="text-end">Clientes</th>
                </tr>
              </thead>
              <tbody>
                <tr class="text-muted">
                  <td colspan="4" class="text-center py-4">Sin datos disponibles</td>
                </tr>
              </tbody>
            </table>
          </div>
        </div>
      </div>
    </div>
    <div class="col-12 col-xl-4">
      <div class="card h-100" id="cardResponsables" style="display:none;">
        <div class="card-header d-flex justify-content-between align-items-center">
          <h5 class="card-title mb-0"><i class="bi bi-person-workspace me-2"></i>Responsables</h5>
          <small class="text-muted" id="responsablesSummary"></small>
        </div>
        <div class="card-body p-0">
          <div class="table-responsive">
            <table class="table table-sm table-hover mb-0" id="tablaResponsables">
              <thead class="table-light">
                <tr>
                  <th>Responsable</th>
                  <th class="text-end">Errores</th>
                  <th class="text-end">Pedidos</th>
                </tr>
              </thead>
              <tbody>
                <tr class="text-muted">
                  <td colspan="3" class="text-center py-4">Sin datos disponibles</td>
                </tr>
              </tbody>
            </table>
          </div>
        </div>
      </div>
    </div>
    <div class="col-12 col-xl-4">
      <div class="card h-100" id="cardClientes" style="display:none;">
        <div class="card-header d-flex justify-content-between align-items-center">
          <h5 class="card-title mb-0"><i class="bi bi-people me-2"></i>Clientes impactados</h5>
          <small class="text-muted" id="clientesSummary"></small>
        </div>
        <div class="card-body p-0">
          <div class="table-responsive">
            <table class="table table-sm table-hover mb-0" id="tablaClientes">
              <thead class="table-light">
                <tr>
                  <th>Cliente</th>
                  <th class="text-end">Errores</th>
                  <th class="text-end">Pedidos</th>
                </tr>
              </thead>
              <tbody>
                <tr class="text-muted">
                  <td colspan="3" class="text-center py-4">Sin datos disponibles</td>
                </tr>
              </tbody>
            </table>
          </div>
        </div>
      </div>
    </div>
  </div>

  <div class="card">
    <div class="card-header d-flex justify-content-between align-items-center">
      <h5 class="card-title mb-0"><i class="bi bi-table me-2"></i>Detalle de errores registrados</h5>
      <span class="badge bg-danger" id="badgeTotalErrores">0</span>
    </div>
    <div class="card-body">
      <div class="table-responsive">
        <table id="tblErrores" class="table table-striped table-hover align-middle" style="width:100%">
          <thead>
            <tr>
              <th>Fecha</th>
              <th>Pedido</th>
              <th>PRE</th>
              <th>Cliente</th>
              <th>Motivo</th>
              <th>Responsable</th>
              <th>Observación</th>
            </tr>
          </thead>
          <tbody></tbody>
        </table>
      </div>
      <p class="small text-muted mt-2" id="limitNotice" style="display:none;">
        Se muestra un máximo de <span id="limitValue">0</span> registros. Refine los filtros para ver más detalle.
      </p>
    </div>
  </div>

</div>

<?php
$content = ob_get_clean();
include project_path('views/layout/layout_app.php');
