<?php

declare(strict_types=1);

/**
 * SOL - Sistema de Operaciones Logísticas
 * Vista: Reporte de Facturación y Rendiciones
 */

$BASE = dirname(__DIR__, 3);
require_once $BASE . '/app/Support/ViewHelpers.php';
require_once $BASE . '/app/Support/Assets.php';

sol_section('page_title', 'Reportes · Facturación y Rendiciones');
sol_section('breadcrumb', [
    ['label' => 'Inicio', 'url' => '/home'],
    ['label' => 'Reportes', 'url' => '/reportes'],
    ['label' => 'Facturación y Rendiciones', 'url' => null],
]);

sol_dt_assets('/page-scripts/pages/reportes/facturacion.js');

ob_start();
?>
<div class="container-fluid py-4">

  <div class="card mb-4">
    <div class="card-header">
      <h5 class="card-title mb-0"><i class="bi bi-funnel me-2"></i>Filtros del reporte</h5>
    </div>
    <div class="card-body">
      <form id="frmFacturacion" autocomplete="off">
        <div class="row g-3">
          <div class="col-sm-6 col-lg-3">
            <label class="form-label" for="fecha_desde">Desde</label>
            <input type="date" class="form-control" id="fecha_desde" name="fecha_desde">
          </div>
          <div class="col-sm-6 col-lg-3">
            <label class="form-label" for="fecha_hasta">Hasta</label>
            <input type="date" class="form-control" id="fecha_hasta" name="fecha_hasta">
          </div>
          <div class="col-sm-6 col-lg-3">
            <label class="form-label" for="deposito_id">Depósito</label>
            <select class="form-select" id="deposito_id" name="deposito_id">
              <option value="">Todos</option>
            </select>
          </div>
          <div class="col-sm-6 col-lg-3">
            <label class="form-label" for="chofer_id">Chofer</label>
            <select class="form-select" id="chofer_id" name="chofer_id">
              <option value="">Todos</option>
            </select>
          </div>
          <div class="col-sm-6 col-lg-3">
            <label class="form-label" for="cliente_id">Cliente</label>
            <select class="form-select" id="cliente_id" name="cliente_id">
              <option value="">Todos</option>
            </select>
          </div>
          <div class="col-sm-6 col-lg-3">
            <label class="form-label" for="condicion">Condición</label>
            <select class="form-select" id="condicion" name="condicion">
              <option value="">Todas</option>
            </select>
          </div>
          <div class="col-sm-6 col-lg-3 d-flex align-items-end">
            <div class="form-check form-switch">
              <input class="form-check-input" type="checkbox" role="switch" id="solo_pendientes" name="solo_pendientes" value="1">
              <label class="form-check-label" for="solo_pendientes">Sólo pendientes</label>
            </div>
          </div>
          <div class="col-sm-6 col-lg-3 d-flex align-items-end">
            <div class="form-check form-switch">
              <input class="form-check-input" type="checkbox" role="switch" id="solo_rendidas" name="solo_rendidas" value="1">
              <label class="form-check-label" for="solo_rendidas">Sólo rendidas</label>
            </div>
          </div>
          <div class="col-12 d-flex flex-wrap gap-2 justify-content-end">
            <button type="submit" class="btn btn-primary" id="btnBuscar">
              <i class="bi bi-search me-1"></i>Aplicar filtros
            </button>
            <button type="button" class="btn btn-outline-secondary" id="btnLimpiar">
              <i class="bi bi-arrow-counterclockwise me-1"></i>Limpiar
            </button>
          </div>
        </div>
      </form>
    </div>
  </div>

  <div class="card mb-4" id="summaryCard" style="display:none;">
    <div class="card-header d-flex flex-wrap justify-content-between align-items-center gap-2">
      <h5 class="card-title mb-0"><i class="bi bi-graph-up me-2"></i>Resumen del período</h5>
      <div class="text-end small text-muted">
        <div id="summaryRange"></div>
      </div>
    </div>
    <div class="card-body">
      <div class="row g-3 text-center">
        <div class="col-6 col-xl-2">
          <div class="border rounded p-3 h-100">
            <div class="text-muted text-uppercase small">Facturas</div>
            <div class="fs-4 fw-semibold" id="sumTotalFacturas">-</div>
          </div>
        </div>
        <div class="col-6 col-xl-2">
          <div class="border rounded p-3 h-100">
            <div class="text-muted text-uppercase small">Rendidas</div>
            <div class="fs-4 fw-semibold text-success" id="sumTotalRendidas">-</div>
          </div>
        </div>
        <div class="col-6 col-xl-2">
          <div class="border rounded p-3 h-100">
            <div class="text-muted text-uppercase small">Pendientes</div>
            <div class="fs-4 fw-semibold text-warning" id="sumTotalPendientes">-</div>
          </div>
        </div>
        <div class="col-6 col-xl-2">
          <div class="border rounded p-3 h-100">
            <div class="text-muted text-uppercase small">Importe total</div>
            <div class="fs-5 fw-semibold" id="sumImporteTotal">-</div>
            <div class="small text-muted" id="sumImporteRendido">-</div>
          </div>
        </div>
        <div class="col-6 col-xl-2">
          <div class="border rounded p-3 h-100">
            <div class="text-muted text-uppercase small">Importe pendiente</div>
            <div class="fs-5 fw-semibold text-warning" id="sumImportePendiente">-</div>
          </div>
        </div>
        <div class="col-6 col-xl-2">
          <div class="border rounded p-3 h-100">
            <div class="text-muted text-uppercase small">Días rendición</div>
            <div class="fs-5 fw-semibold" id="sumPromedioDias">-</div>
            <div class="small text-muted" id="sumMaxPendiente">-</div>
          </div>
        </div>
      </div>
      <div class="row g-3 text-center mt-3">
        <div class="col-6 col-lg-3">
          <div class="border rounded p-3 h-100">
            <div class="text-muted text-uppercase small">Pendientes ≥ 7 días</div>
            <div class="fs-5 fw-semibold" id="sumPendientes7">-</div>
          </div>
        </div>
        <div class="col-6 col-lg-3">
          <div class="border rounded p-3 h-100">
            <div class="text-muted text-uppercase small">Pendientes ≥ 15 días</div>
            <div class="fs-5 fw-semibold" id="sumPendientes15">-</div>
          </div>
        </div>
      </div>
      <div class="mt-3" id="summaryHighlight" style="display:none;">
        <div class="alert alert-light border d-inline-flex align-items-center gap-2 py-2 px-3 mb-0">
          <i class="bi bi-info-circle text-primary"></i>
          <span id="summaryHighlightText"></span>
        </div>
      </div>
    </div>
  </div>

  <div class="row g-4 mb-4">
    <div class="col-12 col-xl-4">
      <div class="card h-100" id="cardClientes" style="display:none;">
        <div class="card-header d-flex justify-content-between align-items-center">
          <h5 class="card-title mb-0"><i class="bi bi-people me-2"></i>Clientes</h5>
          <small class="text-muted" id="clientesSummary"></small>
        </div>
        <div class="card-body p-0">
          <div class="table-responsive">
            <table class="table table-sm table-hover mb-0" id="tablaClientes">
              <thead class="table-light">
                <tr>
                  <th>Cliente</th>
                  <th class="text-end">Facturas</th>
                  <th class="text-end">Pendientes</th>
                  <th class="text-end">Importe total</th>
                </tr>
              </thead>
              <tbody>
                <tr class="text-muted"><td colspan="4" class="text-center py-4">Sin datos disponibles</td></tr>
              </tbody>
            </table>
          </div>
        </div>
      </div>
    </div>
    <div class="col-12 col-xl-4">
      <div class="card h-100" id="cardDepositos" style="display:none;">
        <div class="card-header d-flex justify-content-between align-items-center">
          <h5 class="card-title mb-0"><i class="bi bi-building me-2"></i>Depósitos</h5>
          <small class="text-muted" id="depositosSummary"></small>
        </div>
        <div class="card-body p-0">
          <div class="table-responsive">
            <table class="table table-sm table-hover mb-0" id="tablaDepositos">
              <thead class="table-light">
                <tr>
                  <th>Depósito</th>
                  <th class="text-end">Facturas</th>
                  <th class="text-end">Pendientes</th>
                  <th class="text-end">Importe</th>
                </tr>
              </thead>
              <tbody>
                <tr class="text-muted"><td colspan="4" class="text-center py-4">Sin datos disponibles</td></tr>
              </tbody>
            </table>
          </div>
        </div>
      </div>
    </div>
    <div class="col-12 col-xl-4">
      <div class="card h-100" id="cardChoferes" style="display:none;">
        <div class="card-header d-flex justify-content-between align-items-center">
          <h5 class="card-title mb-0"><i class="bi bi-person-badge me-2"></i>Choferes</h5>
          <small class="text-muted" id="choferesSummary"></small>
        </div>
        <div class="card-body p-0">
          <div class="table-responsive">
            <table class="table table-sm table-hover mb-0" id="tablaChoferes">
              <thead class="table-light">
                <tr>
                  <th>Chofer</th>
                  <th class="text-end">Facturas</th>
                  <th class="text-end">Pendientes</th>
                </tr>
              </thead>
              <tbody>
                <tr class="text-muted"><td colspan="3" class="text-center py-4">Sin datos disponibles</td></tr>
              </tbody>
            </table>
          </div>
        </div>
      </div>
    </div>
  </div>

  <div class="row g-4 mb-4">
    <div class="col-12 col-xl-4">
      <div class="card h-100" id="cardCondiciones" style="display:none;">
        <div class="card-header d-flex justify-content-between align-items-center">
          <h5 class="card-title mb-0"><i class="bi bi-file-earmark-text me-2"></i>Condiciones</h5>
          <small class="text-muted" id="condicionesSummary"></small>
        </div>
        <div class="card-body p-0">
          <div class="table-responsive">
            <table class="table table-sm table-hover mb-0" id="tablaCondiciones">
              <thead class="table-light">
                <tr>
                  <th>Condición</th>
                  <th class="text-end">Facturas</th>
                  <th class="text-end">Pendientes</th>
                </tr>
              </thead>
              <tbody>
                <tr class="text-muted"><td colspan="3" class="text-center py-4">Sin datos disponibles</td></tr>
              </tbody>
            </table>
          </div>
        </div>
      </div>
    </div>
  </div>

  <div class="card">
    <div class="card-header d-flex justify-content-between align-items-center">
      <h5 class="card-title mb-0"><i class="bi bi-table me-2"></i>Detalle de facturas</h5>
      <span class="badge bg-primary" id="badgeTotalFacturas">0</span>
    </div>
    <div class="card-body">
      <div class="table-responsive">
        <table id="tblFacturacion" class="table table-striped table-hover align-middle" style="width:100%">
          <thead>
            <tr>
              <th>Factura</th>
              <th>Fechas</th>
              <th>Importes</th>
              <th>Clientes / Destinatarios</th>
              <th>Embarque / Depósito</th>
              <th>Chofer / Móvil</th>
              <th>Condición</th>
              <th>Días</th>
            </tr>
          </thead>
          <tbody></tbody>
        </table>
      </div>
      <p class="small text-muted mt-2" id="limitNotice" style="display:none;">
        Se muestra un máximo de <span id="limitValue">0</span> registros. Ajuste los filtros para profundizar.
      </p>
    </div>
  </div>

</div>
<?php
$content = ob_get_clean();
include project_path('views/layout/layout_app.php');
