<?php
declare(strict_types=1);

/**
 * SOL - Sistema de Operaciones Logísticas
 * Vista: views/reportes/index.php
 * Landing de accesos a reportes.
 */

$BASE = dirname(__DIR__, 2);

require_once $BASE . '/app/Support/ViewHelpers.php';
require_once $BASE . '/app/Support/Assets.php';

sol_section('page_title', 'Reportes');
sol_section('breadcrumb', [
	['label' => 'Inicio', 'url' => '/home'],
	['label' => 'Reportes', 'url' => null],
]);

ob_start();
$sections =
	[
		[
			'title' => 'Operaciones',
			'subtitle' => 'KPIs diarios de ingreso y salida',
			'icon' => 'bi-activity',
			'accent' => 'secondary',
			'text_color' => 'text-dark',
			'link_accent' => 'secondary',
			'links' => [
				['label' => 'Pedidos', 'url' => '/reportes/pedidos'],
				['label' => 'Ingresos', 'url' => '/reportes/ingresos'],
				['label' => 'Salidas', 'url' => '/reportes/salidas'],
				['label' => 'Móviles disponibles', 'url' => '/reportes/moviles_disponibles'],
			],
		],
		[
			'title' => 'Distribución y Transporte',
			'subtitle' => 'Monitoreo y cumplimiento en ruta',
			'icon' => 'bi-truck',
			'accent' => 'primary',
			'text_color' => 'text-white',
			'link_accent' => 'primary',
			'links' => [
				['label' => 'Monitoreo de embarques', 'url' => '/reportes/embarques_monitoreo'],
				['label' => 'Análisis de tiempos', 'url' => '/reportes/embarques_tiempos'],
				['label' => 'Cumplimiento de entregas', 'url' => '/reportes/embarques_cumplimiento'],
				['label' => 'Devoluciones y retornos', 'url' => '/reportes/embarques_devoluciones'],
			],
		],
		[
			'title' => 'Inventario',
			'subtitle' => 'Stock, rotación y alertas tempranas',
			'icon' => 'bi-box-seam',
			'accent' => 'secondary',
			'text_color' => 'text-dark',
			'link_accent' => 'secondary',
			'links' => [
				['label' => 'Existencias actuales', 'url' => '/inventario/existencias'],
				['label' => 'Próximos a vencer', 'url' => '/inventario/a_caducar'],
				['label' => 'Mínimos y máximos', 'url' => '/inventario/min_max'],
				['label' => 'Movimientos de inventario', 'url' => '/inventario/movimientos'],
			],
		],

	];
$gerenciales =
	[
		[
			'title' => 'Bodega',
			'subtitle' => 'Indices de bodega y eficiencia',
			'icon' => 'bi bi-building-fill',
			'accent' => 'info',
			'text_color' => 'text-white',
			'link_accent' => 'info',
			'links' => [
				['label' => 'Almacenamiento', 'url' => '/reportes/almacenamiento'],
				['label' => 'Capacidades de bodega', 'url' => '/reportes/capacidades_bodega'],
				['label' => 'Almacenamiento', 'url' => '/reportes/almacenamiento'],
				['label' => 'Quiebre de stock', 'url' => '/reportes/stock_quiebre'],
				['label' => 'Trazabilidad de productos', 'url' => '/reportes/trazabilidad_productos'],
			],
		],
		[
			'title' => 'Productividad',
			'subtitle' => 'Desempeño de operarios y equipos.',
			'icon' => 'bi bi-person-check',
			'accent' => 'warning',
			'text_color' => 'text-dark',
			'link_accent' => 'warning',
			'links' => [
				['label' => 'Pedidos por hora', 'url' => '/reportes/pedidos_hora'],
				['label' => 'Errores de picking', 'url' => '/reportes/errores_picking'],
				['label' => 'Distribución', 'url' => '/reportes/distribucion'],
				['label' => 'Costo por unidad transportada (en desarrollo)', 'url' => '/reportes/costo_unidad'],
				['label' => 'Utilización de montacargas (en desarrollo)', 'url' => '/reportes/utilizacion_montacargas'],
			],
		],
		[
			'title' => 'Clientes',
			'subtitle' => 'Niveles de servicio y SLA',
			'icon' => 'bi-people',
			'accent' => 'danger',
			'text_color' => 'text-white',
			'link_accent' => 'danger',
			'links' => [
				['label' => 'OTIF', 'url' => '/reportes/clientes_otif'],
				['label' => 'Ranking de clientes', 'url' => '/reportes/clientes_ranking'],
				['label' => 'SLA por cliente', 'url' => '/reportes/clientes_sla'],
				['label' => 'Servicio al Cliente', 'url' => '/reportes/servicio_cliente'],
				// ['label' => 'Cobertura por SKU', 'url' => '/reportes/cobertura_sku'],
			],
		],
		[
			'title' => 'Financieros',
			'subtitle' => 'Costos operativos y facturación',
			'icon' => 'bi-cash-coin',
			'accent' => 'success',
			'text_color' => 'text-white',
			'link_accent' => 'success',
			'links' => [
				['label' => 'Costeo de almacenaje', 'url' => '/reportes/costos_almacenaje'],
				['label' => 'Facturación logística', 'url' => '/reportes/facturacion'],
				['label' => 'Costo por Entregas', 'url' => '/reportes/costo_entrega'],
				['label' => 'Costo por unidad transportada (en desarrollo)', 'url' => '/reportes/costo_unidad'],
			],
		],
	];

if (!function_exists('e')) {
	function e(string $value): string
	{
		return htmlspecialchars($value, ENT_QUOTES, 'UTF-8');
	}
}
?>
<div class="row g-3 g-xl-4">
	<h3>Reportes Operativos</h3>
	<?php foreach ($sections as $section):
		$accent = $section['accent'];
		$textClass = $section['text_color'];
		$mutedClass = $textClass === 'text-dark' ? 'text-muted' : 'text-light';
		$linkAccent = $section['link_accent'];
		?>
		<div class="col-12 col-md-6 col-xl-4">
			<div class="card quick-link-card border-0 shadow-sm h-100">
				<div class="card-header border-0 bg-<?= e($accent) ?> <?= e($textClass) ?> py-4">
					<div class="d-flex align-items-start gap-3">
						<span
							class="d-inline-flex align-items-center justify-content-center rounded-circle border border-light shadow-sm"
							style="width:3rem;height:3rem;background-color:rgba(255,255,255,0.15);">
							<i class="bi <?= e($section['icon']) ?> fs-4 <?= e($textClass) ?>"></i>
						</span>
						<div class="flex-grow-1">
							<h5 class="mb-1 fw-semibold <?= e($textClass) ?>"><?= e($section['title']) ?></h5>
							<small class="<?= e($mutedClass) ?> d-block"><?= e($section['subtitle']) ?></small>
						</div>
					</div>
				</div>
				<div class="card-body p-0">
					<div class="list-group list-group-flush">
						<?php foreach ($section['links'] as $link): ?>
							<a class="list-group-item list-group-item-action py-3 d-flex align-items-center justify-content-between"
								href="<?= e(url($link['url'])) ?>">
								<span class="d-flex align-items-center gap-2">
									<i class="bi bi-arrow-right-short fs-4 text-<?= e($linkAccent) ?>"></i>
									<span class="fw-semibold"><?= e($link['label']) ?></span>
								</span>
								<i class="bi bi-chevron-right text-muted"></i>
							</a>
						<?php endforeach; ?>
					</div>
				</div>
			</div>
		</div>
	<?php endforeach; ?>
	<h3>Reportes Gerenciales</h3>
	<?php foreach ($gerenciales as $section):
		$accent = $section['accent'];
		$textClass = $section['text_color'];
		$mutedClass = $textClass === 'text-dark' ? 'text-muted' : 'text-light';
		$linkAccent = $section['link_accent'];
		?>
		<div class="col-12 col-md-6 col-xl-3">
			<div class="card quick-link-card border-0 shadow-sm h-100">
				<div class="card-header border-0 bg-<?= e($accent) ?> <?= e($textClass) ?> py-4">
					<div class="d-flex align-items-start gap-3">
						<span
							class="d-inline-flex align-items-center justify-content-center rounded-circle border border-light shadow-sm"
							style="width:3rem;height:3rem;background-color:rgba(255,255,255,0.15);">
							<i class="bi <?= e($section['icon']) ?> fs-4 <?= e($textClass) ?>"></i>
						</span>
						<div class="flex-grow-1">
							<h5 class="mb-1 fw-semibold <?= e($textClass) ?>"><?= e($section['title']) ?></h5>
							<small class="<?= e($mutedClass) ?> d-block"><?= e($section['subtitle']) ?></small>
						</div>
					</div>
				</div>
				<div class="card-body p-0">
					<div class="list-group list-group-flush">
						<?php foreach ($section['links'] as $link): ?>
							<a class="list-group-item list-group-item-action py-3 d-flex align-items-center justify-content-between"
								href="<?= e(url($link['url'])) ?>">
								<span class="d-flex align-items-center gap-2">
									<i class="bi bi-arrow-right-short fs-4 text-<?= e($linkAccent) ?>"></i>
									<span class="fw-semibold"><?= e($link['label']) ?></span>
								</span>
								<i class="bi bi-chevron-right text-muted"></i>
							</a>
						<?php endforeach; ?>
					</div>
				</div>
			</div>
		</div>
	<?php endforeach; ?>
</div>
<?php
$content = ob_get_clean();

include project_path('views/layout/layout_app.php');
