<?php

declare(strict_types=1);

/**
 * SOL - Sistema de Operaciones Logísticas
 * Vista: Reporte de Ingresos
 */

$BASE = dirname(__DIR__, 3);
require_once $BASE . '/app/Support/ViewHelpers.php';
require_once $BASE . '/app/Support/Assets.php';

sol_section('page_title', 'Reportes · Ingresos');
sol_section('breadcrumb', [
    ['label' => 'Inicio', 'url' => '/home'],
    ['label' => 'Reportes', 'url' => '/reportes'],
    ['label' => 'Ingresos', 'url' => null],
]);

sol_dt_assets('/page-scripts/pages/reportes/ingresos.js');

ob_start();
?>

<div class="container-fluid py-4">

  <!-- Filtros -->
  <div class="card mb-4">
    <div class="card-header">
      <h5 class="card-title mb-0"><i class="bi bi-funnel me-2"></i>Filtros de búsqueda</h5>
    </div>
    <div class="card-body">
      <form id="frmIngresos" autocomplete="off">
        <div class="row g-3">
          <div class="col-sm-6 col-lg-3">
            <label class="form-label" for="fecha_desde">Fecha desde</label>
            <input type="date" class="form-control" id="fecha_desde" name="fecha_desde">
          </div>
          <div class="col-sm-6 col-lg-3">
            <label class="form-label" for="fecha_hasta">Fecha hasta</label>
            <input type="date" class="form-control" id="fecha_hasta" name="fecha_hasta">
          </div>
          <div class="col-sm-6 col-lg-3">
            <label class="form-label" for="cliente_id">Cliente</label>
            <select class="form-select" id="cliente_id" name="cliente_id">
              <option value="">Todos</option>
            </select>
          </div>
          <div class="col-sm-6 col-lg-3">
            <label class="form-label" for="deposito_id">Depósito</label>
            <select class="form-select" id="deposito_id" name="deposito_id">
              <option value="">Todos</option>
            </select>
          </div>
          <div class="col-sm-6 col-lg-3">
            <label class="form-label" for="estado">Estado</label>
            <select class="form-select" id="estado" name="estado">
              <option value="">Todos</option>
            </select>
          </div>
          <div class="col-sm-6 col-lg-3">
            <label class="form-label" for="movil_id">Móvil</label>
            <select class="form-select" id="movil_id" name="movil_id">
              <option value="">Todos</option>
            </select>
          </div>
          <div class="col-sm-6 col-lg-3">
            <label class="form-label" for="codigo">Packing List</label>
            <input type="text" class="form-control" id="codigo" name="codigo" placeholder="Ej. PL-2025-001">
          </div>
          <div class="col-sm-6 col-lg-3">
            <label class="form-label" for="doc_numero">Nº de documento</label>
            <input type="text" class="form-control" id="doc_numero" name="doc_numero" placeholder="Factura / Remito">
          </div>
          <div class="col-12 d-flex flex-wrap gap-2 justify-content-end align-items-end">
            <button type="submit" class="btn btn-primary" id="btnBuscar">
              <i class="bi bi-search me-1"></i>Buscar
            </button>
            <button type="button" class="btn btn-outline-secondary" id="btnLimpiar">
              <i class="bi bi-arrow-counterclockwise me-1"></i>Limpiar
            </button>
            <button type="button" class="btn btn-outline-danger" id="btnExportPdf" disabled>
              <i class="bi bi-filetype-pdf me-1"></i>Descargar PDF
            </button>
          </div>
        </div>
      </form>
    </div>
  </div>

  <!-- Resumen -->
  <div class="card mb-4" id="summaryCard" style="display:none;">
    <div class="card-header d-flex justify-content-between align-items-center">
      <h5 class="card-title mb-0"><i class="bi bi-graph-up me-2"></i>Resumen del período</h5>
      <small class="text-muted" id="summaryRange"></small>
    </div>
    <div class="card-body">
      <div class="row g-3 text-center">
        <div class="col-6 col-lg-3">
          <div class="border rounded p-3 h-100">
            <div class="text-muted text-uppercase small">Ingresos</div>
            <div class="fs-4 fw-semibold" id="sumIngresos">-</div>
            <div class="small text-muted" id="sumIngresosSub">-</div>
          </div>
        </div>
        <div class="col-6 col-lg-3">
          <div class="border rounded p-3 h-100">
            <div class="text-muted text-uppercase small">Clientes</div>
            <div class="fs-4 fw-semibold" id="sumClientes">-</div>
            <div class="small text-muted" id="sumClientesSub">-</div>
          </div>
        </div>
        <div class="col-6 col-lg-3">
          <div class="border rounded p-3 h-100">
            <div class="text-muted text-uppercase small">Pallets</div>
            <div class="fs-4 fw-semibold" id="sumPallets">-</div>
            <div class="small text-muted" id="sumPalletsSub">-</div>
          </div>
        </div>
        <div class="col-6 col-lg-3">
          <div class="border rounded p-3 h-100">
            <div class="text-muted text-uppercase small">Unidades (UC)</div>
            <div class="fs-4 fw-semibold" id="sumUc">-</div>
            <div class="small text-muted" id="sumUcSub">-</div>
          </div>
        </div>
      </div>
    </div>
  </div>

  <!-- Agregados -->
  <div class="row mb-4 g-4">
    <div class="col-12 col-xl-4">
      <div class="card h-100" id="cardClientes" style="display:none;">
        <div class="card-header d-flex justify-content-between align-items-center">
          <h5 class="card-title mb-0"><i class="bi bi-people me-2"></i>Top clientes</h5>
          <small class="text-muted" id="clientesSummary"></small>
        </div>
        <div class="card-body p-0">
          <div class="table-responsive">
            <table class="table table-sm table-hover mb-0" id="tablaClientes">
              <thead class="table-light">
                <tr>
                  <th>Cliente</th>
                  <th class="text-end">Ingresos</th>
                  <th class="text-end">Pallets</th>
                  <th class="text-end">UV</th>
                  <th class="text-end">UC</th>
                </tr>
              </thead>
              <tbody>
                <tr class="text-muted">
                  <td colspan="5" class="text-center py-4">Sin datos disponibles</td>
                </tr>
              </tbody>
            </table>
          </div>
        </div>
      </div>
    </div>
    <div class="col-12 col-xl-4">
      <div class="card h-100" id="cardDepositos" style="display:none;">
        <div class="card-header d-flex justify-content-between align-items-center">
          <h5 class="card-title mb-0"><i class="bi bi-building me-2"></i>Top depósitos</h5>
          <small class="text-muted" id="depositosSummary"></small>
        </div>
        <div class="card-body p-0">
          <div class="table-responsive">
            <table class="table table-sm table-hover mb-0" id="tablaDepositos">
              <thead class="table-light">
                <tr>
                  <th>Depósito</th>
                  <th class="text-end">Ingresos</th>
                  <th class="text-end">Pallets</th>
                  <th class="text-end">UV</th>
                  <th class="text-end">UC</th>
                </tr>
              </thead>
              <tbody>
                <tr class="text-muted">
                  <td colspan="5" class="text-center py-4">Sin datos disponibles</td>
                </tr>
              </tbody>
            </table>
          </div>
        </div>
      </div>
    </div>
    <div class="col-12 col-xl-4">
      <div class="card h-100" id="cardEstados" style="display:none;">
        <div class="card-header d-flex justify-content-between align-items-center">
          <h5 class="card-title mb-0"><i class="bi bi-clipboard-data me-2"></i>Estadísticas por estado</h5>
          <small class="text-muted" id="estadosSummary"></small>
        </div>
        <div class="card-body p-0">
          <div class="table-responsive">
            <table class="table table-sm table-hover mb-0" id="tablaEstados">
              <thead class="table-light">
                <tr>
                  <th>Estado</th>
                  <th class="text-end">Ingresos</th>
                  <th class="text-end">Pallets</th>
                  <th class="text-end">UV</th>
                  <th class="text-end">UC</th>
                </tr>
              </thead>
              <tbody>
                <tr class="text-muted">
                  <td colspan="5" class="text-center py-4">Sin datos disponibles</td>
                </tr>
              </tbody>
            </table>
          </div>
        </div>
      </div>
    </div>
  </div>

  <!-- Tabla principal -->
  <div class="card">
    <div class="card-header d-flex justify-content-between align-items-center">
      <h5 class="card-title mb-0"><i class="bi bi-table me-2"></i>Detalle de ingresos</h5>
      <span class="badge bg-primary" id="badgeTotalIngresos">0</span>
    </div>
    <div class="card-body">
      <div class="table-responsive">
        <table id="tblIngresos" class="table table-striped table-hover align-middle" style="width:100%">
          <thead>
            <tr>
              <th>Fecha</th>
              <th>Packing List</th>
              <th>Cliente</th>
              <th>Depósito</th>
              <th>Estado</th>
              <th>Documento</th>
              <th>Camión</th>
              <th>Chofer</th>
              <th class="text-end">Pallets</th>
              <th class="text-end">UV</th>
              <th class="text-end">UC</th>
              <th class="text-end">Ítems</th>
              <th class="text-end">Operarios</th>
            </tr>
          </thead>
          <tbody></tbody>
        </table>
      </div>
      <p class="small text-muted mt-2" id="limitNotice" style="display:none;">
        Se muestra un máximo de <span id="limitValue">0</span> ingresos. Refine los filtros para detalle adicional.
      </p>
    </div>
  </div>

</div>

<?php
$content = ob_get_clean();
include project_path('views/layout/layout_app.php');
