<?php

declare(strict_types=1);

/**
 * SOL - Sistema de Operaciones Logísticas
 * Vista: Reporte de Móviles Disponibles
 */

$BASE = dirname(__DIR__, 3);
require_once $BASE . '/app/Support/ViewHelpers.php';
require_once $BASE . '/app/Support/Assets.php';

sol_section('page_title', 'Reportes · Móviles disponibles');
sol_section('breadcrumb', [
    ['label' => 'Inicio', 'url' => '/home'],
    ['label' => 'Reportes', 'url' => '/reportes'],
    ['label' => 'Móviles disponibles', 'url' => null],
]);

sol_dt_assets('/page-scripts/pages/reportes/moviles_disponibles.js');

ob_start();
?>

<div class="container-fluid py-4">

  <!-- Filtros -->
  <div class="card mb-4">
    <div class="card-header">
      <h5 class="card-title mb-0"><i class="bi bi-funnel me-2"></i>Filtros de búsqueda</h5>
    </div>
    <div class="card-body">
      <form id="frmMoviles" autocomplete="off">
        <div class="row g-3">
          <div class="col-sm-6 col-lg-3">
            <label class="form-label" for="fecha_desde">Fecha desde</label>
            <input type="date" class="form-control" id="fecha_desde" name="fecha_desde">
          </div>
          <div class="col-sm-6 col-lg-3">
            <label class="form-label" for="fecha_hasta">Fecha hasta</label>
            <input type="date" class="form-control" id="fecha_hasta" name="fecha_hasta">
          </div>
          <div class="col-sm-6 col-lg-3">
            <label class="form-label" for="transportadora_id">Transportadora</label>
            <select class="form-select" id="transportadora_id" name="transportadora_id">
              <option value="">Todas</option>
            </select>
          </div>
          <div class="col-sm-6 col-lg-3">
            <label class="form-label" for="movil_id">Móvil</label>
            <select class="form-select" id="movil_id" name="movil_id">
              <option value="">Todos</option>
            </select>
          </div>
          <div class="col-sm-6 col-lg-3">
            <label class="form-label" for="disponible">Disponibilidad</label>
            <select class="form-select" id="disponible" name="disponible">
              <option value="">Todos</option>
              <option value="1">Disponibles</option>
              <option value="0">No disponibles</option>
            </select>
          </div>
          <div class="col-sm-6 col-lg-3">
            <label class="form-label" for="no_asistio">No asistió</label>
            <select class="form-select" id="no_asistio" name="no_asistio">
              <option value="">Todos</option>
              <option value="1">Sí</option>
              <option value="0">No</option>
            </select>
          </div>
          <div class="col-sm-6 col-lg-3">
            <label class="form-label" for="no_utilizado">No utilizado</label>
            <select class="form-select" id="no_utilizado" name="no_utilizado">
              <option value="">Todos</option>
              <option value="1">Sí</option>
              <option value="0">No</option>
            </select>
          </div>
          <div class="col-sm-6 col-lg-3">
            <label class="form-label" for="buscar">Buscar</label>
            <input type="text" class="form-control" id="buscar" name="buscar" placeholder="Transportadora, móvil o nota">
          </div>
          <div class="col-12 d-flex flex-wrap gap-2 justify-content-end align-items-end">
            <button type="submit" class="btn btn-primary" id="btnBuscar">
              <i class="bi bi-search me-1"></i>Buscar
            </button>
            <button type="button" class="btn btn-outline-secondary" id="btnLimpiar">
              <i class="bi bi-arrow-counterclockwise me-1"></i>Limpiar
            </button>
            <button type="button" class="btn btn-outline-danger" id="btnExportPdf" disabled>
              <i class="bi bi-filetype-pdf me-1"></i>Descargar PDF
            </button>
          </div>
        </div>
      </form>
    </div>
  </div>

  <!-- Resumen -->
  <div class="card mb-4" id="summaryCard" style="display:none;">
    <div class="card-header d-flex justify-content-between align-items-center">
      <h5 class="card-title mb-0"><i class="bi bi-graph-up me-2"></i>Resumen del período</h5>
      <small class="text-muted" id="summaryRange"></small>
    </div>
    <div class="card-body">
      <div class="row g-3 text-center">
        <div class="col-6 col-xl-3">
          <div class="border rounded p-3 h-100">
            <div class="text-muted text-uppercase small">Registros</div>
            <div class="fs-4 fw-semibold" id="sumRegistros">-</div>
            <div class="small text-muted" id="sumRegistrosSub">-</div>
          </div>
        </div>
        <div class="col-6 col-xl-3">
          <div class="border rounded p-3 h-100">
            <div class="text-muted text-uppercase small">Disponibles</div>
            <div class="fs-4 fw-semibold" id="sumDisponibles">-</div>
            <div class="small text-muted" id="sumDisponiblesSub">-</div>
          </div>
        </div>
        <div class="col-6 col-xl-3">
          <div class="border rounded p-3 h-100">
            <div class="text-muted text-uppercase small">No asistió</div>
            <div class="fs-4 fw-semibold" id="sumNoAsistio">-</div>
            <div class="small text-muted" id="sumNoAsistioSub">-</div>
          </div>
        </div>
        <div class="col-6 col-xl-3">
          <div class="border rounded p-3 h-100">
            <div class="text-muted text-uppercase small">No utilizado</div>
            <div class="fs-4 fw-semibold" id="sumNoUtilizado">-</div>
            <div class="small text-muted" id="sumNoUtilizadoSub">-</div>
          </div>
        </div>
      </div>
    </div>
  </div>

  <!-- Agregados -->
  <div class="row mb-4 g-4">
    <div class="col-12 col-xl-4">
      <div class="card h-100" id="cardTransportadoras" style="display:none;">
        <div class="card-header d-flex justify-content-between align-items-center">
          <h5 class="card-title mb-0"><i class="bi bi-truck me-2"></i>Top transportadoras</h5>
          <small class="text-muted" id="transportadorasSummary"></small>
        </div>
        <div class="card-body p-0">
          <div class="table-responsive">
            <table class="table table-sm table-hover mb-0" id="tablaTransportadoras">
              <thead class="table-light">
                <tr>
                  <th>Transportadora</th>
                  <th class="text-end">Registros</th>
                  <th class="text-end">Disponibles</th>
                  <th class="text-end">No asistió</th>
                </tr>
              </thead>
              <tbody>
                <tr class="text-muted">
                  <td colspan="4" class="text-center py-4">Sin datos disponibles</td>
                </tr>
              </tbody>
            </table>
          </div>
        </div>
      </div>
    </div>
    <div class="col-12 col-xl-4">
      <div class="card h-100" id="cardMoviles" style="display:none;">
        <div class="card-header d-flex justify-content-between align-items-center">
          <h5 class="card-title mb-0"><i class="bi bi-vehicle-front me-2"></i>Top móviles</h5>
          <small class="text-muted" id="movilesSummary"></small>
        </div>
        <div class="card-body p-0">
          <div class="table-responsive">
            <table class="table table-sm table-hover mb-0" id="tablaMoviles">
              <thead class="table-light">
                <tr>
                  <th>Móvil</th>
                  <th class="text-end">Registros</th>
                  <th class="text-end">Disponibles</th>
                  <th class="text-end">No utilizado</th>
                </tr>
              </thead>
              <tbody>
                <tr class="text-muted">
                  <td colspan="4" class="text-center py-4">Sin datos disponibles</td>
                </tr>
              </tbody>
            </table>
          </div>
        </div>
      </div>
    </div>
    <div class="col-12 col-xl-4">
      <div class="card h-100" id="cardFechas" style="display:none;">
        <div class="card-header d-flex justify-content-between align-items-center">
          <h5 class="card-title mb-0"><i class="bi bi-calendar-week me-2"></i>Resumen por fecha</h5>
          <small class="text-muted" id="fechasSummary"></small>
        </div>
        <div class="card-body p-0">
          <div class="table-responsive">
            <table class="table table-sm table-hover mb-0" id="tablaFechas">
              <thead class="table-light">
                <tr>
                  <th>Fecha</th>
                  <th class="text-end">Registros</th>
                  <th class="text-end">Disponibles</th>
                  <th class="text-end">No disponibles</th>
                </tr>
              </thead>
              <tbody>
                <tr class="text-muted">
                  <td colspan="4" class="text-center py-4">Sin datos disponibles</td>
                </tr>
              </tbody>
            </table>
          </div>
        </div>
      </div>
    </div>
  </div>

  <!-- Tabla principal -->
  <div class="card">
    <div class="card-header d-flex justify-content-between align-items-center">
      <h5 class="card-title mb-0"><i class="bi bi-table me-2"></i>Detalle de móviles</h5>
      <span class="badge bg-primary" id="badgeTotal">0</span>
    </div>
    <div class="card-body">
      <div class="table-responsive">
        <table id="tblMoviles" class="table table-striped table-hover align-middle" style="width:100%">
          <thead>
            <tr>
              <th>Fecha</th>
              <th>Móvil</th>
              <th>Transportadora</th>
              <th>Disponible</th>
              <th>Ventana</th>
              <th>Llegada</th>
              <th>No asistió</th>
              <th>No utilizado</th>
              <th>Notas</th>
            </tr>
          </thead>
          <tbody></tbody>
        </table>
      </div>
      <p class="small text-muted mt-2" id="limitNotice" style="display:none;">
        Se muestra un máximo de <span id="limitValue">0</span> registros. Refine los filtros para mayor detalle.
      </p>
    </div>
  </div>

</div>

<?php
$content = ob_get_clean();
include project_path('views/layout/layout_app.php');
