<?php

declare(strict_types=1);

/**
 * SOL - Sistema de Operaciones Logísticas
 * Vista: Reporte de Pedidos por Hora
 */

$BASE = dirname(__DIR__, 3);
require_once $BASE . '/app/Support/ViewHelpers.php';
require_once $BASE . '/app/Support/Assets.php';

sol_section('page_title', 'Reportes · Pedidos por hora');
sol_section('breadcrumb', [
    ['label' => 'Inicio', 'url' => '/home'],
    ['label' => 'Reportes', 'url' => '/reportes'],
    ['label' => 'Pedidos por hora', 'url' => null],
]);

sol_section('additional_css', '
<style>
.card-summary {
    border-left: 4px solid #0d6efd;
}
.card-summary.success { border-left-color: #198754; }
.card-summary.warning { border-left-color: #ffc107; }
.card-summary.info { border-left-color: #0dcaf0; }
#chartPedidosHora {
    max-height: 340px;
}
.table-sm tbody td {
    vertical-align: middle;
}
.badge-soft {
    background-color: rgba(13, 110, 253, 0.1);
    color: #0d6efd;
    border-radius: 999px;
    padding: 0.35rem 0.65rem;
    font-size: 0.8rem;
}
</style>
');

sol_assets_push(
    [],
    [url('/assets/js/chart/chartjs/chart.min.js')]
);

sol_assets_push(
    [],
    [url('/page-scripts/pages/reportes/pedidos_hora.js')]
);

ob_start();
?>

<div class="container-fluid py-4">

  <div class="card mb-4">
    <div class="card-header d-flex align-items-center justify-content-between">
      <h5 class="mb-0"><i class="bi bi-filter-circle me-2"></i>Filtros del reporte</h5>
      <small class="text-muted" id="rangeLabel"></small>
    </div>
    <div class="card-body">
      <form id="frmPedidosHora" autocomplete="off">
        <div class="row g-3 align-items-end">
          <div class="col-sm-6 col-lg-3">
            <label class="form-label" for="fecha_desde">Fecha desde</label>
            <input type="date" class="form-control" id="fecha_desde" name="fecha_desde">
          </div>
          <div class="col-sm-6 col-lg-3">
            <label class="form-label" for="fecha_hasta">Fecha hasta</label>
            <input type="date" class="form-control" id="fecha_hasta" name="fecha_hasta">
          </div>
          <div class="col-sm-6 col-lg-3">
            <label class="form-label" for="cliente_id">Cliente</label>
            <select class="form-select" id="cliente_id" name="cliente_id">
              <option value="">Todos</option>
            </select>
          </div>
          <div class="col-sm-6 col-lg-3">
            <label class="form-label" for="estado_id">Estado</label>
            <select class="form-select" id="estado_id" name="estado_id">
              <option value="">Todos</option>
            </select>
          </div>
          <div class="col-12 d-flex flex-wrap gap-2 justify-content-end">
            <button type="submit" class="btn btn-primary" id="btnBuscar">
              <i class="bi bi-search me-1"></i>Buscar
            </button>
            <button type="button" class="btn btn-outline-secondary" id="btnLimpiar">
              <i class="bi bi-arrow-counterclockwise me-1"></i>Limpiar
            </button>
            <button type="button" class="btn btn-outline-danger" id="btnExportPdf" disabled>
              <i class="bi bi-filetype-pdf me-1"></i>Descargar PDF
            </button>
          </div>
        </div>
      </form>
    </div>
  </div>

  <div class="row g-3 mb-4" id="summaryCards">
    <div class="col-12 col-lg-3">
      <div class="card card-summary h-100">
        <div class="card-body">
          <h6 class="text-muted text-uppercase mb-1">Total pedidos</h6>
          <h3 class="mb-1" id="sumTotalPedidos">-</h3>
          <small class="text-muted">Clientes: <span id="sumClientes">-</span> · Días: <span id="sumDias">-</span></small>
        </div>
      </div>
    </div>
    <div class="col-12 col-lg-3">
      <div class="card card-summary info h-100">
        <div class="card-body">
          <h6 class="text-muted text-uppercase mb-1">Promedios</h6>
          <h3 class="mb-1" id="sumPromedioDia">-</h3>
          <small class="text-muted">Por día · <span id="sumPromedioHora">-</span> por hora</small>
        </div>
      </div>
    </div>
    <div class="col-12 col-lg-3">
      <div class="card card-summary success h-100">
        <div class="card-body">
          <h6 class="text-muted text-uppercase mb-1">Hora pico</h6>
          <h3 class="mb-1" id="sumHoraPico">-</h3>
          <small class="text-muted">Pedidos: <span id="sumHoraPicoPedidos">-</span> · Horas activas: <span id="sumHorasActivas">-</span></small>
        </div>
      </div>
    </div>
    <div class="col-12 col-lg-3">
      <div class="card card-summary warning h-100">
        <div class="card-body">
          <h6 class="text-muted text-uppercase mb-1">Rango analizado</h6>
          <h3 class="mb-1" id="sumRange">-</h3>
          <small class="text-muted">Primer registro: <span id="sumPrimerRegistro">-</span></small><br>
          <small class="text-muted">Último registro: <span id="sumUltimoRegistro">-</span></small>
        </div>
      </div>
    </div>
  </div>

  <div class="card mb-4">
    <div class="card-header d-flex align-items-center justify-content-between">
      <h5 class="mb-0"><i class="bi bi-bar-chart-line me-2"></i>Pedidos por hora</h5>
      <span class="badge bg-primary" id="badgeTotalHoras">0</span>
    </div>
    <div class="card-body">
      <canvas id="chartPedidosHora"></canvas>
    </div>
  </div>

  <div class="row g-3 mb-4">
    <div class="col-12 col-xl-6">
      <div class="card h-100">
        <div class="card-header d-flex align-items-center justify-content-between">
          <h5 class="mb-0"><i class="bi bi-person-lines-fill me-2"></i>Top clientes</h5>
          <small class="text-muted" id="clientesSummary"></small>
        </div>
        <div class="card-body">
          <ul class="list-group" id="listaTopClientes"></ul>
        </div>
      </div>
    </div>
    <div class="col-12 col-xl-6">
      <div class="card h-100">
        <div class="card-header d-flex align-items-center justify-content-between">
          <h5 class="mb-0"><i class="bi bi-flag me-2"></i>Estados</h5>
          <small class="text-muted" id="estadosSummary"></small>
        </div>
        <div class="card-body">
          <ul class="list-group" id="listaTopEstados"></ul>
        </div>
      </div>
    </div>
  </div>

  <div class="card mb-4">
    <div class="card-header d-flex align-items-center justify-content-between">
      <h5 class="mb-0"><i class="bi bi-clock-history me-2"></i>Detalle por hora</h5>
      <small class="text-muted">Distribución porcentual de pedidos</small>
    </div>
    <div class="card-body p-0">
      <div class="table-responsive">
        <table class="table table-sm table-hover mb-0" id="tablaHoras">
          <thead class="table-light">
            <tr>
              <th>Hora</th>
              <th class="text-end">Pedidos</th>
              <th class="text-end">Prom. por día</th>
              <th class="text-end">Clientes</th>
              <th class="text-end">% del total</th>
            </tr>
          </thead>
          <tbody>
            <tr>
              <td colspan="5" class="text-center text-muted py-4">Sin datos disponibles</td>
            </tr>
          </tbody>
        </table>
      </div>
    </div>
  </div>

  <div class="card mb-4">
    <div class="card-header d-flex align-items-center justify-content-between">
      <h5 class="mb-0"><i class="bi bi-calendar-event me-2"></i>Detalle diario</h5>
      <small class="text-muted">Se muestran hasta <span id="limitDias">0</span> días</small>
    </div>
    <div class="card-body p-0">
      <div class="table-responsive">
        <table class="table table-sm table-striped mb-0" id="tablaDiaria">
          <thead class="table-light">
            <tr>
              <th>Fecha</th>
              <th class="text-end">Pedidos</th>
              <th class="text-end">Clientes</th>
              <th class="text-end">Primer pedido</th>
              <th class="text-end">Último pedido</th>
            </tr>
          </thead>
          <tbody>
            <tr>
              <td colspan="5" class="text-center text-muted py-4">Sin datos disponibles</td>
            </tr>
          </tbody>
        </table>
      </div>
      <p class="small text-muted px-3 py-2" id="limitNotice" style="display:none;">
        Refine el rango de fechas para visualizar más detalle.
      </p>
    </div>
  </div>

</div>

<?php
$content = ob_get_clean();
include project_path('views/layout/layout_app.php');
