<?php

declare(strict_types=1);

/**
 * SOL - Sistema de Operaciones Logísticas
 * Vista: Reporte de Salidas
 */

$BASE = dirname(__DIR__, 3);
require_once $BASE . '/app/Support/ViewHelpers.php';
require_once $BASE . '/app/Support/Assets.php';

sol_section('page_title', 'Reportes · Salidas');
sol_section('breadcrumb', [
    ['label' => 'Inicio', 'url' => '/home'],
    ['label' => 'Reportes', 'url' => '/reportes'],
    ['label' => 'Salidas', 'url' => null],
]);

sol_dt_assets('/page-scripts/pages/reportes/salidas.js');

ob_start();
?>

<div class="container-fluid py-4">

  <!-- Filtros -->
  <div class="card mb-4">
    <div class="card-header">
      <h5 class="card-title mb-0"><i class="bi bi-funnel me-2"></i>Filtros de búsqueda</h5>
    </div>
    <div class="card-body">
      <form id="frmSalidas" autocomplete="off">
        <div class="row g-3">
          <div class="col-sm-6 col-lg-3">
            <label class="form-label" for="fecha_desde">Fecha desde</label>
            <input type="date" class="form-control" id="fecha_desde" name="fecha_desde">
          </div>
          <div class="col-sm-6 col-lg-3">
            <label class="form-label" for="fecha_hasta">Fecha hasta</label>
            <input type="date" class="form-control" id="fecha_hasta" name="fecha_hasta">
          </div>
          <div class="col-sm-6 col-lg-3">
            <label class="form-label" for="deposito_id">Depósito</label>
            <select class="form-select" id="deposito_id" name="deposito_id">
              <option value="">Todos</option>
            </select>
          </div>
          <div class="col-sm-6 col-lg-3">
            <label class="form-label" for="estado">Estado</label>
            <select class="form-select" id="estado" name="estado">
              <option value="">Todos</option>
            </select>
          </div>
          <div class="col-sm-6 col-lg-3">
            <label class="form-label" for="movil_id">Móvil</label>
            <select class="form-select" id="movil_id" name="movil_id">
              <option value="">Todos</option>
            </select>
          </div>
          <div class="col-sm-6 col-lg-3">
            <label class="form-label" for="chofer_id">Chofer</label>
            <select class="form-select" id="chofer_id" name="chofer_id">
              <option value="">Todos</option>
            </select>
          </div>
          <div class="col-sm-6 col-lg-3">
            <label class="form-label" for="codigo">Código de salida</label>
            <input type="text" class="form-control" id="codigo" name="codigo" placeholder="Ej. EMB-2025-01">
          </div>
          <div class="col-12 d-flex flex-wrap gap-2 justify-content-end align-items-end">
            <button type="submit" class="btn btn-primary" id="btnBuscar">
              <i class="bi bi-search me-1"></i>Buscar
            </button>
            <button type="button" class="btn btn-outline-secondary" id="btnLimpiar">
              <i class="bi bi-arrow-counterclockwise me-1"></i>Limpiar
            </button>
            <button type="button" class="btn btn-outline-danger" id="btnExportPdf" disabled>
              <i class="bi bi-filetype-pdf me-1"></i>Descargar PDF
            </button>
          </div>
        </div>
      </form>
    </div>
  </div>

  <!-- Resumen -->
  <div class="card mb-4" id="summaryCard" style="display:none;">
    <div class="card-header d-flex justify-content-between align-items-center">
      <h5 class="card-title mb-0"><i class="bi bi-graph-up me-2"></i>Resumen del período</h5>
      <small class="text-muted" id="summaryRange"></small>
    </div>
    <div class="card-body">
      <div class="row g-3 text-center">
        <div class="col-6 col-xl-3">
          <div class="border rounded p-3 h-100">
            <div class="text-muted text-uppercase small">Salidas</div>
            <div class="fs-4 fw-semibold" id="sumSalidas">-</div>
            <div class="small text-muted" id="sumSalidasSub">-</div>
          </div>
        </div>
        <div class="col-6 col-xl-3">
          <div class="border rounded p-3 h-100">
            <div class="text-muted text-uppercase small">Destinos</div>
            <div class="fs-4 fw-semibold" id="sumDestinos">-</div>
            <div class="small text-muted" id="sumDestinosSub">-</div>
          </div>
        </div>
        <div class="col-6 col-xl-3">
          <div class="border rounded p-3 h-100">
            <div class="text-muted text-uppercase small">Preembarques</div>
            <div class="fs-4 fw-semibold" id="sumPreembarques">-</div>
            <div class="small text-muted" id="sumPreembarquesSub">-</div>
          </div>
        </div>
        <div class="col-6 col-xl-3">
          <div class="border rounded p-3 h-100">
            <div class="text-muted text-uppercase small">Tiempos promedio (min)</div>
            <div class="fs-4 fw-semibold" id="sumTiempos">-</div>
            <div class="small text-muted" id="sumTiemposSub">-</div>
          </div>
        </div>
      </div>
    </div>
  </div>

  <!-- Agregados -->
  <div class="row mb-4 g-4">
    <div class="col-12 col-xl-4">
      <div class="card h-100" id="cardDepositos" style="display:none;">
        <div class="card-header d-flex justify-content-between align-items-center">
          <h5 class="card-title mb-0"><i class="bi bi-building me-2"></i>Top depósitos</h5>
          <small class="text-muted" id="depositosSummary"></small>
        </div>
        <div class="card-body p-0">
          <div class="table-responsive">
            <table class="table table-sm table-hover mb-0" id="tablaDepositos">
              <thead class="table-light">
                <tr>
                  <th>Depósito</th>
                  <th class="text-end">Salidas</th>
                  <th class="text-end">Destinos</th>
                  <th class="text-end">Preembarques</th>
                </tr>
              </thead>
              <tbody>
                <tr class="text-muted">
                  <td colspan="4" class="text-center py-4">Sin datos disponibles</td>
                </tr>
              </tbody>
            </table>
          </div>
        </div>
      </div>
    </div>
    <div class="col-12 col-xl-4">
      <div class="card h-100" id="cardMoviles" style="display:none;">
        <div class="card-header d-flex justify-content-between align-items-center">
          <h5 class="card-title mb-0"><i class="bi bi-truck me-2"></i>Top móviles</h5>
          <small class="text-muted" id="movilesSummary"></small>
        </div>
        <div class="card-body p-0">
          <div class="table-responsive">
            <table class="table table-sm table-hover mb-0" id="tablaMoviles">
              <thead class="table-light">
                <tr>
                  <th>Móvil</th>
                  <th class="text-end">Salidas</th>
                  <th class="text-end">Destinos</th>
                  <th class="text-end">Tiempo planta</th>
                </tr>
              </thead>
              <tbody>
                <tr class="text-muted">
                  <td colspan="4" class="text-center py-4">Sin datos disponibles</td>
                </tr>
              </tbody>
            </table>
          </div>
        </div>
      </div>
    </div>
    <div class="col-12 col-xl-4">
      <div class="card h-100" id="cardEstados" style="display:none;">
        <div class="card-header d-flex justify-content-between align-items-center">
          <h5 class="card-title mb-0"><i class="bi bi-clipboard-data me-2"></i>Estadísticas por estado</h5>
          <small class="text-muted" id="estadosSummary"></small>
        </div>
        <div class="card-body p-0">
          <div class="table-responsive">
            <table class="table table-sm table-hover mb-0" id="tablaEstados">
              <thead class="table-light">
                <tr>
                  <th>Estado</th>
                  <th class="text-end">Salidas</th>
                  <th class="text-end">Destinos</th>
                  <th class="text-end">Preembarques</th>
                </tr>
              </thead>
              <tbody>
                <tr class="text-muted">
                  <td colspan="4" class="text-center py-4">Sin datos disponibles</td>
                </tr>
              </tbody>
            </table>
          </div>
        </div>
      </div>
    </div>
  </div>

  <!-- Tabla principal -->
  <div class="card">
    <div class="card-header d-flex justify-content-between align-items-center">
      <h5 class="card-title mb-0"><i class="bi bi-table me-2"></i>Detalle de salidas</h5>
      <span class="badge bg-primary" id="badgeTotalSalidas">0</span>
    </div>
    <div class="card-body">
      <div class="table-responsive">
        <table id="tblSalidas" class="table table-striped table-hover align-middle" style="width:100%">
          <thead>
            <tr>
              <th>Fecha</th>
              <th>Código</th>
              <th>Depósito</th>
              <th>Estado</th>
              <th>Móvil</th>
              <th>Chofer</th>
              <th class="text-end">Destinos</th>
              <th class="text-end">Preembarques</th>
              <th class="text-end">Espera (min)</th>
              <th class="text-end">Carga (min)</th>
              <th class="text-end">Planta (min)</th>
              <th class="text-end">Ayudantes</th>
              <th class="text-end">Temp. salida</th>
              <th class="text-end">Km inicial</th>
              <th>Observaciones</th>
            </tr>
          </thead>
          <tbody></tbody>
        </table>
      </div>
      <p class="small text-muted mt-2" id="limitNotice" style="display:none;">
        Se muestra un máximo de <span id="limitValue">0</span> salidas. Refine los filtros para mayor detalle.
      </p>
    </div>
  </div>

</div>

<?php
$content = ob_get_clean();
include project_path('views/layout/layout_app.php');
