<?php

declare(strict_types=1);

$BASE = dirname(__DIR__, 3);
require_once $BASE . '/app/Support/ViewHelpers.php';
require_once $BASE . '/app/Support/Assets.php';

sol_section('page_title', 'Reportes · Servicio al Cliente');
sol_section('breadcrumb', [
    ['label' => 'Inicio', 'url' => '/home'],
    ['label' => 'Reportes', 'url' => '/reportes'],
    ['label' => 'Servicio al Cliente', 'url' => null],
]);

sol_assets_push([], [url('/page-scripts/pages/reportes/servicio_cliente.js')]);

sol_section('additional_css', <<<'CSS'
<style>
.table-indicadores td { vertical-align: middle; }
.badge-semaforo { font-size: .75rem; padding: .35rem .65rem; border-radius: 999px; }
.metric-meta { font-size: .875rem; color: #6c757d; }
.summary-chip { border: 1px solid rgba(0,0,0,.08); border-radius: .75rem; padding: .75rem 1rem; background: #f8f9fa; }
.summary-chip h6 { font-size: .75rem; letter-spacing: .05em; text-transform: uppercase; color: #6c757d; margin-bottom: .25rem; }
.summary-chip span { font-weight: 600; font-size: 1.05rem; }
</style>
CSS);

ob_start();
?>
<div class="container-fluid py-4">
    <div class="row g-3 mb-3">
        <div class="col-lg-4">
            <div class="card h-100 shadow-sm">
                <div class="card-header">
                    <h5 class="card-title mb-0"><i class="bi bi-people me-2"></i>Filtros</h5>
                </div>
                <div class="card-body">
                    <form id="frmServicioCliente" class="row g-3">
                        <div class="col-12">
                            <label for="deposito_id" class="form-label">Depósito</label>
                            <select class="form-select" id="deposito_id" name="deposito_id">
                                <option value="">Todos</option>
                            </select>
                        </div>
                        <div class="col-12">
                            <label for="cliente_id" class="form-label">Cliente</label>
                            <select class="form-select" id="cliente_id" name="cliente_id">
                                <option value="">Todos</option>
                            </select>
                        </div>
                        <div class="col-12">
                            <label for="movil_id" class="form-label">Móvil</label>
                            <select class="form-select" id="movil_id" name="movil_id">
                                <option value="">Todos</option>
                            </select>
                        </div>
                        <div class="col-6">
                            <label for="fecha_desde" class="form-label">Fecha desde</label>
                            <input type="date" class="form-control" id="fecha_desde" name="fecha_desde">
                        </div>
                        <div class="col-6">
                            <label for="fecha_hasta" class="form-label">Fecha hasta</label>
                            <input type="date" class="form-control" id="fecha_hasta" name="fecha_hasta">
                        </div>
                        <div class="col-6">
                            <label for="tolerancia_min" class="form-label">Tolerancia puntualidad (min)</label>
                            <input type="number" class="form-control" id="tolerancia_min" name="tolerancia_min" min="5" step="5" value="60">
                        </div>
                        <div class="col-6">
                            <label for="meta_otif" class="form-label">Meta OTIF (%)</label>
                            <input type="number" class="form-control" id="meta_otif" name="meta_otif" min="0" max="100" step="0.1" value="98">
                        </div>
                        <div class="col-6">
                            <label for="meta_reclamaciones" class="form-label">Meta reclamaciones (%)</label>
                            <input type="number" class="form-control" id="meta_reclamaciones" name="meta_reclamaciones" min="0" max="100" step="0.1" value="1">
                        </div>
                        <div class="col-6">
                            <label for="meta_satisfaccion" class="form-label">Meta satisfacción (%)</label>
                            <input type="number" class="form-control" id="meta_satisfaccion" name="meta_satisfaccion" min="0" max="100" step="0.1" value="95">
                        </div>
                        <div class="col-12 d-flex gap-2">
                            <button type="submit" class="btn btn-primary flex-grow-1"><i class="bi bi-search me-1"></i>Aplicar</button>
                            <button type="button" id="btnServicioLimpiar" class="btn btn-outline-secondary"><i class="bi bi-eraser me-1"></i>Limpiar</button>
                        </div>
                    </form>
                </div>
            </div>
        </div>
        <div class="col-lg-8">
            <div class="card shadow-sm h-100">
                <div class="card-header d-flex justify-content-between align-items-center">
                    <div>
                        <h5 class="card-title mb-0"><i class="bi bi-clipboard-check me-2"></i>Servicio al Cliente</h5>
                        <small class="text-muted" id="servicioPeriodo">Seleccione filtros para ver resultados</small>
                    </div>
                </div>
                <div class="card-body">
                    <div class="table-responsive" id="tablaServicioCliente">
                        <table class="table table-striped table-hover table-indicadores align-middle">
                            <thead class="table-light">
                                <tr>
                                    <th>Indicador</th>
                                    <th>Fórmula / Descripción</th>
                                    <th>Meta</th>
                                    <th>Resultado</th>
                                    <th>Semáforo</th>
                                    <th>Observaciones</th>
                                </tr>
                            </thead>
                            <tbody>
                                <tr data-metric="otif">
                                    <td data-field="indicador" data-default="OTIF (On Time In Full) cumplimiento de pedidos">OTIF (On Time In Full) cumplimiento de pedidos</td>
                                    <td data-field="formula">(Pedidos completos y a tiempo / Total de pedidos) × 100</td>
                                    <td data-field="meta" class="metric-meta">-</td>
                                    <td data-field="resultado">-</td>
                                    <td><span class="badge badge-semaforo bg-secondary" data-field="semaforo">Sin datos</span></td>
                                    <td data-field="observaciones">Sin datos</td>
                                </tr>
                                <tr data-metric="reclamaciones">
                                    <td data-field="indicador" data-default="Tasa de reclamaciones (%)">Tasa de reclamaciones (%)</td>
                                    <td data-field="formula">(Reclamaciones / Pedidos entregados) × 100</td>
                                    <td data-field="meta" class="metric-meta">-</td>
                                    <td data-field="resultado">-</td>
                                    <td><span class="badge badge-semaforo bg-secondary" data-field="semaforo">Sin datos</span></td>
                                    <td data-field="observaciones">Sin datos</td>
                                </tr>
                                <tr data-metric="satisfaccion">
                                    <td data-field="indicador" data-default="Nivel de satisfacción del cliente">Nivel de satisfacción del cliente</td>
                                    <td data-field="formula">Encuesta post-entrega</td>
                                    <td data-field="meta" class="metric-meta">-</td>
                                    <td data-field="resultado">-</td>
                                    <td><span class="badge badge-semaforo bg-secondary" data-field="semaforo">Sin datos</span></td>
                                    <td data-field="observaciones">Sin datos</td>
                                </tr>
                            </tbody>
                        </table>
                    </div>
                </div>
                <div class="card-footer bg-primary text-white">
                    <div class="row g-2" id="servicioResumen">
                        <div class="col-md-3">
                            <div class="summary-chip">
                                <h6>Pedidos evaluados</h6>
                                <span data-field="pedidos_totales">-</span>
                            </div>
                        </div>
                        <div class="col-md-3">
                            <div class="summary-chip">
                                <h6>OTIF</h6>
                                <span data-field="otif_pct">-</span>
                            </div>
                        </div>
                        <div class="col-md-3">
                            <div class="summary-chip">
                                <h6>Reclamaciones</h6>
                                <span data-field="reclamos">-</span>
                            </div>
                        </div>
                        <div class="col-md-3">
                            <div class="summary-chip">
                                <h6>Encuestas</h6>
                                <span data-field="encuestas">-</span>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <div class="alert alert-info d-flex align-items-start" role="alert">
        <i class="bi bi-info-circle me-2 fs-4"></i>
        <div>
            Los colores del semáforo siguen el mismo criterio que el tablero de distribución: verde al cumplir la meta, amarillo para desviaciones moderadas y rojo cuando cae en zona crítica.
        </div>
    </div>
</div>
<?php
$content = ob_get_clean();
include project_path('views/layout/layout_app.php');
