<?php

declare(strict_types=1);

/**
 * SOL - Sistema de Operaciones Logísticas
 * Vista: Reporte de Quiebre de Stock
 */

$BASE = dirname(__DIR__, 3);
require_once $BASE . '/app/Support/ViewHelpers.php';
require_once $BASE . '/app/Support/Assets.php';

sol_section('page_title', 'Reportes · Quiebre de stock');
sol_section('breadcrumb', [
    ['label' => 'Inicio', 'url' => '/home'],
    ['label' => 'Reportes', 'url' => '/reportes'],
    ['label' => 'Quiebre de stock', 'url' => null],
]);

sol_dt_assets('/page-scripts/pages/reportes/stock_quiebre.js');

sol_section('additional_css', '<style>
.metric-card {
    border-left: 4px solid #dc3545;
    transition: box-shadow 0.2s ease-in-out;
}
.metric-card:hover {
    box-shadow: 0 0.75rem 1.5rem rgba(0,0,0,0.1);
}
.metric-card.success { border-left-color: #198754; }
.metric-card.info { border-left-color: #0dcaf0; }
.metric-card.warning { border-left-color: #ffc107; }
</style>');

ob_start();
?>

<div class="container-fluid py-4">
    <div class="card mb-4">
        <div class="card-header">
            <h5 class="card-title mb-0"><i class="bi bi-funnel me-2"></i>Filtros</h5>
        </div>
        <div class="card-body">
            <form id="frmStockQuiebre">
                <div class="row g-3">
                    <div class="col-md-4 col-lg-3">
                        <label for="cliente_id" class="form-label">Cliente</label>
                        <select id="cliente_id" name="cliente_id" class="form-select">
                            <option value="">Todos los clientes</option>
                        </select>
                    </div>
                    <div class="col-md-4 col-lg-3">
                        <label for="operativa_id" class="form-label">Operativa</label>
                        <select id="operativa_id" name="operativa_id" class="form-select">
                            <option value="">Todas las operativas</option>
                        </select>
                    </div>
                    <div class="col-md-4 col-lg-3">
                        <label for="q" class="form-label">Producto (SKU o nombre)</label>
                        <input type="text" id="q" name="q" class="form-control" placeholder="Ej: 12345 o Yogur">
                    </div>
                    <div class="col-md-4 col-lg-2">
                        <label for="criterio" class="form-label">Comparar con</label>
                        <select id="criterio" name="criterio" class="form-select">
                            <option value="disponibles">Disponibles</option>
                            <option value="stock">Stock total</option>
                        </select>
                    </div>
                    <div class="col-md-4 col-lg-1 d-flex align-items-end">
                        <div class="form-check">
                            <input class="form-check-input" type="checkbox" id="solo_con_min" name="solo_con_min" value="1" checked>
                            <label class="form-check-label" for="solo_con_min">Sólo con mínimo</label>
                        </div>
                    </div>
                    <div class="col-12 d-flex gap-2 justify-content-end">
                        <button type="submit" class="btn btn-primary">
                            <i class="bi bi-search me-1"></i>Buscar
                        </button>
                        <button type="button" class="btn btn-outline-secondary" id="btnLimpiar">
                            <i class="bi bi-arrow-counterclockwise me-1"></i>Limpiar
                        </button>
                        <button type="button" class="btn btn-outline-danger" id="btnExportPdf" disabled>
                            <i class="bi bi-filetype-pdf me-1"></i>Exportar PDF
                        </button>
                    </div>
                </div>
            </form>
        </div>
    </div>

    <div class="row g-3 mb-4" id="summaryCards">
        <div class="col-md-3">
            <div class="card metric-card h-100">
                <div class="card-body">
                    <div class="d-flex justify-content-between align-items-center">
                        <div>
                            <h6 class="text-muted mb-1">Productos en quiebre</h6>
                            <h3 class="mb-0" id="metricProductos">-</h3>
                        </div>
                        <span class="bg-danger bg-opacity-10 text-danger rounded-circle p-3">
                            <i class="bi bi-exclamation-triangle"></i>
                        </span>
                    </div>
                    <small class="text-muted">Ítems con cobertura por debajo del mínimo configurado</small>
                </div>
            </div>
        </div>
        <div class="col-md-3">
            <div class="card metric-card warning h-100">
                <div class="card-body">
                    <div class="d-flex justify-content-between align-items-center">
                        <div>
                            <h6 class="text-muted mb-1">Faltante total (UC)</h6>
                            <h3 class="mb-0" id="metricFaltante">-</h3>
                        </div>
                        <span class="bg-warning bg-opacity-10 text-warning rounded-circle p-3">
                            <i class="bi bi-graph-down"></i>
                        </span>
                    </div>
                    <small class="text-muted">Unidades necesarias para alcanzar el mínimo</small>
                </div>
            </div>
        </div>
        <div class="col-md-3">
            <div class="card metric-card success h-100">
                <div class="card-body">
                    <div class="d-flex justify-content-between align-items-center">
                        <div>
                            <h6 class="text-muted mb-1">Disponibles actuales (UC)</h6>
                            <h3 class="mb-0" id="metricDisponibles">-</h3>
                        </div>
                        <span class="bg-success bg-opacity-10 text-success rounded-circle p-3">
                            <i class="bi bi-box-seam"></i>
                        </span>
                    </div>
                    <small class="text-muted">Unidades disponibles después de reservas</small>
                </div>
            </div>
        </div>
        <div class="col-md-3">
            <div class="card metric-card info h-100">
                <div class="card-body">
                    <div class="d-flex justify-content-between align-items-center">
                        <div>
                            <h6 class="text-muted mb-1">Cobertura promedio</h6>
                            <h3 class="mb-0" id="metricCobertura">-</h3>
                        </div>
                        <span class="bg-info bg-opacity-10 text-info rounded-circle p-3">
                            <i class="bi bi-speedometer"></i>
                        </span>
                    </div>
                    <small class="text-muted">Relación entre disponibilidad y mínimo</small>
                </div>
            </div>
        </div>
    </div>

    <div class="card">
        <div class="card-header d-flex justify-content-between align-items-center">
            <h5 class="card-title mb-0"><i class="bi bi-table me-2"></i>Productos con quiebre</h5>
            <span class="badge bg-danger" id="badgeTotalProductos">0</span>
        </div>
        <div class="card-body">
            <div class="table-responsive">
                <table id="tblQuiebre" class="table table-striped table-hover align-middle" style="width:100%">
                    <thead class="table-light">
                        <tr>
                            <th>Cliente</th>
                            <th>Operativa</th>
                            <th>SKU</th>
                            <th>Producto</th>
                            <th class="text-end">Mínimo</th>
                            <th class="text-end">Stock</th>
                            <th class="text-end">Reservados</th>
                            <th class="text-end">Disponibles</th>
                            <th class="text-end">Faltante</th>
                            <th class="text-end">Cobertura</th>
                        </tr>
                    </thead>
                    <tbody>
                        <tr class="text-muted">
                            <td colspan="10" class="text-center py-4">
                                <div class="spinner-border spinner-border-sm me-2" role="status"></div>
                                Cargando datos...
                            </td>
                        </tr>
                    </tbody>
                </table>
            </div>
            <p class="small text-muted mt-2" id="limitNotice" style="display:none;">
                Se muestra un máximo de <span id="limitValue">0</span> productos. Refine los filtros para detalle adicional.
            </p>
        </div>
    </div>
</div>

<?php
$content = ob_get_clean();
include project_path('views/layout/layout_app.php');
