<?php

declare(strict_types=1);

$BASE = dirname(__DIR__, 3);
require_once $BASE . '/app/Support/ViewHelpers.php';
require_once $BASE . '/app/Support/Assets.php';

sol_section('page_title', 'Reportes · Trazabilidad de productos');
sol_section('breadcrumb', [
    ['label' => 'Inicio', 'url' => '/home'],
    ['label' => 'Reportes', 'url' => '/reportes'],
    ['label' => 'Trazabilidad de productos', 'url' => null],
]);

sol_dt_assets('/page-scripts/pages/reportes/trazabilidad_productos.js');

ob_start();
?>
<div class="container-fluid py-4">

  <div class="card mb-4">
    <div class="card-header d-flex justify-content-between align-items-center">
      <h5 class="card-title mb-0"><i class="bi bi-search me-2"></i>Buscar trazabilidad</h5>
      <small class="text-muted">Ingrese al menos un SKU, lote o código de pallet</small>
    </div>
    <div class="card-body">
      <form id="frmTrazabilidad" autocomplete="off" class="row g-3">
        <div class="col-sm-6 col-lg-3">
          <label class="form-label" for="sku">SKU / Producto</label>
          <input type="text" class="form-control" id="sku" name="sku" placeholder="Ej: SKU1234" list="skuSuggestions">
          <div class="form-text">Coincidencia parcial por código o denominación</div>
        </div>
        <div class="col-sm-6 col-lg-3">
          <label class="form-label" for="lote">Lote</label>
          <input type="text" class="form-control" id="lote" name="lote" placeholder="Lote, serie o batch">
        </div>
        <div class="col-sm-6 col-lg-3">
          <label class="form-label" for="pallet">Código de pallet</label>
          <input type="text" class="form-control" id="pallet" name="pallet" placeholder="PAL-000123">
        </div>
        <div class="col-sm-6 col-lg-3">
          <label class="form-label" for="fecha_desde">Movimientos desde</label>
          <input type="date" class="form-control" id="fecha_desde" name="fecha_desde">
        </div>
        <div class="col-sm-6 col-lg-3">
          <label class="form-label" for="fecha_hasta">Movimientos hasta</label>
          <input type="date" class="form-control" id="fecha_hasta" name="fecha_hasta">
        </div>
        <div class="col-12 d-flex justify-content-end gap-2 mt-2">
          <button type="submit" class="btn btn-primary" id="btnBuscar">
            <i class="bi bi-search me-1"></i>Buscar
          </button>
          <button type="button" class="btn btn-outline-secondary" id="btnLimpiar">
            <i class="bi bi-arrow-counterclockwise me-1"></i>Limpiar
          </button>
        </div>
      </form>
      <datalist id="skuSuggestions"></datalist>
    </div>
  </div>

  <div class="card mb-4" id="cardResumen" style="display:none;">
    <div class="card-header d-flex flex-wrap justify-content-between align-items-center gap-2">
      <h5 class="card-title mb-0"><i class="bi bi-diagram-3 me-2"></i>Resumen de coincidencias</h5>
      <span class="small text-muted" id="summaryRange"></span>
    </div>
    <div class="card-body">
      <div class="row g-3 text-center">
        <div class="col-6 col-xl-2">
          <div class="border rounded p-3 h-100">
            <div class="text-muted text-uppercase small">Pallets</div>
            <div class="fs-4 fw-semibold" id="sumPallets">-</div>
          </div>
        </div>
        <div class="col-6 col-xl-2">
          <div class="border rounded p-3 h-100">
            <div class="text-muted text-uppercase small">Items</div>
            <div class="fs-4 fw-semibold" id="sumItems">-</div>
          </div>
        </div>
        <div class="col-6 col-xl-2">
          <div class="border rounded p-3 h-100">
            <div class="text-muted text-uppercase small">Movimientos</div>
            <div class="fs-4 fw-semibold" id="sumMovimientos">-</div>
          </div>
        </div>
        <div class="col-6 col-xl-3">
          <div class="border rounded p-3 h-100">
            <div class="text-muted text-uppercase small">Stock estimado</div>
            <div class="fs-5 fw-semibold" id="sumStockUc">-</div>
            <div class="small text-muted" id="sumStockUv">&nbsp;</div>
          </div>
        </div>
        <div class="col-6 col-xl-3">
          <div class="border rounded p-3 h-100">
            <div class="text-muted text-uppercase small">Ventana de movimientos</div>
            <div class="fs-6 fw-semibold" id="sumFirstMove">-</div>
            <div class="small text-muted" id="sumLastMove">&nbsp;</div>
          </div>
        </div>
      </div>
      <!-- <div class="row g-3 mt-3" id="matchChips" style="display:none;">
        <div class="col-12">
          <div class="d-flex flex-wrap gap-2" id="chipsContainer"></div>
        </div>
      </div> -->
    </div>
  </div>

  <div class="row g-4">
    <div class="col-12">
      <div class="card h-100">
        <div class="card-header d-flex justify-content-between align-items-center">
          <h5 class="card-title mb-0"><i class="bi bi-box-seam me-2"></i>Pallets encontrados</h5>
          <span class="badge bg-primary" id="badgePallets">0</span>
        </div>
        <div class="card-body">
          <div class="table-responsive">
            <table id="tblTrazabilidadPallets" class="table table-striped table-hover align-middle" style="width:100%">
              <thead>
                <tr>
                  <th>Pallet</th>
                  <th>Productos / Lotes</th>
                  <th>Stock</th>
                  <th>Ubicación actual</th>
                  <th>Coincidencias</th>
                </tr>
              </thead>
              <tbody></tbody>
            </table>
          </div>
        </div>
      </div>
    </div>
    <div class="col-12">
      <div class="card h-100">
        <div class="card-header d-flex justify-content-between align-items-center">
          <h5 class="card-title mb-0"><i class="bi bi-clock-history me-2"></i>Movimientos de los pallets</h5>
          <span class="badge bg-info text-dark" id="badgeMovimientos">0</span>
        </div>
        <div class="card-body">
          <div class="table-responsive">
            <table id="tblTrazabilidadMovimientos" class="table table-striped table-hover align-middle" style="width:100%">
              <thead>
                <tr>
                  <th>Fecha</th>
                  <th>Pallet</th>
                  <th>Movimiento</th>
                  <th>Origen</th>
                  <th>Destino</th>
                  <th>Detalle</th>
                  <th>Referencia</th>
                  <th>Responsables</th>
                </tr>
              </thead>
              <tbody></tbody>
            </table>
          </div>
        </div>
      </div>
    </div>
  </div>

  <div class="alert alert-warning d-flex align-items-center gap-2 mt-4" id="alertSinResultados" style="display:none;">
    <i class="bi bi-exclamation-triangle"></i>
    <div>No se encontraron pallets ni movimientos para los filtros aplicados.</div>
  </div>

</div>
<?php
$content = ob_get_clean();
include project_path('views/layout/layout_app.php');
