<?php

declare(strict_types=1);

/**
 * SOL - Sistema de Operaciones Logísticas
 * Vista placeholder: Reporte de Utilización de Montacargas (en desarrollo)
 */

$BASE = dirname(__DIR__, 3);
require_once $BASE . '/app/Support/ViewHelpers.php';

sol_section('page_title', 'Reportes · Utilización de montacargas');
sol_section('breadcrumb', [
    ['label' => 'Inicio', 'url' => '/home'],
    ['label' => 'Reportes', 'url' => '/reportes'],
    ['label' => 'Utilización de montacargas', 'url' => null],
]);

ob_start();
?>
<div class="container py-5">
  <div class="row justify-content-center">
    <div class="col-lg-7">
      <div class="card shadow-sm border-warning-subtle">
        <div class="card-header bg-warning text-dark">
          <h5 class="mb-0"><i class="bi bi-cone-striped me-2"></i>En desarrollo</h5>
        </div>
        <div class="card-body">
          <p class="lead mb-3">Estamos preparando el reporte de utilización de montacargas.</p>
          <p class="mb-3">Pronto vas a poder ver métricas de disponibilidad, horas activas y rendimiento de cada equipo.</p>
          <ul class="mb-3">
            <li>Resumen ejecutivo con KPIs clave.</li>
            <li>Histórico de utilización por turno y operador.</li>
            <li>Integración con planes de mantenimiento preventivo.</li>
          </ul>
          <p class="mb-0">Si necesitás priorizar este desarrollo o sumar requerimientos específicos, avisános.</p>
        </div>
      </div>
    </div>
  </div>
</div>
<?php
$content = ob_get_clean();
include project_path('views/layout/layout_app.php');
