<?php
declare(strict_types=1);

/**
 * SOL - Sistema de Operaciones Logísticas
 * Vista: views/rotacion/minmax/index.php
 * Reporte: Productos con mayor y menor movimiento (IN/OUT, neto)
 *
 * - Filtros: fecha desde/hasta, cliente, operativa, búsqueda por SKU/denominación
 * - Contenido: agregación por producto (mov_in, mov_out, mov_net, mov_ops)
 * - Extras: botones rápidos Top ±20, export PDF
 */

$BASE = dirname(__DIR__, 3);
require_once $BASE . '/app/Support/ViewHelpers.php';
require_once $BASE . '/app/Support/Assets.php';

sol_section('page_title', 'Rotación · Productos con mayor y menor movimiento');
sol_dt_assets('/page-scripts/pages/rotacion/minmax.js');

// Tabla
$tableId          = 'rotacionMinMaxTable';
$tableDescription = 'Suma de movimientos por producto (IN/OUT y neto) en el rango seleccionado';

ob_start();
?>

<!-- Toolbar -->
<div class="d-flex flex-wrap gap-2 mb-3">
  <a id="btnPdfRotacion" class="btn btn-primary btn-sm" target="_blank"
     href="<?= url('/api/rotacion/minmax_pdf.php') ?>">
    <i class="bi bi-filetype-pdf me-1"></i> Imprimir / Descargar PDF
  </a>

  <div class="vr mx-1"></div>

  <button type="button" class="btn btn-outline-success btn-sm" id="btnTopPos">Top +20</button>
  <button type="button" class="btn btn-outline-danger btn-sm" id="btnTopNeg">Top −20</button>
  <button type="button" class="btn btn-outline-secondary btn-sm" id="btnTodos">Todos</button>
</div>

<!-- Filtros -->
<div class="card mb-3">
  <div class="card-body">
    <form id="frmRotacion" class="row g-2">
      <div class="col-12 col-md-3">
        <label class="form-label">Desde</label>
        <input type="date" class="form-control" id="fDesde" name="desde">
      </div>
      <div class="col-12 col-md-3">
        <label class="form-label">Hasta</label>
        <input type="date" class="form-control" id="fHasta" name="hasta">
      </div>

      <div class="col-12 col-md-3">
        <label class="form-label">Cliente</label>
        <select class="form-select" id="fCliente" name="cliente_id">
          <option value="">(Todos)</option>
        </select>
      </div>
      <div class="col-12 col-md-3">
        <label class="form-label">Operativa</label>
        <select class="form-select" id="fOperativa" name="operativa_id">
          <option value="">(Todas)</option>
        </select>
      </div>

      <div class="col-12 col-md-4">
        <label class="form-label">Producto (SKU o denominación)</label>
        <input type="text" class="form-control" id="fQ" name="q" placeholder="Buscar…">
      </div>
      <div class="col-12 col-md-4">
        <label class="form-label">Sentido</label>
        <select class="form-select" id="fSentido" name="sentido">
          <option value="todos">Todos</option>
          <option value="mayor">Mayor movimiento (neto +)</option>
          <option value="menor">Menor movimiento (neto −)</option>
        </select>
      </div>
      <div class="col-12 col-md-2">
        <label class="form-label">Top</label>
        <input type="number" min="1" class="form-control" id="fTop" name="top" placeholder="20">
      </div>
      <div class="col-12 col-md-2">
        <label class="form-label">Mín. operaciones</label>
        <input type="number" min="0" class="form-control" id="fMinOps" name="min_ops" value="0">
      </div>

      <div class="col-12 col-md-3 d-flex align-items-end">
        <button type="submit" class="btn btn-primary w-100">Aplicar filtros</button>
      </div>
    </form>
  </div>
</div>

<?php
// Tabla reutilizando el partial con tfoot:
include project_path('views/layout/_partials/table-def.php');
$content = ob_get_clean();

include project_path('views/layout/layout_app.php');
