<?php
declare(strict_types=1);

/**
 * SOL - Sistema de Operaciones Logísticas
 * Vista: views/rotacion/permanencia/index.php
 * Reporte: Tiempo promedio de permanencia en almacén (por producto)
 *
 * - Filtros: fecha desde/hasta, cliente, operativa, búsqueda por SKU/denominación
 * - Opción: incluir ciclos abiertos (sin OUTBOUND) computando hasta hoy
 * - Tabla: items cerrados, promedio/min/máx de días
 */

$BASE = dirname(__DIR__, 3);
require_once $BASE . '/app/Support/ViewHelpers.php';
require_once $BASE . '/app/Support/Assets.php';

sol_section('page_title', 'Rotación · Tiempo promedio de permanencia');
sol_dt_assets('/page-scripts/pages/rotacion/permanencia.js');

$tableId          = 'permanenciaTable';
$tableDescription = 'Promedio de días entre INGRESOS y SALIDAS por producto (ciclos cerrados; opcional abiertos).';

ob_start();
?>

<!-- Toolbar -->
<div class="d-flex flex-wrap gap-2 mb-3">
  <a id="btnPdfPermanencia" class="btn btn-primary btn-sm" target="_blank"
     href="<?= url('/api/rotacion/permanencia_pdf.php') ?>">
    <i class="bi bi-filetype-pdf me-1"></i> Imprimir / Descargar PDF
  </a>
</div>

<!-- Filtros -->
<div class="card mb-3">
  <div class="card-body">
    <form id="frmPermanencia" class="row g-2">
      <div class="col-12 col-md-3">
        <label class="form-label">Desde</label>
        <input type="date" class="form-control" id="fDesde" name="desde">
      </div>
      <div class="col-12 col-md-3">
        <label class="form-label">Hasta</label>
        <input type="date" class="form-control" id="fHasta" name="hasta">
      </div>
      <div class="col-12 col-md-3">
        <label class="form-label">Cliente</label>
        <select class="form-select" id="fCliente" name="cliente_id">
          <option value="">(Todos)</option>
        </select>
      </div>
      <div class="col-12 col-md-3">
        <label class="form-label">Operativa</label>
        <select class="form-select" id="fOperativa" name="operativa_id">
          <option value="">(Todas)</option>
        </select>
      </div>
      <div class="col-12 col-md-4">
        <label class="form-label">Producto (SKU o denominación)</label>
        <input type="text" class="form-control" id="fQ" name="q" placeholder="Buscar…">
      </div>
      <div class="col-12 col-md-4">
        <label class="form-label">Ciclos</label>
        <select class="form-select" id="fAbiertos" name="incluir_abiertos">
          <option value="no" selected>Solo cerrados (con SALIDAS)</option>
          <option value="si">Cerrados + abiertos (hasta hoy)</option>
        </select>
      </div>
      <div class="col-12 col-md-2">
        <label class="form-label">Min. items</label>
        <input type="number" min="1" class="form-control" id="fMinItems" name="min_items" value="1">
      </div>
      <div class="col-12 col-md-2 d-flex align-items-end">
        <button type="submit" class="btn btn-primary w-100">Aplicar filtros</button>
      </div>
    </form>
  </div>
</div>

<?php
include project_path('views/layout/_partials/table-def.php');
$content = ob_get_clean();

include project_path('views/layout/layout_app.php');
