<?php
declare(strict_types=1);

/**
 * SOL - Sistema de Operaciones Logísticas
 * Vista: views/salidas/embarque/detalle/index.php
 * Detalle: edición de un embarque (movil/chofer, tiempos, PREs adjuntos)
 */

$BASE = dirname(__DIR__, 4);
require_once $BASE . '/app/Support/ViewHelpers.php';
require_once $BASE . '/app/Support/Assets.php';

sol_section('page_title', 'Detalle de Embarque');

// Scripts específicos de detalle
sol_dt_assets('/page-scripts/pages/salidas/embarque_detalle_scripts.js');

// Obtener embarque_id desde querystring
$embarqueId = isset($_GET['embarque_id']) ? (int) $_GET['embarque_id'] : 0;

ob_start();
?>
<style>
  #tblDevoluciones .dev-col-factura { min-width: 14rem; }
  #tblDevoluciones td.dev-factura-cell { min-width: 14rem; white-space: nowrap; }
  #tblDevoluciones td.dev-factura-cell .dev-factura-text {
    display: inline-block;
    max-width: 100%;
    overflow: hidden;
    text-overflow: ellipsis;
    vertical-align: middle;
  }
</style>
<div class="container-fluid py-1" id="embRoot" data-emb-id="<?= htmlspecialchars((string) $embarqueId) ?>">
  <div class="row g-3">
    <div class="col-12 col-lg-8">
      <div class="card">
        <div class="card-header d-flex align-items-center justify-content-between">
          <h5 class="mb-0">Cabecera</h5>
          <div class="d-flex align-items-center gap-2">
            <button class="btn btn-sm btn-outline-warning" id="btnRetroEstado" title="Regresar al estado anterior"
              style="display:none;">Estado anterior</button>
            <button class="btn btn-sm btn-success" id="btnMarcarCargado" title="Marcar como CARGADO (embarcado)">Marcar
              CARGADO</button>
            <button class="btn btn-sm btn-primary" id="btnMarcarEnRuta" title="Marcar como EN RUTA"
              style="display:none;">Marcar EN RUTA</button>
            <button class="btn btn-sm btn-danger" id="btnMarcarFinalizado" title="Finalizar embarque"
              style="display:none;">Finalizar</button>
            <button class="btn btn-primary" id="embEstado">-</button>
          </div>
        </div>
        <div class="card-body">
          <div class="row g-3">
            <div class="col-12 col-md-6">
              <label class="form-label">Código</label>
              <input type="text" class="form-control" id="embCodigo" readonly>
            </div>
            <div class="col-12 col-md-6">
              <label class="form-label">Depósito</label>
              <input type="text" class="form-control" id="embDeposito" readonly>
            </div>
            <div class="col-12 col-md-6">
              <label class="form-label">Móvil</label>
              <select id="embMovil" class="form-select"></select>
              <input type="text" id="embMovilRO" class="form-control" readonly style="display:none;" />
            </div>
            <div class="col-12 col-md-6">
              <label class="form-label">Chofer</label>
              <select id="embChofer" class="form-select"></select>
              <input type="text" id="embChoferRO" class="form-control" readonly style="display:none;" />
            </div>
            <div class="col-12 col-md-4">
              <label class="form-label">Llegada</label>
              <div class="input-group">
                <input type="datetime-local" id="embLlegada" class="form-control">
                <button class="btn btn-secondary" type="button" id="btnLlegadaAhora">Ahora</button>
              </div>
            </div>
            <div class="col-12 col-md-4">
              <label class="form-label">Inicio carga</label>
              <div class="input-group">
                <input type="datetime-local" id="embCargaInicio" class="form-control">
                <button class="btn btn-secondary" type="button" id="btnCargaInicioAhora">Ahora</button>
              </div>
            </div>
            <div class="col-12 col-md-4">
              <label class="form-label">Fin carga</label>
              <div class="input-group">
                <input type="datetime-local" id="embCargaFin" class="form-control">
                <button class="btn btn-secondary" type="button" id="btnCargaFinAhora">Ahora</button>
              </div>
            </div>
            <div class="col-12 col-md-4">
              <label class="form-label">Salida</label>
              <div class="input-group">
                <input type="datetime-local" id="embSalida" class="form-control">
                <button class="btn btn-secondary" type="button" id="btnSalidaAhora">Ahora</button>
              </div>
            </div>
            <div class="col-12 col-md-4">
              <label class="form-label">Ticket Portería</label>
              <input type="text" id="embTicketPorteria" class="form-control">
            </div>
            <div class="col-12 col-md-4">
              <label class="form-label">Ticket Báscula</label>
              <input type="text" id="embTicketBascula" class="form-control">
            </div>
            <div class="col-12 col-md-4">
              <label class="form-label">Temp. salida (°C)</label>
              <input type="number" step="0.1" id="embTempSalida" class="form-control">
            </div>
            <div class="col-12 col-md-4">
              <label class="form-label">Ayudantes</label>
              <input type="number" id="embAyudantes" class="form-control">
            </div>
            <div class="col-12 col-md-4">
              <label class="form-label">Km inicial</label>
              <input type="number" id="embKmInicial" class="form-control">
            </div>
            <div class="col-12">
              <label class="form-label">Observación</label>
              <textarea id="embObs" class="form-control" rows="2"></textarea>
            </div>
          </div>
        </div>
        <div class="card-footer d-flex gap-2">
          <button class="btn btn-primary" id="btnGuardarEmb">Guardar</button>
          <button class="btn btn-outline-secondary" id="btnVolverEmb">Volver</button>
        </div>
      </div>
    </div>
    <div class="col-12 col-lg-4">


      <!-- Card: PRE asociado (visible cuando hay un PRE vinculado) -->
      <div class="card mb-3" id="cardPreAsociado" style="display:none;">
        <div class="card-header d-flex align-items-center justify-content-between">
          <h5 class="mb-0">Pre-embarque asociado</h5>
          <div class="btn-group">
            <a id="preDocLink" href="#" target="_blank" class="btn btn-sm btn-primary">Planilla de Salida</a>
            <button class="btn btn-sm btn-danger" id="btnQuitarPreSingle">Quitar</button>
          </div>
        </div>
        <div class="card-body">
          <div class="mb-2"><strong>PRE:</strong> <span id="preCode">-</span></div>
          <div class="mb-2"><strong>Pedido:</strong> <span id="prePedido">-</span></div>
          <div class="mb-2"><strong>Estado:</strong> <span id="preEstado">-</span></div>
        </div>
      </div>

      <!-- Card: listado/adjuntar (visible solo si NO hay PRE asociado) -->
      <div class="card h-100" id="cardPreLista">
        <div class="card-header d-flex align-items-center justify-content-between">
          <h5 class="mb-0">Pre-embarques</h5>
          <div class="btn-group">
            <button class="btn btn-sm btn-success" id="btnAdjuntarPre">Adjuntar PRE</button>
            <button class="btn btn-sm btn-danger" id="btnQuitarPre">Quitar</button>
          </div>
        </div>
        <div class="card-body">
          <table class="table table-sm" id="tblEmbPres">
            <thead>
              <tr>
                <th>PRE</th>
                <th>Pedido</th>
                <th>Estado</th>
              </tr>
            </thead>
            <tbody></tbody>
          </table>
        </div>
      </div>
    </div>
  </div>
</div>
<div class="container-fluid py-1 mt-3">
  <style>
    /* Ajustes de la tabla de seguimiento para minimizar saltos de línea */
    #tblSeguimientoDest th,
    #tblSeguimientoDest td {
      white-space: nowrap;
    }

    #tblSeguimientoDest input.form-control {
      padding: .15rem .35rem;
      height: calc(1.25em + .5rem + 2px);
      font-size: .86rem;
    }

    #tblSeguimientoDest .w-time {
      width: 84px;
    }

    #tblSeguimientoDest .w-km {
      width: 90px;
    }

    #tblSeguimientoDest .w-temp {
      width: 90px;
    }

    #tblSeguimientoDest .seg-now {
      margin-left: 4px;
      padding: .125rem .35rem;
      line-height: 1;
    }
  </style>
  <div class="card" id="cardSeguimientoDestWrap" style="display:none;">
    <div class="card-header d-flex align-items-center justify-content-between">
      <h5 class="mb-0">Seguimiento por Destinatario</h5>
        <span class="ms-3">
          <button class="btn btn-dark me-1">Filas: <span id="segTotGeneral">0</span></button>
          <button class="btn btn-warning text-dark me-1">Espera: <span id="segTotEspera">00:00</span></button>
          <button class="btn btn-primary">Total: <span id="segTotTiempo">00:00</span></button>
        </span>     
      <div>
        <!-- Si DataTables Buttons está disponible, estos serán reemplazados/ocultados por la integración -->
        <?php $segPdfUrl = url('/api/operaciones/so_embarque_seguimiento_pdf.php?embarque_id=' . (int) $embarqueId); ?>
        <a class="btn btn-sm btn-primary me-2" id="btnSegPdf" href="<?= htmlspecialchars($segPdfUrl) ?>"
          target="_blank">PDF Seguimiento</a>
        <button class="btn btn-sm btn-outline-primary" id="btnSegExport" type="button">Exportar</button>
      </div>
    </div>
    <div class="card-body">
      <div class="table-responsive">
        <table class="table table-sm table-bordered" id="tblSeguimientoDest">
          <thead class="table-light">
            <tr>
              <th>No. Factura</th>
              <th>Cliente Final</th>
              <th>Inicio Carga</th>
              <th>Fin Carga</th>
              <th>Km Inicial</th>
              <th>Km Llegada</th>
              <th>Hr Llegada</th>
              <th>Hr Inicio</th>
              <th>Espera para Descargar</th>
              <th>Hr. Termino</th>
              <th>Tiempo de Descarga</th>
              <th>Hr. Salida</th>
              <th>Tiempo de Control</th>
              <th>Tiempo TOTAL</th>
              <th>Tipo de Carga</th>
              <th>Salida de Cámara</th>
              <th>Carga de camión temp. C°</th>
              <th>Descarga temp. C°</th>
              <th>Aviso a Quien</th>
              <th>Hora</th>
              <th>Problema</th>
            </tr>
          </thead>
          <tbody></tbody>
        </table>
      </div>
    </div>
  </div>
</div>
<div class="container-fluid py-1 mt-3">
  <!-- Card: Devoluciones -->
  <div class="card mb-3" id="cardDevoluciones" style="display:none;">
    <div class="card-header d-flex align-items-center justify-content-between">
      <h5 class="mb-0">Devoluciones</h5>
      <button class="btn btn-sm btn-outline-success" type="button" id="btnDevAddRow">Agregar línea</button>
    </div>
    <div class="card-body">
      <div id="devEmpty" class="text-muted small mb-2" style="display:none;">No hay devoluciones registradas.</div>
      <div id="devFacturasWrap" class="mb-3" style="display:none;">
        <div class="small text-muted fw-semibold mb-1">Facturas del embarque</div>
        <div id="devFacturasList" class="d-flex flex-wrap gap-2"></div>
      </div>
      <div class="table-responsive">
        <table class="table table-sm align-middle" id="tblDevoluciones">
          <thead class="table-light">
            <tr>
              <th class="dev-col-factura">Factura</th>
              <th>SKU</th>
              <th>Pallets</th>
              <th>Cajas sueltas</th>
              <th>Unidades sueltas</th>
              <th>Unidades dañadas</th>
              <th>Total unidades</th>
              <th>Unidades a picking</th>
              <th>Motivo</th>
              <th>Lote</th>
              <th class="text-center">Acciones</th>
            </tr>
          </thead>
          <tbody></tbody>
          <tfoot class="table-light">
            <tr>
              <th colspan="6" class="text-end">Totales</th>
              <th id="devTotalUnidades" class="text-end">0</th>
              <th id="devTotalPicking" class="text-end">0</th>
              <th colspan="3"></th>
            </tr>
          </tfoot>
        </table>
      </div>
    </div>
  </div>

  <!-- Card: Rendiciones -->
  <div class="card mb-3" id="cardRendiciones" style="display:none;">
    <div class="card-header d-flex align-items-center justify-content-between">
      <h5 class="mb-0">Rendiciones</h5>
      <button class="btn btn-sm btn-outline-success" type="button" id="btnRendAddRow">Agregar línea</button>
    </div>
    <div class="card-body">
      <div id="rendEmpty" class="text-muted small mb-2" style="display:none;">No hay rendiciones registradas.</div>
      <div id="rendFacturasWrap" class="mb-3" style="display:none;">
        <div class="small text-muted fw-semibold mb-1">Facturas del embarque</div>
        <div id="rendFacturasList" class="d-flex flex-wrap gap-2"></div>
      </div>
      <div class="table-responsive">
        <table class="table table-sm align-middle" id="tblRendiciones">
          <thead class="table-light">
            <tr>
              <th>Factura</th>
              <th>Condición</th>
              <th>Fecha factura</th>
              <th>Monto</th>
              <th>Fecha rendición</th>
              <th class="text-center">Acciones</th>
            </tr>
          </thead>
          <tbody></tbody>
        </table>
      </div>
    </div>
  </div>

  <!-- Card: VUELTA (cierre de embarque) -->
  <div class="card mb-3" id="cardVuelta">
    <div class="card-header d-flex align-items-center justify-content-between">
      <h5 class="mb-0">Vuelta</h5>
      <button class="btn btn-sm btn-danger" id="btnRegistrarVuelta"
        title="Registrar vuelta y cerrar embarque">VUELTA</button>
    </div>
    <div class="card-body">
      <div id="vueltaInfo" class="mb-2" style="display:none;">
        <div class="alert alert-info p-2 mb-2">
          <div><strong>Última vuelta:</strong> <span id="vueltaInfoHora">-</span></div>
          <div><strong>Detalle:</strong> <span id="vueltaInfoObs">-</span></div>
        </div>
      </div>
      <div class="mb-2">
        <label class="form-label">Hora de vuelta</label>
        <div class="input-group">
          <input type="datetime-local" id="vueltaHora" class="form-control">
          <button class="btn btn-secondary" type="button" id="btnVueltaAhora">Ahora</button>
        </div>
      </div>
      <div class="row g-2">
        <div class="col-5">
          <label class="form-label">Doc. vuelta</label>
          <select id="vueltaDocTipo" class="form-select">
            <option value="">--</option>
            <option value="REMITO">Remito</option>
            <option value="FACTURA">Factura</option>
            <option value="OTRO">Otro</option>
          </select>
        </div>
        <div class="col-7">
          <label class="form-label">Número</label>
          <input type="text" id="vueltaDocNro" class="form-control" placeholder="Ej. 0001-00012345">
        </div>
      </div>
      <div class="mt-2">
        <label class="form-label">Observaciones</label>
        <textarea id="vueltaRendicion" class="form-control" rows="2" placeholder="Notas sobre la vuelta"></textarea>
      </div>
      <div class="form-text mt-2">Se registrará el usuario que confirma la VUELTA y se cerrará el embarque.</div>
    </div>
  </div>

</div>
<datalist id="embarqueFacturasDatalist"></datalist>
<?php
$content = ob_get_clean();
include project_path('views/layout/layout_app.php');
