<?php
declare(strict_types=1);

/**
 * SOL - Sistema de Operaciones Logísticas
 * Vista: views/salidas/embarque/index.php
 * Listado y gestión básica de embarques
 */

$BASE = dirname(__DIR__, 3);
require_once $BASE . '/app/Support/ViewHelpers.php';
require_once $BASE . '/app/Support/Assets.php';

sol_section('page_title', 'Embarques');

sol_dt_assets('/page-scripts/pages/salidas/embarque_list_scripts.js');


$tableId = 'embarquesTable';
$tableDescription = 'Embarques recientes';

$showTable = true;
$soIdParam = isset($_GET['so_id']) ? (int)$_GET['so_id'] : 0;
if ($soIdParam > 0) {
		$showTable = false;
}

if ($showTable) {
		ob_start();
		include project_path('views/layout/_partials/table-def.php');
		$content = ob_get_clean();
} else {
		ob_start();
		?>
		<div class="container-fluid py-3">
			<div class="alert alert-info d-flex justify-content-between align-items-center" role="alert">
				<div>
					<strong>Pedido seleccionado:</strong> SO-<?= htmlspecialchars((string)$soIdParam, ENT_QUOTES, 'UTF-8') ?>. Podés crear un embarque para este pedido.
				</div>
				<div class="d-flex gap-2">
					<button id="btnCreateEmbFromSO" class="btn btn-sm btn-primary">Crear embarque ahora</button>
					<button id="btnDismissEmbBanner" class="btn btn-sm btn-outline-secondary">Ocultar</button>
				</div>
			</div>
		</div>
			<script>
			document.addEventListener('DOMContentLoaded', function(){
				const soId = <?= (int)$soIdParam ?>;
				const BASE = (typeof window !== 'undefined' && window.BASE_URL) ? window.BASE_URL : '/';
				const joinUrl = function(p){ return (BASE.endsWith('/') ? BASE : BASE + '/') + p.replace(/^\/+/,''); };
				const btnCreate = document.getElementById('btnCreateEmbFromSO');
				const btnDismiss = document.getElementById('btnDismissEmbBanner');

				if (btnDismiss){
					btnDismiss.addEventListener('click', function(){ window.location.href = joinUrl('salidas/embarque'); });
				}

				if (!btnCreate) return;

				btnCreate.addEventListener('click', function(){
					const btn = this;
					if (btn.disabled) return;
					const originalText = btn.textContent;
					btn.disabled = true;
					btn.textContent = 'Creando...';

							const createEmbarque = function(payload){
								return fetch(joinUrl('api/operaciones/so_embarque_create.php'), {
									method: 'POST',
									headers: { 'Content-Type': 'application/json; charset=utf-8' },
									body: JSON.stringify(payload || {})
								}).then(function(resp){
									return resp.json().catch(function(){ return { ok: false, error: 'Respuesta inválida del servidor' }; });
								}).catch(function(){
									return { ok: false, error: 'Error de red' };
								});
					};

					fetch(joinUrl('api/operaciones/so_pre_doc.php') + '?so_id=' + soId)
						.then(function(resp){ return resp.json(); })
						.then(function(data){
							const preId = (data && data.ok && data.pre && data.pre.id) ? data.pre.id : 0;
							return createEmbarque(preId ? { pre_id: preId } : {});
									})
									.catch(function(){
										return createEmbarque({});
									})
						.then(function(res){
							if (res && res.ok && res.embarque_id){
								window.location.href = joinUrl('salidas/embarque/detalle') + '?embarque_id=' + res.embarque_id;
							} else {
								const msg = (res && (res.error || res.message)) ? res.error || res.message : 'Error desconocido';
								alert('No se pudo crear el embarque: ' + msg);
							}
						})
						.finally(function(){
							btn.disabled = false;
							btn.textContent = originalText;
						});
				});
			});
			</script>
		<?php
		$content = ob_get_clean();
}

include project_path('views/layout/layout_app.php');
