<?php
declare(strict_types=1);

$BASE = dirname(__DIR__, 4);
require_once $BASE . '/app/Support/ViewHelpers.php';
require_once $BASE . '/app/Support/Assets.php';

$embarqueId = isset($_GET['embarque_id']) ? (int)$_GET['embarque_id'] : 0;
if ($embarqueId <= 0) { http_response_code(400); echo 'Falta embarque_id'; exit; }

sol_section('page_title', 'Planilla de Salida');

ob_start();
?>
<style>
  /* A4 horizontal and print-friendly */
  @page { size: A4 landscape; margin: 12mm; }
  @media print {
    .no-print { display: none !important; }
    .page-break { page-break-after: always; }
    table { page-break-inside: auto; }
    tr { page-break-inside: avoid; page-break-after: auto; }
    thead { display: table-header-group; }
    tfoot { display: table-footer-group; }
  }
  .planilla-header { border-bottom: 2px solid #000; padding-bottom: 6px; margin-bottom: 10px; }
  .planilla-title { font-weight: 700; font-size: 18px; }
  .meta { font-size: 12px; }
  .meta .label { color: #555; }
  .slot-header { display: flex; justify-content: space-between; align-items: center; margin: 6px 0; font-size: 12px; }
  .slot-header .hora-placeholder { border-bottom: 1px dashed #000; padding: 0 40px; margin-left: 8px; }
  .table-plan { width: 100%; border-collapse: collapse; font-size: 12px; }
  .table-plan th, .table-plan td { border: 1px solid #000; padding: 4px 6px; }
  .table-plan th { background: #f0f0f0; }
  .signatures { display: flex; justify-content: space-between; gap: 24px; margin-top: 12px; font-size: 12px; }
  .signatures .sig { flex: 1; text-align: center; }
  .signatures .sig .line { border-top: 1px solid #000; margin-top: 36px; }
</style>

<div class="container-fluid py-3" id="planillaRoot" data-emb-id="<?= $embarqueId ?>">
  <div class="no-print d-flex align-items-center gap-2 mb-3">
    <a class="btn btn-outline-secondary btn-sm" href="<?= url('/salidas/embarque') ?>">← Volver</a>
    <button type="button" onclick="window.print()" class="btn btn-primary btn-sm">Imprimir</button>
  </div>

  <div id="sheetContainer">
    <!-- Sheets (pages) will be rendered here by JS -->
  </div>
</div>

<script>
(function(){
  const root = document.getElementById('planillaRoot');
  if (!root) return;
  const embId = parseInt(root.getAttribute('data-emb-id'), 10);
  const joinUrl = (p) => (window.BASE_URL && window.BASE_URL.endsWith('/') ? window.BASE_URL : (window.BASE_URL||'/')) + p.replace(/^\/+/, '');

  const fmt = {
    dt(d){ if (!d) return ''; try { const t = new Date(d); if (isNaN(t)) return d; return t.toISOString().slice(0,16).replace('T',' ');} catch(e){ return d; }},
    int(n){ const v = parseInt(n||0,10); return isNaN(v) ? '0' : String(v); }
  };

  // Fetch helpers (single record lookups for labels)
  function fetchMovilName(id){
    if (!id) return Promise.resolve('');
    return fetch(joinUrl('api/parametros/moviles_select.php?id='+encodeURIComponent(id)))
      .then(r=>r.json()).then(j=> (j && j.data && j.data[0] && (j.data[0].chapa||('Movil #'+id))) || '')
      .catch(()=> '');
  }
  function fetchChoferName(id){
    if (!id) return Promise.resolve('');
    return fetch(joinUrl('api/parametros/choferes.php?id='+encodeURIComponent(id)))
      .then(r=>r.json()).then(j=> (j && j.data && j.data[0] && (j.data[0].nombre||('Chofer #'+id))) || '')
      .catch(()=> '');
  }

  function fetchEmb(){
    return fetch(joinUrl('api/operaciones/so_embarque_get.php?embarque_id='+embId)).then(r=>r.json());
  }
  function fetchPreDoc(preId){
    return fetch(joinUrl('api/operaciones/so_pre_doc_data.php?pre_id='+preId)).then(r=>r.json());
  }

  function splitPages(rows, pageSize){
    const pages=[]; for (let i=0;i<rows.length;i+=pageSize){ pages.push(rows.slice(i,i+pageSize)); } return pages;
  }

  function renderPage(container, meta, rows, pageNum, pageCount){
    const sheet = document.createElement('div');
    sheet.className = 'sheet';
    sheet.innerHTML = `
      <div class="planilla-header">
        <div class="d-flex justify-content-between align-items-end">
          <div>
            <div class="planilla-title">Planilla de Salida</div>
            <div class="meta">
              <span class="label">Embarque:</span> <strong>${meta.codigo||'-'}</strong>
              &nbsp;|&nbsp; <span class="label">Depósito:</span> <strong>${meta.deposito||'-'}</strong>
              &nbsp;|&nbsp; <span class="label">Estado:</span> <strong>${meta.estado||'-'}</strong>
            </div>
            <div class="meta">
              <span class="label">Móvil:</span> <strong>${meta.movil||'-'}</strong>
              &nbsp;|&nbsp; <span class="label">Chofer:</span> <strong>${meta.chofer||'-'}</strong>
            </div>
            <div class="meta">
              <span class="label">Llegada:</span> ${fmt.dt(meta.llegada_at)}
              &nbsp;|&nbsp; <span class="label">Inicio carga:</span> ${fmt.dt(meta.carga_inicio_at)}
              &nbsp;|&nbsp; <span class="label">Fin carga:</span> ${fmt.dt(meta.carga_fin_at)}
              &nbsp;|&nbsp; <span class="label">Salida:</span> ${fmt.dt(meta.salida_at)}
            </div>
          </div>
          <div class="text-end meta">
            <div><span class="label">Fecha impresión:</span> <?= date('Y-m-d H:i') ?></div>
            <div>Pág. ${pageNum} / ${pageCount}</div>
            <div><span class="label">Hora:</span> <span class="hora-placeholder">&nbsp;</span></div>
          </div>
        </div>
      </div>
      <div class="slot-header">
        <div><strong>Turno/Hora:</strong> ___________________________</div>
        <div><strong>Ticket Portería:</strong> ${meta.ticket_porteria||''} &nbsp; | &nbsp; <strong>Ticket Báscula:</strong> ${meta.ticket_bascula||''}</div>
      </div>
      <div class="table-responsive">
        <table class="table-plan">
          <thead>
            <tr>
              <th style="width:40px">#</th>
              <th>Destinatario</th>
              <th>Producto</th>
              <th style="width:120px">Lote</th>
              <th style="width:90px">Vto</th>
              <th style="width:90px">Pallet</th>
              <th style="width:70px" class="text-end">UV</th>
              <th style="width:70px" class="text-end">UC</th>
              <th style="width:120px">Desde</th>
              <th style="width:120px">→ PREP</th>
            </tr>
          </thead>
          <tbody>
            ${rows.map((r,idx)=>`
              <tr>
                <td>${idx+1}</td>
                <td>${r.destinatario||''}</td>
                <td>${r.producto||''}</td>
                <td>${r.lote||''}</td>
                <td>${r.vto||''}</td>
                <td>${r.pallet_id||''}</td>
                <td class="text-end">${fmt.int(r.uv_cajas)}</td>
                <td class="text-end">${fmt.int(r.uc_unidades)}</td>
                <td>${r.from_pos||''}</td>
                <td>${r.to_pos||''}</td>
              </tr>
            `).join('')}
          </tbody>
        </table>
      </div>
      <div class="signatures">
        <div class="sig"><div class="line"></div><div>Montacarguista</div></div>
        <div class="sig"><div class="line"></div><div>Supervisor</div></div>
        <div class="sig"><div class="line"></div><div>Chofer</div></div>
      </div>
    `;
    container.appendChild(sheet);
    const sep = document.createElement('div'); sep.className = 'page-break'; container.appendChild(sep);
  }

  function aggregateRows(preDocs){
    // For now, just concatenate preserving order by FEFO already provided by each pre
    const rows = [];
    preDocs.forEach(doc => { (doc.data||[]).forEach(r => rows.push(r)); });
    return rows;
  }

  Promise.all([
    fetchEmb()
  ]).then(async ([emb]) => {
    if (!emb || emb.ok !== true) throw new Error('No se pudo cargar el embarque');
    const e = emb.embarque || {};
    const preList = emb.preembarques || [];
    const [movilName, choferName] = await Promise.all([ fetchMovilName(e.movil_id), fetchChoferName(e.chofer_id) ]);

    // Fetch pre docs for all PREs asociados (si muchos, juntamos)
    const preDocs = await Promise.all((preList||[]).map(p => fetchPreDoc(p.id)));

    const allRows = aggregateRows(preDocs);
    // Basic pagination: 25 rows per page
    const pageSize = 25;
    const pages = splitPages(allRows, pageSize);
    const pageCount = Math.max(1, pages.length);

    const meta = {
      codigo: e.codigo || '',
      deposito: e.deposito || '',
      estado: e.estado || '',
      movil: movilName, chofer: choferName,
      llegada_at: e.llegada_at, carga_inicio_at: e.carga_inicio_at, carga_fin_at: e.carga_fin_at, salida_at: e.salida_at,
      ticket_porteria: e.ticket_porteria, ticket_bascula: e.ticket_bascula
    };

    const container = document.getElementById('sheetContainer');
    container.innerHTML = '';

    if (pageCount === 0) {
      // No rows: still render a blank page with header
      renderPage(container, meta, [], 1, 1);
    } else {
      pages.forEach((rows, i) => renderPage(container, meta, rows, i+1, pageCount));
    }
  }).catch(err => {
    const c = document.getElementById('sheetContainer');
    c.innerHTML = `<div class="alert alert-danger">No se pudo generar la planilla: ${err && err.message ? err.message : 'Error'}</div>`;
  });
})();
</script>
<?php
$content = ob_get_clean();
include project_path('views/layout/layout_app.php');
