<?php
declare(strict_types=1);

/**
 * SOL - Sistema de Operaciones Logísticas
 * Vista: views/salidas/listado/index.php
 * Muestra DataTables para "Salidas" (pedidos confirmados) y permite abrir detalle.
 */

$BASE = dirname(__DIR__, 3); // listado -> salidas -> views -> raíz
require_once $BASE . '/app/Support/ViewHelpers.php';
require_once $BASE . '/app/Support/Assets.php';

// -------------------------
// Meta
// -------------------------
sol_section('page_title', 'Pedidos');

// -------------------------
// DataTables + script de la página
// -------------------------
sol_dt_assets('/page-scripts/pages/salidas/salidas_scripts.js');

// -------------------------
// Variables para el partial de tabla
// -------------------------
$tableId          = 'salidasTable';
$tableDescription = 'Pedidos (confirmados y en preparación)';

// -------------------------
// Contenido principal
// -------------------------
ob_start();
include project_path('views/layout/_partials/table-def.php'); // tabla genérica de tu layout
$content = ob_get_clean();

// -------------------------
// Render del layout
// -------------------------
include project_path('views/layout/layout_app.php');
