<?php

declare(strict_types=1);

/**
 * SOL - Sistema de Operaciones Logísticas
 * Vista: views/salidas/packing/index.php
 * Flujo: Subir PL (.xlsx) → Previsualizar → Confirmar → Genera salida + pallets + items.
 */

$BASE = dirname(__DIR__, 3); // packing -> ingresos -> views -> raíz
require_once $BASE . '/app/Support/ViewHelpers.php';
require_once $BASE . '/app/Support/Assets.php';
require_once $BASE . '/config/db.php';

$pdo = get_pdo();

// Combos
$clientes = $pdo->query("SELECT id, ruc, razon_social FROM para_clientes WHERE deleted_at IS NULL ORDER BY ruc")->fetchAll(PDO::FETCH_ASSOC);

// -------------------------
// Meta
// -------------------------
sol_section('page_title', 'Salidas · Packing List (Excel)');

// -------------------------
// Assets de la página (usa tu helper para DataTables + script local)
// -------------------------
sol_dt_assets('/page-scripts/pages/salidas/packing_scripts.js');

// Variables para un partial genérico si lo usas (no obligatorio aquí)
$tableId          = 'tblPL';
$tableDescription = 'Previsualización de filas importadas del Packing List (.xlsx)';

// -------------------------
// Contenido principal
// -------------------------
ob_start();
?>
<div class="container-fluid py-3">

    <div class="d-flex align-items-center gap-2 mb-3">
    <h5 class="m-0"><i class="bi bi-upload me-2"></i>Salida desde Packing List</h5>
        <span class="text-muted">Sube un archivo .xlsx, revisa y confirma.</span>
    </div>

    <!-- Card: Subir archivo -->
    <div class="card mb-3">
        <div class="card-body">
            <form id="frmUploadPL" class="row g-3" method="POST"  enctype="multipart/form-data">
                <input type="hidden" name="prefer_form" value="1">
                <div class="col-md-5">
                    <label class="form-label">Archivo Excel (.xlsx)</label>
                    <input type="file" name="so_file" accept=".xlsx,.xls" class="form-control" required>
                    <a class="btn btn-link btn-sm py-2"
                        href="<?= BASE_URL ?>/assets/storage/models/sol_ingreso_packing_modelo.xlsx"
                        target="_blank">
                        <i class="bi bi-file-earmark-excel me-1"></i>Bajar Ejemplo
                    </a>

                    <div class="form-text">Columnas esperadas: cod, razon_social, nombre_destinatario, direccion, 
                        telefono, sku, uv_cajas, uc_sueltas, numero_doc, tipo_factura, fecha_salida, <strong>pre_embarque</strong> (opcional para agrupar en varios pedidos).</div>
                </div>

                <div class="col-md-5">
                    <label class="form-label">Cliente (ruc)</label>
                    <select id="cliente_id" name="cliente_id" class="form-select">
                        <option value="">-- Seleccionar --</option>
                        <?php foreach ($clientes as $c): ?>
                            <option value="<?= (int)$c['id'] ?>"><?= htmlspecialchars($c['ruc']) . ' - ' . htmlspecialchars($c['razon_social']) ?></option>
                        <?php endforeach; ?>
                    </select>
                    <div class="form-text">Opcional: se asocia al confirmar.</div>
                </div>

                <div class="col-md-2 d-flex align-items-end">
                    <button class="btn btn-primary w-100" type="submit">
                        <i class="bi bi-cloud-arrow-up me-1"></i>Subir
                    </button>
                </div>
            </form>
        </div>
    </div>

    <!-- Card: Acciones de confirmación -->
    <div class="card mb-3">
        <div class="card-body d-flex flex-wrap gap-2 align-items-center">
            <button id="btnConfirmPL" class="btn btn-success" type="button">
                <i class="bi bi-check2-circle me-1"></i>Confirmar pedido desde PL
            </button>
            <span class="text-muted">Solo se podrá confirmar si <strong>no</strong> hay filas con error.</span>
        </div>
    </div>

    <!-- Card: Post confirmación -->
    <div id="plSummaryCardsHost" class="row g-3 mt-3"></div>
    <!-- Card: Previsualización -->
    <div class="card">
        <div class="card-body">
                        <div class="d-flex justify-content-between align-items-center mb-2">
                                <div>
                                        <h6 class="m-0">Previsualización</h6>
                                        <small class="text-muted">Se mostrarán las filas importadas del archivo.</small>
                                </div>
                                <div class="d-flex align-items-center gap-2">
                                    <div id="pl-batch-info" class="small text-muted"></div>
                                    <a id="pl-errors-csv" href="#" class="btn btn-outline-danger btn-sm d-none" download>
                                        <i class="bi bi-filetype-csv me-1"></i>Errores CSV
                                    </a>
                                </div>
                        </div>

            <table id="tblPL" class="table table-striped w-100">
                <thead>
                    <tr>
                        <th>#</th>
                        <th>SKU</th>
                        <th>ProdID</th>
                        <th>Denominación</th>
                        <th>Lote</th>
                        <th>F.Prod</th>
                        <th>F.Vto</th>
                        <th>UV Cajas</th>
                        <th>UC x caja</th>
                        <th>UC sueltas</th>
                        <th>Pallet</th>
                        <th>Posición</th>
                        <th>Error</th>
                    </tr>
                </thead>
            </table>
        </div>
    </div>
    

</div>
<?php
$content = ob_get_clean();

// -------------------------
// Render del layout
// -------------------------
include project_path('views/layout/layout_app.php');
