<?php
declare(strict_types=1);

$BASE = dirname(__DIR__, 3);
require_once $BASE . '/app/Support/ViewHelpers.php';
require_once $BASE . '/app/Support/Assets.php';

$preId = isset($_GET['pre_id']) ? (int)$_GET['pre_id'] : 0;
if ($preId <= 0) { http_response_code(400); echo 'Falta pre_id'; exit; }

sol_section('page_title', "Documento de Picking #{$preId}");

ob_start();
?>
<div class="container-fluid py-3" id="preDoc" data-pre-id="<?= $preId ?>">
  <div class="d-print-none d-flex align-items-center gap-2 mb-3">
    <a class="btn btn-outline-secondary btn-sm" href="<?= url('/salidas/listado') ?>">← Volver</a>
    <button type="button" onclick="window.print()" class="btn btn-primary btn-sm">Imprimir</button>
  </div>

  <div class="card">
    <div class="card-body">
      <div class="d-flex justify-content-between align-items-center mb-3">
        <div>
          <h5 class="m-0">Picking para Montacarguista</h5>
          <div class="text-muted small" id="preInfo"></div>
        </div>
        <div class="text-end">
          <div class="small">Fecha: <?= date('Y-m-d H:i') ?></div>
        </div>
      </div>

      <div class="table-responsive">
        <table class="table table-sm table-striped" id="tblDoc">
          <thead>
            <tr>
              <th>#</th>
              <th>Producto</th>
              <th>Lote</th>
              <th>Vto</th>
              <th>Pallet</th>
              <th>Desde</th>
              <th>→ PREP</th>
              <th class="text-end">UV</th>
              <th class="text-end">UC</th>
            </tr>
          </thead>
          <tbody></tbody>
          <tfoot>
            <tr>
              <th colspan="7" class="text-end">Totales</th>
              <th class="text-end" id="totUv">0</th>
              <th class="text-end" id="totUc">0</th>
            </tr>
          </tfoot>
        </table>
      </div>
    </div>
  </div>
</div>

<script>
document.addEventListener('DOMContentLoaded', function(){
  const root = document.getElementById('preDoc');
  if (!root) return;
  const preId = parseInt(root.getAttribute('data-pre-id'), 10);

  const urlDoc = '<?= url('/api/operaciones/so_pre_doc.php') ?>' + '?pre_id=' + preId;
  fetch(urlDoc)
    .then(r => r.json())
    .then(res => {
      if (!res || res.ok !== true || res.has_preembarque === false || !res.pre) {
        document.getElementById('preInfo').textContent = 'No hay información disponible para este PRE.';
        const tbody = document.querySelector('#tblDoc tbody');
        const tr = document.createElement('tr');
        tr.innerHTML = '<td colspan="9" class="text-muted">Sin datos</td>';
        tbody.appendChild(tr);
        return;
      }

      const info = document.getElementById('preInfo');
      const pedido = res.pedido || {};
      const parts = [];
      if (res.pre.codigo) parts.push('PRE ' + res.pre.codigo);
      if (pedido.codigo) parts.push('Pedido ' + pedido.codigo);
      if (pedido.cliente_nombre || pedido.cliente) parts.push('Cliente ' + (pedido.cliente_nombre || pedido.cliente));
      if (res.pre.deposito) parts.push('Depósito ' + res.pre.deposito);
      info.textContent = parts.join(' · ');

      const tbody = document.querySelector('#tblDoc tbody');
      let i=0, totUv=0, totUc=0;
      const data = Array.isArray(res.data) ? res.data : [];
      if (!data.length) {
        const tr = document.createElement('tr');
        tr.innerHTML = '<td colspan="9" class="text-muted">Sin movimientos registrados.</td>';
        tbody.appendChild(tr);
      } else {
        data.forEach(r => {
          i++;
          const uv = parseInt(r.uv_cajas || 0, 10) || 0;
          const uc = parseInt(r.uc_unidades || 0, 10) || 0;
          totUv += uv;
          totUc += uc;
          const tr = document.createElement('tr');
          tr.innerHTML = `
            <td>${i}</td>
            <td>${r.producto||''}</td>
            <td>${r.lote||''}</td>
            <td>${r.vto||''}</td>
            <td>${r.pallet||r.pallet_id||''}</td>
            <td>${r.from_pos||''}</td>
            <td>${r.to_pos||''}</td>
            <td class="text-end">${uv}</td>
            <td class="text-end">${uc}</td>
          `;
          tbody.appendChild(tr);
        });
      }
      const totals = res.totals || {};
      document.getElementById('totUv').textContent = (totals.uv !== undefined ? totals.uv : totUv);
      document.getElementById('totUc').textContent = (totals.uc !== undefined ? totals.uc : totUc);
    })
    .catch(() => {});
});
</script>
<?php
$content = ob_get_clean();
include project_path('views/layout/layout_app.php');
