<?php
declare(strict_types=1);

$BASE = dirname(__DIR__, 3);
require_once $BASE . '/app/Support/ViewHelpers.php';
require_once $BASE . '/app/Support/Assets.php';
// Auth helper (optional, for admin-only UI)
if (file_exists($BASE . '/app/Support/Auth.php')) require_once $BASE . '/app/Support/Auth.php';

$soId = (int)($_GET['so_id'] ?? 0);
if ($soId <= 0) {
  http_response_code(400);
  echo 'Falta so_id';
  exit;
}

sol_section('page_title', "Preparación de pedido #{$soId}");
sol_dt_assets('/page-scripts/pages/salidas/preparacion_scripts.js');

ob_start();
?>
<?php $isAdmin = function_exists('is_admin') && is_admin(); ?>
<div class="container-fluid py-3" id="soPrep" data-so-id="<?= $soId ?>" data-is-admin="<?= $isAdmin ? '1' : '0' ?>">
  <div class="d-flex align-items-center gap-2 mb-3">
  <a class="btn btn-secondary btn-sm" href="<?= url('/salidas/listado') ?>">← Volver</a>
    <h5 class="m-0 flex-grow-1">Preparación · Pedido #<?= $soId ?> <span id="simulateBadge" class="badge bg-warning text-dark ms-2" style="display:none;">Simulación activa</span></h5>
    <div class="d-flex gap-2">
  <button type="button" id="btnFefoAuto" class="btn btn-sm btn-primary">1) Generar el plan de picking (FEFO)</button>
  <div class="form-check form-check-inline align-self-center">
    <input class="form-check-input" type="checkbox" id="chkUcToUv">
  <label class="form-check-label" for="chkUcToUv" title="Si falta UV (cajas), usar UC para completar cajas usando para_producto_pack.unidades_por_uv">Usar UC→UV</label>
  </div>
  <div class="form-check form-check-inline align-self-center">
    <input class="form-check-input" type="checkbox" id="chkUvToUc">
    <label class="form-check-label" for="chkUvToUc" title="Si falta UC (unidades), abrir UV (cajas) para obtener unidades sueltas">Usar UV→UC</label>
  </div>
  <a id="btnReposPdf" class="btn btn-sm btn-warning text-dark" href="#" target="_blank" rel="noopener" title="Orden de Reposición para montacarguista">2) Orden de Reposición</a>
  <button type="button" id="btnStartRepos" class="btn btn-sm btn-warning text-dark" title="Marcar inicio de la reposición (cambia a estado REPOSICION)">3) Iniciar Reposición</button>
  <button type="button" id="btnMovs" class="btn btn-sm btn-secondary" title="Ver movimientos generados">Movimientos</button>
    <button type="button" id="btnConfirmRepos" class="btn btn-sm btn-warning">4) Confirmar Reposición</button>
  <a id="btnDoc" class="btn btn-sm btn-primary" href="#" target="_blank" rel="noopener" title="Documento de Picking para preparar el pedido"><i class="bi bi-file-earmark-text me-1"></i>Documento de Picking</a>
    <button type="button" id="btnConfirm" class="btn btn-sm btn-success">5) Confirmar preparación</button>
    </div>
  </div>

  <!-- Ajustes avanzados (admin) -->
  <div id="advSettings" class="card mb-3" data-visible="<?= $isAdmin ? '1' : '0' ?>" style="<?= $isAdmin ? '' : 'display:none;' ?>">
    <div class="card-header d-flex align-items-center">
      <strong class="me-auto">Ajustes avanzados</strong>
      <div class="form-check form-switch">
        <input class="form-check-input" type="checkbox" id="adv_enable">
        <label class="form-check-label" for="adv_enable">Usar en este pedido</label>
      </div>
    </div>
    <div class="card-body">
      <div class="row g-3 align-items-end">
        <div class="col-sm-4 col-md-3">
          <div class="form-check mb-2">
            <input class="form-check-input" type="checkbox" id="adv_simulate">
            <label class="form-check-label" for="adv_simulate">Modo simulación (sin movimientos reales)</label>
          </div>
          <small class="text-muted">No crea PRE ni movimientos.</small>
        </div>
        <div class="col-sm-4 col-md-3">
          <div class="form-check">
            <input class="form-check-input" type="checkbox" id="adv_direct">
            <label class="form-check-label" for="adv_direct">Directo a PREP (sin revalidación amplia)</label>
          </div>
          <small class="text-muted">Equivale a ?direct=1</small>
        </div>
        <div class="col-sm-4 col-md-3">
          <label for="adv_cands" class="form-label">Máx. candidatos</label>
          <input type="number" id="adv_cands" class="form-control" min="1" step="1" placeholder="200">
          <small class="text-muted">Equivale a ?cands=200</small>
        </div>
        <div class="col-sm-4 col-md-3">
          <label for="adv_iters" class="form-label">Máx. iteraciones</label>
          <input type="number" id="adv_iters" class="form-control" min="10" step="10" placeholder="1000">
          <small class="text-muted">Equivale a ?iters=1000</small>
        </div>
        <div class="col-md-3 d-flex gap-2">
          <button type="button" id="adv_save" class="btn btn-primary">Guardar preferencias</button>
          <button type="button" id="adv_reset" class="btn btn-outline-secondary">Restablecer</button>
        </div>
      </div>
      <div class="mt-2">
        <small class="text-muted">Estas preferencias se guardan por usuario/navegador y se aplican sólo si "Usar en este pedido" está activo.</small>
      </div>
    </div>
  </div>

  <!-- Resumen del pedido -->
  <div class="card mb-3" id="pedidoResumen">
    <div class="card-body">
      <h6 class="card-title d-flex align-items-center">
        <i class="bi bi-info-circle me-2"></i>Resumen del pedido
        <span id="estadoBadge" class="badge ms-2">Cargando...</span>
      </h6>
      <div class="row g-3">
        <div class="col-md-3">
          <div class="d-flex flex-column">
            <small class="text-muted">Código</small>
            <span id="pedidoCodigo" class="fw-bold">-</span>
          </div>
        </div>
        <div class="col-md-3">
          <div class="d-flex flex-column">
            <small class="text-muted">Cliente</small>
            <span id="pedidoCliente">-</span>
          </div>
        </div>
        <div class="col-md-3">
          <div class="d-flex flex-column">
            <small class="text-muted">Fecha</small>
            <span id="pedidoFecha">-</span>
          </div>
        </div>
        <div class="col-md-3">
          <div class="d-flex flex-column">
            <small class="text-muted">Creado</small>
            <span id="pedidoCreado">-</span>
          </div>
        </div>
      </div>
      
      <hr class="my-3">
      
      <div class="row g-3">
        <div class="col-md-2">
          <div class="text-center">
            <div class="fs-4 fw-bold text-primary" id="totalDestinos">-</div>
            <small class="text-muted">Destinos</small>
          </div>
        </div>
        <div class="col-md-2">
          <div class="text-center">
            <div class="fs-4 fw-bold text-info" id="totalProductos">-</div>
            <small class="text-muted">Productos</small>
          </div>
        </div>
        <div class="col-md-2">
          <div class="text-center">
            <div class="fs-4 fw-bold text-success" id="totalItems">-</div>
            <small class="text-muted">Items</small>
          </div>
        </div>
        <div class="col-md-3">
          <div class="text-center">
            <div class="fs-4 fw-bold text-warning" id="totalCajas">- / -</div>
            <small class="text-muted">Cajas (Prep. / Esp.)</small>
            <div class="progress mt-1" style="height: 6px;">
              <div id="progresoUV" class="progress-bar bg-warning" style="width: 0%"></div>
            </div>
          </div>
        </div>
        <div class="col-md-3">
          <div class="text-center">
            <div class="fs-4 fw-bold text-danger" id="totalSueltas">- / -</div>
            <small class="text-muted">Sueltas (Prep. / Esp.)</small>
            <div class="progress mt-1" style="height: 6px;">
              <div id="progresoUC" class="progress-bar bg-danger" style="width: 0%"></div>
            </div>
          </div>
        </div>
      </div>
    </div>
  </div>

  <div class="card mb-3">
    <div class="card-body">
      <h6 class="card-title mb-3 text-center">Ítems del pedido</h6>
      <div class="table-responsive">
        <table id="tblPrepItems" class="table table-striped w-100">
          <thead></thead>
          <tbody></tbody>
          <tfoot></tfoot>
        </table>
      </div>
    </div>
  </div>

  <!-- Paso 5: Tiempos de preparador -->
  <div class="card mb-3">
    <div class="card-body">
      <h6 class="card-title mb-3">Tiempos de preparador</h6>
      <div class="row g-3 align-items-end">
        <div class="col-sm-4 col-md-3">
          <label class="form-label">Responsable</label>
          <select id="prepRespId" class="form-select">
            <option value="">Seleccione un usuario…</option>
          </select>
        </div>
        <div class="col-sm-4 col-md-3">
          <label class="form-label">Observación</label>
          <input type="text" id="prepObs" class="form-control" placeholder="Notas opcionales">
        </div>
        <div class="col-sm-4 col-md-3">
          <label class="form-label">Foto (opcional)</label>
          <input type="file" id="prepFoto" class="form-control" accept="image/*">
        </div>
        <div class="col-md-3 d-flex gap-2">
          <button type="button" id="btnAsignarPrep" class="btn btn-outline-primary">Asignar</button>
          <button type="button" id="btnInicioPrep" class="btn btn-primary">Iniciar</button>
          <button type="button" id="btnFinPrep" class="btn btn-success">Finalizar</button>
        </div>
      </div>
      <div class="mt-3 small text-muted" id="prepStatus">-</div>
    </div>
  </div>

  <!-- Paso 5b: Tiempos de controlador -->
  <div class="card mb-3">
    <div class="card-body">
      <h6 class="card-title mb-3">Tiempos de controlador</h6>
      <div class="row g-3 align-items-end">
        <div class="col-sm-4 col-md-3">
          <label class="form-label">Responsable</label>
          <select id="ctrlRespId" class="form-select">
            <option value="">Seleccione un usuario…</option>
          </select>
        </div>
        <div class="col-sm-4 col-md-3">
          <label class="form-label">Observación</label>
          <input type="text" id="ctrlObs" class="form-control" placeholder="Notas opcionales">
        </div>
        <div class="col-sm-4 col-md-3">
          <label class="form-label">Foto (opcional)</label>
          <input type="file" id="ctrlFoto" class="form-control" accept="image/*">
        </div>
        <div class="col-md-3 d-flex gap-2">
          <button type="button" id="btnAsignarCtrl" class="btn btn-outline-primary">Asignar</button>
          <button type="button" id="btnInicioCtrl" class="btn btn-primary">Iniciar</button>
          <button type="button" id="btnFinCtrl" class="btn btn-success">Finalizar</button>
        </div>
      </div>
      <div class="mt-3 small text-muted" id="ctrlStatus">-</div>
    </div>
  </div>

  <div class="card mb-3" id="erroresCard">
    <div class="card-body">
      <div class="d-flex align-items-center mb-3">
        <h6 class="card-title m-0">Registro de errores</h6>
        <div class="ms-auto d-flex gap-2">
          <button type="button" id="btnRefreshErrores" class="btn btn-sm btn-outline-secondary">Actualizar</button>
        </div>
      </div>
      <form id="formErrorLog" class="row g-3 align-items-end">
        <div class="col-sm-6 col-md-3">
          <label class="form-label" for="errorMotivoId">Motivo</label>
          <select id="errorMotivoId" class="form-select" required>
            <option value="">Seleccione…</option>
          </select>
        </div>
        <div class="col-sm-6 col-md-3">
          <label class="form-label" for="errorRespId">Responsable</label>
          <select id="errorRespId" class="form-select">
            <option value="">Seleccione…</option>
          </select>
        </div>
        <div class="col-sm-6 col-md-3">
          <label class="form-label" for="errorRespNombre">Nombre responsable</label>
          <input type="text" id="errorRespNombre" class="form-control" placeholder="Completar si no está en la lista">
        </div>
        <div class="col-sm-6 col-md-3">
          <label class="form-label" for="errorFecha">Fecha y hora</label>
          <input type="datetime-local" id="errorFecha" class="form-control" required>
        </div>
        <div class="col-12">
          <label class="form-label" for="errorObservacion">Observación</label>
          <textarea id="errorObservacion" class="form-control" rows="2" placeholder="Detalle adicional (opcional)"></textarea>
        </div>
        <div class="col-12 d-flex gap-2">
          <button type="button" id="btnGuardarError" class="btn btn-danger">Registrar error</button>
          <button type="button" id="btnLimpiarError" class="btn btn-outline-secondary">Limpiar</button>
        </div>
      </form>
      <hr class="my-3">
      <div class="table-responsive">
        <table id="tblErrores" class="table table-sm table-striped w-100">
          <thead>
            <tr>
              <th>Fecha</th>
              <th>Motivo</th>
              <th>Responsable</th>
              <th>Observación</th>
            </tr>
          </thead>
          <tbody></tbody>
        </table>
      </div>
    </div>
  </div>

  <div class="card mb-3">
    <div class="card-body">
      <div class="position-relative mb-3">
        <h6 class="card-title m-0 text-center">Movimientos de preparación</h6>
        <a id="btnMovsPdf" class="btn btn-sm btn-info position-absolute end-0 top-0" href="#" target="_blank" rel="noopener" title="PDF con todos los movimientos de preparación y reposición">
          <i class="bi bi-filetype-pdf me-1"></i>PDF de movimientos
        </a>
      </div>
      <div class="table-responsive">
        <table id="tblMovs" class="table table-sm table-striped w-100">
          <thead><tr>
            <th>Fecha</th><th>Tipo</th><th>Motivo</th><th>Producto</th><th>Lote</th><th>Venc</th><th>Pallet</th><th>Desde</th><th>Hasta</th><th>UV</th><th>UC</th>
          </tr></thead>
          <tbody></tbody>
        </table>
      </div>
    </div>
  </div>
</div>
<?php
$content = ob_get_clean();
include project_path('views/layout/layout_app.php');
