<?php
declare(strict_types=1);

/**
 * SOL - Sistema de Operaciones Logísticas
 * Vista: views/testing/wh_in/index.php
 * - Formularios de pruebas (Paso 6) + Tablero de estado (Paso 7)
 * - Requiere config/db.php (PDO + Dotenv)
 */

/* ================== Helpers mínimos si la vista se invoca directo ================== */
$BASE = dirname(__DIR__, 3);
require_once $BASE . '/app/Support/ViewHelpers.php';
require_once $BASE . '/app/Support/Assets.php';

sol_section('page_title', 'Recepción · Productos recibidos por proveedor');
sol_dt_assets('/page-scripts/pages/recepcion/por_proveedor.js');

/* ================== Data del tablero (consultas) ================== */
require_once project_path('config/db.php');
$pdo = getPDO();

$depCode = isset($_GET['dep']) && $_GET['dep'] !== '' ? $_GET['dep'] : 'DEP1';
$q       = trim($_GET['q'] ?? '');
$likeQ   = '%' . $q . '%';

# Resolver depósito
$stmt = $pdo->prepare("SELECT id, code, nombre FROM wh_deposito WHERE code = ? LIMIT 1");
$stmt->execute([$depCode]);
$dep   = $stmt->fetch();
$depId = $dep['id'] ?? null;

if (!$depId) {
  $depId = (int)$pdo->query("SELECT id FROM wh_deposito ORDER BY id LIMIT 1")->fetchColumn();
  if ($depId) {
    $dep = $pdo->query("SELECT id, code, nombre FROM wh_deposito WHERE id = {$depId}")->fetch();
    $depCode = $dep['code'] ?? 'DEP1';
  }
}

# Estados útiles
$estEmbarcadoId = (int)($pdo->query("SELECT id FROM wh_pallet_estado WHERE code='EMBARCADO' LIMIT 1")->fetchColumn() ?: 0);

# KPI: totales
$kpi = [
  'pallets_total'     => 0,
  'pallets_cuarentena'=> 0,
  'pallets_pickeados' => 0,
  'posiciones_ocupadas'=> 0,
];

if ($depId) {
  $kpi['pallets_total'] = (int)$pdo->prepare("
    SELECT COUNT(*) FROM wh_pallet p
    WHERE p.deposito_id=? AND p.deleted_at IS NULL
      AND (? = 0 OR p.estado_id <> ?)
  ")->execute([$depId, $estEmbarcadoId, $estEmbarcadoId]) ?: 0;
  $kpi['pallets_total'] = (int)$pdo->query("SELECT FOUND_ROWS()")->fetchColumn();

  $stmt = $pdo->prepare("
    SELECT COUNT(*) FROM wh_pallet p
    JOIN wh_pallet_estado pe ON pe.id=p.estado_id
    WHERE p.deposito_id=? AND pe.code='CUARENTENA'
  "); $stmt->execute([$depId]);
  $kpi['pallets_cuarentena'] = (int)$stmt->fetchColumn();

  $stmt = $pdo->prepare("
    SELECT COUNT(*) FROM wh_pallet p
    WHERE p.deposito_id=? AND p.pickeado=1
      AND (? = 0 OR p.estado_id <> ?)
  "); $stmt->execute([$depId, $estEmbarcadoId, $estEmbarcadoId]);
  $kpi['pallets_pickeados'] = (int)$stmt->fetchColumn();

  $stmt = $pdo->prepare("
    SELECT COUNT(DISTINCT posicion_id)
    FROM wh_stock
    WHERE deposito_id=? AND (qty_uv>0 OR qty_uc>0)
  "); $stmt->execute([$depId]);
  $kpi['posiciones_ocupadas'] = (int)$stmt->fetchColumn();
}

# Listado: Stock por posición (con filtro q opcional)
$sqlStock = "
SELECT
  pos.code_full           AS posicion,
  pos.rack, pos.columna, pos.nivel, pos.fondo,
  s.producto_id,
  COALESCE(pr.denominacion, CONCAT('Producto #', s.producto_id)) AS producto,
  s.lote_id, l.codigo      AS lote,
  s.pallet_id, p.codigo    AS pallet,
  s.qty_uv, s.qty_uc, s.pickeado, s.updated_at
FROM wh_stock s
LEFT JOIN wh_posicion pos ON pos.id = s.posicion_id
LEFT JOIN para_productos pr ON pr.id = s.producto_id
LEFT JOIN wh_lote l ON l.id = s.lote_id
LEFT JOIN wh_pallet p ON p.id = s.pallet_id
WHERE s.deposito_id = :dep
";
$paramsStock = [':dep' => $depId];
if ($q !== '') {
  $sqlStock .= " AND (pos.code_full LIKE :q OR l.codigo LIKE :q OR p.codigo LIKE :q OR pr.denominacion LIKE :q) ";
  $paramsStock[':q'] = $likeQ;
}
$sqlStock .= " ORDER BY pos.rack, pos.columna, pos.nivel, pos.fondo, producto, lote LIMIT 200";
$stmt = $pdo->prepare($sqlStock);
$stmt->execute($paramsStock);
$rowsStock = $stmt->fetchAll();

# Listado: Pallets en Cuarentena
$stmt = $pdo->prepare("
SELECT p.codigo AS pallet, pe.code AS estado, pos.code_full AS posicion
FROM wh_pallet p
JOIN wh_pallet_estado pe ON pe.id=p.estado_id
LEFT JOIN wh_posicion pos ON pos.id=p.posicion_id
WHERE p.deposito_id=? AND pe.code='CUARENTENA'
ORDER BY p.id DESC LIMIT 200
"); $stmt->execute([$depId]);
$rowsCuarentena = $stmt->fetchAll();

# Listado: Últimos movimientos
$sqlMoves = "
SELECT m.id, m.tipo, m.motivo, m.delta_uv, m.delta_uc, m.created_at,
       p.codigo AS pallet,
       COALESCE(pr.denominacion, CONCAT('#', m.producto_id)) AS producto,
       l.codigo AS lote,
       fp.code_full AS from_pos, tp.code_full AS to_pos
FROM wh_move m
LEFT JOIN wh_pallet p   ON p.id = m.pallet_id
LEFT JOIN para_productos pr ON pr.id = m.producto_id
LEFT JOIN wh_lote l     ON l.id = m.lote_id
LEFT JOIN wh_posicion fp ON fp.id = m.from_pos_id
LEFT JOIN wh_posicion tp ON tp.id = m.to_pos_id
WHERE m.deposito_id=:dep
";
$paramsMoves = [':dep' => $depId];
if ($q !== '') {
  $sqlMoves .= " AND (p.codigo LIKE :q OR l.codigo LIKE :q OR fp.code_full LIKE :q OR tp.code_full LIKE :q OR m.motivo LIKE :q) ";
  $paramsMoves[':q'] = $likeQ;
}
$sqlMoves .= " ORDER BY m.id DESC LIMIT 50";
$stmt = $pdo->prepare($sqlMoves);
$stmt->execute($paramsMoves);
$rowsMoves = $stmt->fetchAll();

/* ================== Secciones / Layout ================== */
$usuarioNombre = (string)($_SESSION['usuario_nombre'] ?? '');
$saludo        = $usuarioNombre ? "Hola, {$usuarioNombre}" : "Bienvenido";
sol_section('page_title', 'Testing Warehouse · IN/MOVE/OUT + Estado');

$API = $BASE_URL . 'api/testing/wh_in.php';


sol_dt_assets('/page-scripts/pages/testing/wh_in_script.js');

/* ================== Contenido principal ================== */
ob_start();
?>
<style>
  .badge-chip{background:rgba(13,110,253,.1);color:#0d6efd;border:1px solid rgba(13,110,253,.25);padding:.18rem .5rem;border-radius:999px;font-weight:500}
  .kbd{border:1px solid rgba(0,0,0,.1);padding:.05rem .35rem;border-radius:4px;background:rgba(0,0,0,.04)}
  .table-sm td,.table-sm th{vertical-align:middle}
</style>

<div class="container py-4">
  <header class="mb-4">
    <h1 class="h3 mb-1">🧪 SOL · Testing Warehouse</h1>
    <div class="text-muted">API: <span class="kbd"><?= htmlspecialchars($API) ?></span></div>
  </header>

  <!-- ======= FILTROS DEL TABLERO ======= -->
  <form class="row gy-2 align-items-end mb-3" method="get">
    <div class="col-auto">
      <label class="form-label">Depósito</label>
      <input type="text" class="form-control" name="dep" value="<?= htmlspecialchars($depCode) ?>" placeholder="DEP1">
    </div>
    <div class="col-auto">
      <label class="form-label">Buscar</label>
      <input type="text" class="form-control" name="q" value="<?= htmlspecialchars($q) ?>" placeholder="pos/pallet/lote/producto">
    </div>
    <div class="col-auto d-flex gap-2">
      <button class="btn btn-outline-primary" type="submit">Filtrar</button>
      <a class="btn btn-outline-secondary" href="?dep=<?= urlencode($depCode) ?>">Limpiar</a>
      <button class="btn btn-outline-success" type="button" onclick="location.reload()">Refrescar</button>
    </div>
  </form>

  <!-- ======= KPIs ======= -->
  <div class="row g-3 mb-4">
    <div class="col-6 col-lg-3">
      <div class="card shadow-sm">
        <div class="card-body">
          <div class="text-muted small">Pallets</div>
          <div class="h4 mb-0"><?= (int)$kpi['pallets_total'] ?></div>
        </div>
      </div>
    </div>
    <div class="col-6 col-lg-3">
      <div class="card shadow-sm">
        <div class="card-body">
          <div class="text-muted small">En Cuarentena</div>
          <div class="h4 mb-0"><?= (int)$kpi['pallets_cuarentena'] ?></div>
        </div>
      </div>
    </div>
    <div class="col-6 col-lg-3">
      <div class="card shadow-sm">
        <div class="card-body">
          <div class="text-muted small">Pickeados</div>
          <div class="h4 mb-0"><?= (int)$kpi['pallets_pickeados'] ?></div>
        </div>
      </div>
    </div>
    <div class="col-6 col-lg-3">
      <div class="card shadow-sm">
        <div class="card-body">
          <div class="text-muted small">Posiciones ocupadas</div>
          <div class="h4 mb-0"><?= (int)$kpi['posiciones_ocupadas'] ?></div>
        </div>
      </div>
    </div>
  </div>

  <div class="row g-3">
    <!-- === BLOQUE: Ingreso (Paso 6) === -->
    <div class="col-12">
      <div class="card">
        <div class="card-header d-flex align-items-center justify-content-between">
          <div><strong>1) Ingreso a Cuarentena</strong> <span class="badge badge-chip">IN</span></div>
          <div class="small text-muted">Crea pallet + ítems y genera IN → CUARENTENA</div>
        </div>
        <div class="card-body">
          <form id="form-ingreso" class="row gy-2">
            <div class="col-md-2">
              <label class="form-label">Depósito</label>
              <input type="text" class="form-control" name="deposito_code" value="<?= htmlspecialchars($depCode) ?>" required>
            </div>
            <div class="col-md-3">
              <label class="form-label">Pallet código</label>
              <input type="text" class="form-control" name="pallet_codigo" value="PAL-TEST-001" required>
            </div>
            <div class="col-md-3">
              <label class="form-label">Posición (opcional)</label>
              <input type="text" class="form-control" name="pos_code" placeholder="p.ej. CUAR-01 (vacío = auto)">
            </div>
            <div class="col-md-2">
              <label class="form-label">Estado (opcional)</label>
              <input type="text" class="form-control" name="estado_code" placeholder="por defecto CUARENTENA">
            </div>
            <div class="col-md-2">
              <label class="form-label">Overwrite</label>
              <select class="form-select" name="overwrite">
                <option value="0" selected>0 (no)</option>
                <option value="1">1 (sí)</option>
              </select>
              <div class="form-text">Si el pallet ya existe</div>
            </div>

            <div class="col-12 pt-2">
              <div class="d-flex align-items-center gap-2 mb-2">
                <strong>Ítems del pallet</strong>
                <button type="button" class="btn btn-sm btn-outline-info" id="btn-add-item">+ Agregar ítem</button>
                <button type="button" class="btn btn-sm btn-outline-secondary" id="btn-fill-sample">Demo</button>
              </div>
              <div class="table-responsive">
                <table class="table table-sm align-middle table-inputs">
                  <thead>
                  <tr>
                    <th>Producto ID</th>
                    <th>Lote</th>
                    <th>F.Prod</th>
                    <th>F.Venc</th>
                    <th>UV (cajas)</th>
                    <th>UC (unid)</th>
                    <th></th>
                  </tr>
                  </thead>
                  <tbody id="items-body"></tbody>
                </table>
              </div>
            </div>

            <div class="col-12 d-flex gap-2">
              <button class="btn btn-primary" type="submit">Ingresar</button>
              <button class="btn btn-outline-warning" type="button" id="clear-ingreso">Limpiar</button>
            </div>
          </form>
        </div>
      </div>
    </div>

    <!-- === BLOQUE: Reposición (Paso 6) === -->
    <div class="col-12 col-lg-6">
      <div class="card h-100">
        <div class="card-header d-flex align-items-center justify-content-between">
          <div><strong>2) Reposición (MOVE)</strong> <span class="badge badge-chip">MOVE</span></div>
          <div class="small text-muted">Mueve pallet a posición destino</div>
        </div>
        <div class="card-body">
          <form id="form-move" class="row gy-2">
            <div class="col-md-4">
              <label class="form-label">Depósito</label>
              <input type="text" class="form-control" name="deposito_code" value="<?= htmlspecialchars($depCode) ?>" required>
            </div>
            <div class="col-md-4">
              <label class="form-label">Pallet</label>
              <input type="text" class="form-control" name="pallet_codigo" value="PAL-TEST-001" required>
            </div>
            <div class="col-md-4">
              <label class="form-label">Posición destino</label>
              <input type="text" class="form-control" name="to_pos_code" value="C01-N01-F1" required>
            </div>
            <div class="col-md-6">
              <label class="form-label">Motivo (opcional)</label>
              <input type="text" class="form-control" name="motivo" placeholder="UBICACION">
            </div>
            <div class="col-md-6">
              <label class="form-label">Estado destino (opcional)</label>
              <input type="text" class="form-control" name="estado_dest" placeholder="POS_ENTERO / POS_PICKEADO">
            </div>
            <div class="col-12">
              <button class="btn btn-info" type="submit">Reposicionar</button>
            </div>
          </form>
        </div>
      </div>
    </div>

    <!-- === BLOQUE: Salida parcial (Paso 6) === -->
    <div class="col-12 col-lg-6">
      <div class="card h-100">
        <div class="card-header d-flex align-items-center justify-content-between">
          <div><strong>3) Salida parcial</strong> <span class="badge badge-chip">OUT parcial</span></div>
          <div class="small text-muted">Descuenta UV/UC de un SKU/lote</div>
        </div>
        <div class="card-body">
          <form id="form-out-parcial" class="row gy-2">
            <div class="col-md-4">
              <label class="form-label">Depósito</label>
              <input type="text" class="form-control" name="deposito_code" value="<?= htmlspecialchars($depCode) ?>" required>
            </div>
            <div class="col-md-4">
              <label class="form-label">Pallet</label>
              <input type="text" class="form-control" name="pallet_codigo" value="PAL-TEST-001" required>
            </div>
            <div class="col-md-4">
              <label class="form-label">Producto ID</label>
              <input type="number" class="form-control" name="producto_id" value="1" required>
            </div>
            <div class="col-md-6">
              <label class="form-label">Lote</label>
              <input type="text" class="form-control" name="lote_codigo" value="L-TEST-01" required>
            </div>
            <div class="col-md-3">
              <label class="form-label">UV (cajas)</label>
              <input type="number" class="form-control" name="delta_uv" value="1" min="0" required>
            </div>
            <div class="col-md-3">
              <label class="form-label">UC (unid)</label>
              <input type="number" class="form-control" name="delta_uc" value="0" min="0" required>
            </div>
            <div class="col-md-12">
              <label class="form-label">Referencia (opcional)</label>
              <input type="text" class="form-control" name="referencia" placeholder="PICKING">
            </div>
            <div class="col-12">
              <button class="btn btn-warning" type="submit">Salida parcial</button>
            </div>
          </form>
        </div>
      </div>
    </div>

    <!-- === BLOQUE: Salida total (Paso 6) === -->
    <div class="col-12">
      <div class="card">
        <div class="card-header d-flex align-items-center justify-content-between">
          <div><strong>4) Salida total</strong> <span class="badge badge-chip">OUT total</span></div>
          <div class="small text-muted">Despacha pallet completo</div>
        </div>
        <div class="card-body">
          <form id="form-out-total" class="row gy-2">
            <div class="col-md-3">
              <label class="form-label">Depósito</label>
              <input type="text" class="form-control" name="deposito_code" value="<?= htmlspecialchars($depCode) ?>" required>
            </div>
            <div class="col-md-4">
              <label class="form-label">Pallet</label>
              <input type="text" class="form-control" name="pallet_codigo" value="PAL-TEST-001" required>
            </div>
            <div class="col-md-5">
              <label class="form-label">Referencia (opcional)</label>
              <input type="text" class="form-control" name="referencia" placeholder="DESPACHO">
            </div>
            <div class="col-12">
              <button class="btn btn-danger" type="submit">Salida total</button>
            </div>
          </form>
        </div>
      </div>
    </div>

    <!-- === CONSOLA === -->
    <div class="col-12">
      <div class="card">
        <div class="card-header"><strong>Consola</strong> <span class="text-muted">(respuesta JSON de la API)</span></div>
        <div class="card-body">
          <pre id="console">Listo para ejecutar…</pre>
        </div>
      </div>
    </div>

    <!-- === TABLAS DE ESTADO (PASO 7) === -->
    <div class="col-12">
      <div class="card">
        <div class="card-header d-flex justify-content-between align-items-center">
          <strong>Stock por posición (<?= htmlspecialchars($dep['code'] ?? '') ?>)</strong>
          <small class="text-muted">Máx. 200 filas · orden por rack/col/nivel/fondo</small>
        </div>
        <div class="card-body table-responsive">
          <table class="table table-sm table-striped align-middle">
            <thead>
            <tr>
              <th>Posición</th>
              <th>Producto</th>
              <th>Lote</th>
              <th>Pallet</th>
              <th class="text-end">UV</th>
              <th class="text-end">UC</th>
              <th>Pickeado</th>
              <th>Actualizado</th>
            </tr>
            </thead>
            <tbody>
            <?php if (!$rowsStock): ?>
              <tr><td colspan="8" class="text-muted">Sin datos.</td></tr>
            <?php else: foreach ($rowsStock as $r): ?>
              <tr>
                <td><?= htmlspecialchars($r['posicion'] ?? '') ?></td>
                <td><?= htmlspecialchars($r['producto'] ?? ('#'.$r['producto_id'])) ?></td>
                <td><?= htmlspecialchars($r['lote'] ?? '') ?></td>
                <td><span class="kbd"><?= htmlspecialchars($r['pallet'] ?? '') ?></span></td>
                <td class="text-end"><?= (int)$r['qty_uv'] ?></td>
                <td class="text-end"><?= (int)$r['qty_uc'] ?></td>
                <td><?= (int)$r['pickeado'] ? 'Sí' : 'No' ?></td>
                <td><small class="text-muted"><?= htmlspecialchars($r['updated_at']) ?></small></td>
              </tr>
            <?php endforeach; endif; ?>
            </tbody>
          </table>
        </div>
      </div>
    </div>

    <div class="col-12 col-lg-12">
      <div class="card h-100">
        <div class="card-header"><strong>Pallets en Cuarentena</strong></div>
        <div class="card-body table-responsive">
          <table class="table table-sm table-striped">
            <thead><tr><th>Pallet</th><th>Estado</th><th>Posición</th></tr></thead>
            <tbody>
            <?php if (!$rowsCuarentena): ?>
              <tr><td colspan="3" class="text-muted">Sin pallets en Cuarentena.</td></tr>
            <?php else: foreach ($rowsCuarentena as $r): ?>
              <tr>
                <td><span class="kbd"><?= htmlspecialchars($r['pallet']) ?></span></td>
                <td><?= htmlspecialchars($r['estado']) ?></td>
                <td><?= htmlspecialchars($r['posicion']) ?></td>
              </tr>
            <?php endforeach; endif; ?>
            </tbody>
          </table>
        </div>
      </div>
    </div>

    <div class="col-12 col-lg-12">
      <div class="card h-100">
        <div class="card-header d-flex justify-content-between align-items-center">
          <strong>Últimos movimientos</strong>
          <small class="text-muted">Límite 50</small>
        </div>
        <div class="card-body table-responsive">
          <table class="table table-sm table-striped">
            <thead>
              <tr>
                <th>#</th><th>Tipo</th><th>Motivo</th><th>Pallet</th><th>Producto</th><th>Lote</th>
                <th>Desde</th><th>Hacia</th><th class="text-end">ΔUV</th><th class="text-end">ΔUC</th><th>Fecha</th>
              </tr>
            </thead>
            <tbody>
            <?php if (!$rowsMoves): ?>
              <tr><td colspan="11" class="text-muted">Sin movimientos aún.</td></tr>
            <?php else: foreach ($rowsMoves as $m): ?>
              <tr>
                <td><?= (int)$m['id'] ?></td>
                <td><?= htmlspecialchars($m['tipo']) ?></td>
                <td><?= htmlspecialchars($m['motivo'] ?? '') ?></td>
                <td><span class="kbd"><?= htmlspecialchars($m['pallet'] ?? '') ?></span></td>
                <td><?= htmlspecialchars($m['producto'] ?? '') ?></td>
                <td><?= htmlspecialchars($m['lote'] ?? '') ?></td>
                <td><?= htmlspecialchars($m['from_pos'] ?? '') ?></td>
                <td><?= htmlspecialchars($m['to_pos'] ?? '') ?></td>
                <td class="text-end"><?= (int)$m['delta_uv'] ?></td>
                <td class="text-end"><?= (int)$m['delta_uc'] ?></td>
                <td><small class="text-muted"><?= htmlspecialchars($m['created_at']) ?></small></td>
              </tr>
            <?php endforeach; endif; ?>
            </tbody>
          </table>
        </div>
      </div>
    </div>

  </div><!-- row -->

</div><!-- container -->

<script>
  const API = <?= json_encode($API) ?>;


</script>

<?php
$content = ob_get_clean();
include project_path('views/layout/layout_app.php');
