<?php
declare(strict_types=1);

/**
 * SOL - Sistema de Operaciones Logísticas
 * Vista: views/control/dashboard/index.php
 * - Home/Dashboard básico montado sobre layout_app.php (gate centralizado).
 */

// -----------------------------------------------------------
// Helpers de secciones/stacks (por si la vista se invoca directa)
// -----------------------------------------------------------

$BASE = dirname(__DIR__, 3);
require_once $BASE . '/app/Support/ViewHelpers.php';
require_once $BASE . '/app/Support/Assets.php';

sol_section('page_title', 'Recepción · Productos recibidos por proveedor');
sol_dt_assets('/page-scripts/pages/recepcion/por_proveedor.js');

// -----------------------------------------------------------
// Secciones/stacks del layout
// -----------------------------------------------------------
$usuarioNombre = (string)($_SESSION['usuario_nombre'] ?? '');
$saludo        = $usuarioNombre ? "Hola, {$usuarioNombre}" : "Bienvenido";

sol_section('page_title', 'Dashboard');

$API = $BASE_URL . 'api/testing/wh_in.php';


// Si tienes JS/CSS propios de la página, puedes “pushear” arrays compatibles con el layout:

sol_dt_assets('/page-scripts/pages/testing/wh_in_script.js');


// -----------------------------------------------------------
// Contenido principal -> $content
// -----------------------------------------------------------
ob_start();
?>
<div class="container py-4">
  <header class="mb-4">
    <h1 class="h3 mb-1">🧪 SOL · Testing Warehouse</h1>
    <div class="text-muted">API: <span class="kbd"><?= htmlspecialchars($API) ?></span></div>
  </header>

  <div class="row g-3">

    <!-- Ingreso -->
    <div class="col-12">
      <div class="card">
        <div class="card-header d-flex align-items-center justify-content-between">
          <div><strong>1) Ingreso a Cuarentena</strong> <span class="badge badge-chip">IN</span></div>
          <div class="small text-muted">Crea pallet + ítems y genera IN → CUARENTENA</div>
        </div>
        <div class="card-body">
          <form id="form-ingreso" class="row gy-2">
            <div class="col-md-2">
              <label class="form-label">Depósito</label>
              <input type="text" class="form-control" name="deposito_code" value="DEP1" required>
            </div>
            <div class="col-md-3">
              <label class="form-label">Pallet código</label>
              <input type="text" class="form-control" name="pallet_codigo" value="PAL-TEST-001" required>
            </div>
            <div class="col-md-3">
              <label class="form-label">Posición (opcional)</label>
              <input type="text" class="form-control" name="pos_code" placeholder="p.ej. CUAR-01 (vacío = auto)">
            </div>
            <div class="col-md-2">
              <label class="form-label">Estado (opcional)</label>
              <input type="text" class="form-control" name="estado_code" placeholder="por defecto CUARENTENA">
            </div>
            <div class="col-md-2">
              <label class="form-label">Overwrite</label>
              <select class="form-select" name="overwrite">
                <option value="0" selected>0 (no)</option>
                <option value="1">1 (sí)</option>
              </select>
              <div class="form-text">Si el pallet ya existe</div>
            </div>

            <div class="col-12 pt-2">
              <div class="d-flex align-items-center gap-2 mb-2">
                <strong>Ítems del pallet</strong>
                <button type="button" class="btn btn-sm btn-outline-info" id="btn-add-item">+ Agregar ítem</button>
                <button type="button" class="btn btn-sm btn-outline-secondary" id="btn-fill-sample">Demo</button>
              </div>
              <div class="table-responsive">
                <table class="table table-sm align-middle table-inputs">
                  <thead>
                  <tr>
                    <th>Producto ID</th>
                    <th>Lote</th>
                    <th>F.Prod</th>
                    <th>F.Venc</th>
                    <th>UV (cajas)</th>
                    <th>UC (unid)</th>
                    <th></th>
                  </tr>
                  </thead>
                  <tbody id="items-body"></tbody>
                </table>
              </div>
            </div>

            <div class="col-12 d-flex gap-2">
              <button class="btn btn-primary" type="submit">Ingresar</button>
              <button class="btn btn-outline-warning" type="button" id="clear-ingreso">Limpiar</button>
            </div>
          </form>
        </div>
      </div>
    </div>

    <!-- Reposición -->
    <div class="col-12 col-lg-6">
      <div class="card h-100">
        <div class="card-header d-flex align-items-center justify-content-between">
          <div><strong>2) Reposición (MOVE)</strong> <span class="badge badge-chip">MOVE</span></div>
          <div class="small text-muted">Mueve pallet a posición destino</div>
        </div>
        <div class="card-body">
          <form id="form-move" class="row gy-2">
            <div class="col-md-4">
              <label class="form-label">Depósito</label>
              <input type="text" class="form-control" name="deposito_code" value="DEP1" required>
            </div>
            <div class="col-md-4">
              <label class="form-label">Pallet</label>
              <input type="text" class="form-control" name="pallet_codigo" value="PAL-TEST-001" required>
            </div>
            <div class="col-md-4">
              <label class="form-label">Posición destino</label>
              <input type="text" class="form-control" name="to_pos_code" value="C01-N01-F1" required>
            </div>
            <div class="col-md-6">
              <label class="form-label">Motivo (opcional)</label>
              <input type="text" class="form-control" name="motivo" placeholder="UBICACION">
            </div>
            <div class="col-md-6">
              <label class="form-label">Estado destino (opcional)</label>
              <input type="text" class="form-control" name="estado_dest" placeholder="POS_ENTERO / POS_PICKEADO">
            </div>
            <div class="col-12">
              <button class="btn btn-info" type="submit">Reposicionar</button>
            </div>
          </form>
        </div>
      </div>
    </div>

    <!-- Salida parcial -->
    <div class="col-12 col-lg-6">
      <div class="card h-100">
        <div class="card-header d-flex align-items-center justify-content-between">
          <div><strong>3) Salida parcial</strong> <span class="badge badge-chip">OUT parcial</span></div>
          <div class="small text-muted">Descuenta UV/UC de un SKU/lote</div>
        </div>
        <div class="card-body">
          <form id="form-out-parcial" class="row gy-2">
            <div class="col-md-4">
              <label class="form-label">Depósito</label>
              <input type="text" class="form-control" name="deposito_code" value="DEP1" required>
            </div>
            <div class="col-md-4">
              <label class="form-label">Pallet</label>
              <input type="text" class="form-control" name="pallet_codigo" value="PAL-TEST-001" required>
            </div>
            <div class="col-md-4">
              <label class="form-label">Producto ID</label>
              <input type="number" class="form-control" name="producto_id" value="1" required>
            </div>
            <div class="col-md-6">
              <label class="form-label">Lote</label>
              <input type="text" class="form-control" name="lote_codigo" value="L-TEST-01" required>
            </div>
            <div class="col-md-3">
              <label class="form-label">UV (cajas)</label>
              <input type="number" class="form-control" name="delta_uv" value="1" min="0" required>
            </div>
            <div class="col-md-3">
              <label class="form-label">UC (unid)</label>
              <input type="number" class="form-control" name="delta_uc" value="0" min="0" required>
            </div>
            <div class="col-md-12">
              <label class="form-label">Referencia (opcional)</label>
              <input type="text" class="form-control" name="referencia" placeholder="PICKING">
            </div>
            <div class="col-12">
              <button class="btn btn-warning" type="submit">Salida parcial</button>
            </div>
          </form>
        </div>
      </div>
    </div>

    <!-- Salida total -->
    <div class="col-12">
      <div class="card">
        <div class="card-header d-flex align-items-center justify-content-between">
          <div><strong>4) Salida total</strong> <span class="badge badge-chip">OUT total</span></div>
          <div class="small text-muted">Despacha pallet completo</div>
        </div>
        <div class="card-body">
          <form id="form-out-total" class="row gy-2">
            <div class="col-md-3">
              <label class="form-label">Depósito</label>
              <input type="text" class="form-control" name="deposito_code" value="DEP1" required>
            </div>
            <div class="col-md-4">
              <label class="form-label">Pallet</label>
              <input type="text" class="form-control" name="pallet_codigo" value="PAL-TEST-001" required>
            </div>
            <div class="col-md-5">
              <label class="form-label">Referencia (opcional)</label>
              <input type="text" class="form-control" name="referencia" placeholder="DESPACHO">
            </div>
            <div class="col-12">
              <button class="btn btn-danger" type="submit">Salida total</button>
            </div>
          </form>
        </div>
      </div>
    </div>

    <!-- Consola de resultados -->
    <div class="col-12">
      <div class="card">
        <div class="card-header"><strong>Consola</strong> <span class="text-muted">(respuesta JSON)</span></div>
        <div class="card-body">
          <pre id="console">Listo para ejecutar…</pre>
        </div>
      </div>
    </div>

  </div>
</div>

<?php
$content = ob_get_clean();
include project_path('views/layout/layout_app.php');